/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.IGradlePropertiesLoader;

public class SystemPropertySettingGradlePropertiesLoader
implements IGradlePropertiesLoader {
    private final IGradlePropertiesLoader delegate;
    private final StartParameterInternal startParameter;

    public SystemPropertySettingGradlePropertiesLoader(IGradlePropertiesLoader delegate, StartParameterInternal startParameter) {
        this.delegate = delegate;
        this.startParameter = startParameter;
    }

    public GradleProperties loadGradleProperties(File rootDir) {
        GradleProperties gradleProperties = this.delegate.loadGradleProperties(rootDir);
        Map properties = gradleProperties.mergeProperties(Collections.emptyMap());
        this.addSystemPropertiesFromGradleProperties(properties);
        System.getProperties().putAll(this.startParameter.getSystemPropertiesArgs());
        return gradleProperties;
    }

    private void addSystemPropertiesFromGradleProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            if (!key.startsWith("systemProp.")) continue;
            System.setProperty(key.substring("systemProp.".length()), properties.get(key));
        }
    }
}

