/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.properties.locator;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.blade.cli.util.ArrayUtil;
import com.liferay.blade.cli.util.CamelCaseUtil;
import com.liferay.blade.cli.util.ListUtil;
import com.liferay.blade.cli.util.Pair;
import com.liferay.blade.cli.util.StringUtil;
import com.liferay.properties.locator.ConfigurationClassData;
import com.liferay.properties.locator.PropertiesLocatorArgs;
import com.liferay.properties.locator.PropertyProblem;
import com.liferay.properties.locator.PropertyProblemType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PropertiesLocator {
    private static final String[] _COMMON_PREFIXES = new String[]{"asset", "dynamic.data.lists", "dynamic.data.mapping", "journal", "audit", "auth", "blogs", "bookmarks", "cas", "journal", "wiki"};
    private static final String _PORTAL_IMPL_LEGACY_RELATIVE_PATH = File.separator + "WEB-INF" + File.separator + "lib" + File.separator + "portal-impl.jar";
    private static final String _PORTAL_IMPL_SHIELDED_LIB_RELATIVE_PATH = File.separator + "WEB-INF" + File.separator + "shielded-container-lib" + File.separator + "portal-impl.jar";
    private static Path _bundlePath;
    private static final Map<String, String> _portletNameEquivalences;
    private SortedSet<PropertyProblem> _problems = Collections.emptySortedSet();

    public static void main(String[] args) throws Exception {
        PropertiesLocatorArgs propertiesLocatorArgs = new PropertiesLocatorArgs();
        JCommander jCommander = new JCommander(propertiesLocatorArgs);
        try {
            File jarFile = PropertiesLocator._getJarFile();
            if (jarFile.isFile()) {
                jCommander.setProgramName("java -jar " + jarFile.getName());
            } else {
                jCommander.setProgramName(PropertiesLocator.class.getName());
            }
            jCommander.parse(args);
            if (propertiesLocatorArgs.isHelp()) {
                jCommander.usage();
            } else {
                new PropertiesLocator(propertiesLocatorArgs);
            }
        }
        catch (ParameterException parameterException) {
            System.err.println(parameterException.getMessage());
            jCommander.usage();
        }
    }

    public PropertiesLocator(PropertiesLocatorArgs propertiesLocatorArgs) throws Exception {
        try (PrintWriter outputWriter = this._getOutputWriter(propertiesLocatorArgs);){
            Set<String> oldPropertyKeys = this._getPropertyKeys(propertiesLocatorArgs.getPropertiesFile());
            File bundleDir = propertiesLocatorArgs.getBundleDir();
            bundleDir = bundleDir.getAbsoluteFile();
            _bundlePath = bundleDir.toPath();
            Properties newProperties = this._getCurrentPortalProperties();
            this._problems = this._getProblems(oldPropertyKeys, newProperties);
            this._manageExceptions(this._problems);
            this._managePortletProperties(this._problems);
            this._manageConfigurationProperties(this._problems);
            this._printInfo(outputWriter, this._problems);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public SortedSet<PropertyProblem> getProblems() {
        return this._problems;
    }

    private static File _getJarFile() throws Exception {
        ProtectionDomain protectionDomain = PropertiesLocator.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        return new File(url.toURI());
    }

    private static boolean _isLiferayJar(String path) {
        return path.endsWith(".jar") && path.contains("com.liferay");
    }

    private String[] _addConfigurationPropertiesByInheritance(String superClass, String[] configFields, Map<String, ConfigurationClassData> configClassesMap) {
        if (!superClass.equals("java/lang/Object")) {
            ConfigurationClassData superClassData = configClassesMap.get(superClass);
            String[] superConfigFields = new String[]{};
            if (superClassData != null) {
                superConfigFields = this._addConfigurationPropertiesByInheritance(superClassData.getSuperClass(), superClassData.getConfigFields(), configClassesMap);
            }
            return ArrayUtil.append(configFields, superConfigFields);
        }
        return configFields;
    }

    private List<Pair<String, String>> _filterMostLikelyMatches(String property, String[] portletNames, List<Pair<String, String>> mostLikelyMatches) {
        ArrayList<Pair<String, String>> theMostLikelyMatches = new ArrayList<Pair<String, String>>();
        String[] portletNameAsProperty = new String[]{this._getPortletNameAsProperty(portletNames)};
        for (Pair<String, String> match : mostLikelyMatches) {
            if (!this._pathContainsPortletName(match.first(), portletNameAsProperty)) continue;
            theMostLikelyMatches.add(new Pair<String, String>(match.first(), match.second()));
        }
        if (!theMostLikelyMatches.isEmpty()) {
            mostLikelyMatches = theMostLikelyMatches;
            theMostLikelyMatches = new ArrayList();
        }
        for (Pair<String, String> match : mostLikelyMatches) {
            if (!this._matchSuffix(property, match.second())) continue;
            theMostLikelyMatches.add(new Pair<String, String>(match.first(), match.second()));
        }
        if (!theMostLikelyMatches.isEmpty()) {
            return theMostLikelyMatches;
        }
        return mostLikelyMatches;
    }

    private void _getCommentedPropertiesFromJar(String propertiesJarURL, Properties properties) throws Exception {
        URL url = new URL(propertiesJarURL);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));){
            bufferedReader.lines().filter(line -> line.matches(".*#[a-zA-Z\\.\\[\\]]+=.*")).map(line -> line.substring(line.indexOf("#") + 1, line.indexOf("="))).forEach(line -> properties.put(line, ""));
        }
        catch (Exception exception) {
            System.err.println("Unable to read properties file from jar " + propertiesJarURL);
            throw exception;
        }
    }

    private List<Pair<String, String[]>> _getConfigurationProperties(Map<String, ConfigurationClassData> configClassesMap) {
        ArrayList<Pair<String, String[]>> configurationProperties = new ArrayList<Pair<String, String[]>>();
        for (Map.Entry<String, ConfigurationClassData> configClass : configClassesMap.entrySet()) {
            ConfigurationClassData configClassData = configClass.getValue();
            String[] allConfigFields = this._addConfigurationPropertiesByInheritance(configClassData.getSuperClass(), configClassData.getConfigFields(), configClassesMap);
            if (allConfigFields.length <= 0) continue;
            String className = configClass.getKey();
            configurationProperties.add(new Pair<String, String[]>(className, allConfigFields));
        }
        return configurationProperties;
    }

    private Properties _getCurrentPortalProperties() throws Exception {
        Properties properties = new Properties();
        BiPredicate<Path, BasicFileAttributes> matcher = (path, attrs) -> {
            String pathString = path.toString();
            return attrs.isRegularFile() && (pathString.endsWith(_PORTAL_IMPL_SHIELDED_LIB_RELATIVE_PATH) || pathString.endsWith(_PORTAL_IMPL_LEGACY_RELATIVE_PATH));
        };
        try (Stream<Path> paths = Files.find(_bundlePath, Integer.MAX_VALUE, matcher, new FileVisitOption[0]);){
            Optional<Path> portalImplPath = paths.findFirst();
            portalImplPath.ifPresent(path -> {
                try {
                    this._getPropertiesFromJar("jar:file:" + path.toString() + "!/portal.properties", properties);
                    this._getCommentedPropertiesFromJar("jar:file:" + path.toString() + "!/portal.properties", properties);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        this._removeScopedProperties(properties);
        if (properties.isEmpty()) {
            throw new Exception("File portal.properties does not exist in " + _bundlePath);
        }
        return properties;
    }

    private String _getEquivalence(String portletName) {
        String equivalence = _portletNameEquivalences.get(portletName);
        if (equivalence != null) {
            return equivalence;
        }
        return portletName;
    }

    private List<Pair<String, String>> _getMostLikelyMatches(String property, List<Pair<String, String[]>> matches, String[] portletNames) {
        List<Pair<String, String>> mostLikelyMatches = new ArrayList<Pair<String, String>>();
        int maxOccurrences = 2;
        for (Pair<String, String[]> match : matches) {
            for (String matchProperty : match.second()) {
                if (!this._match(property, matchProperty, match.first(), maxOccurrences, portletNames)) continue;
                int occurrences = this._getOccurrences(property, matchProperty);
                if (occurrences > maxOccurrences) {
                    mostLikelyMatches.clear();
                    maxOccurrences = occurrences;
                }
                mostLikelyMatches.add(new Pair<String, String>(match.first(), matchProperty));
            }
        }
        if (!mostLikelyMatches.isEmpty()) {
            mostLikelyMatches = this._filterMostLikelyMatches(property, portletNames, mostLikelyMatches);
        }
        return mostLikelyMatches;
    }

    private int _getOccurrences(String originalProperty, String property) {
        String originalPropertyWithoutPrefix = this._removeCommonPrefix(originalProperty);
        if (!property.contains(".")) {
            property = CamelCaseUtil.fromCamelCase(property, ".".charAt(0));
        }
        String[] propertyWords = StringUtil.split(property, ".");
        String[] originalPropertyWords = StringUtil.split(originalPropertyWithoutPrefix, ".");
        List<String> originalPropertyWordsList = ListUtil.fromArray(originalPropertyWords);
        int numOccurrences = 0;
        for (String word : propertyWords) {
            if (!originalPropertyWordsList.contains(word)) continue;
            ++numOccurrences;
        }
        return numOccurrences;
    }

    private PrintWriter _getOutputWriter(PropertiesLocatorArgs propertiesLocatorArgs) throws FileNotFoundException {
        File outputFile = propertiesLocatorArgs.getOutputFile();
        if (outputFile != null) {
            return new PrintWriter(outputFile);
        }
        if (propertiesLocatorArgs.isQuiet()) {
            return new PrintWriter(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
        }
        return new PrintWriter(System.out);
    }

    private String _getPortletNameAsProperty(String[] portletNames) {
        String portletNameAsProperty = "";
        for (String portletName : portletNames) {
            if (portletNameAsProperty.length() > 0) {
                portletNameAsProperty = portletNameAsProperty + ".";
            }
            portletNameAsProperty = portletNameAsProperty + portletName;
        }
        return portletNameAsProperty;
    }

    private String[] _getPortletNames(String property) {
        String[] portletNames = new String[]{};
        int index = 0;
        while (portletNames.length < 2 && index != -1) {
            String portletName;
            index = property.indexOf(".");
            if (index == -1) {
                portletName = property;
            } else {
                portletName = property.substring(0, index);
                property = property.substring(index + 1);
            }
            portletNames = ArrayUtil.append(portletNames, portletName);
        }
        return portletNames;
    }

    private SortedSet<PropertyProblem> _getProblems(Set<String> oldPropertyKeys, Properties newProperties) {
        TreeSet<PropertyProblem> problems = new TreeSet<PropertyProblem>();
        for (String oldPropertyKey : oldPropertyKeys) {
            if (oldPropertyKey.contains("[")) {
                oldPropertyKey = oldPropertyKey.substring(0, oldPropertyKey.indexOf("["));
            }
            if (newProperties.getProperty(oldPropertyKey) == null) {
                problems.add(new PropertyProblem(oldPropertyKey, PropertyProblemType.MISSING));
                continue;
            }
            problems.add(new PropertyProblem(oldPropertyKey, PropertyProblemType.NONE));
        }
        return problems;
    }

    private void _getPropertiesFromJar(String propertiesJarURL, Properties properties) throws Exception {
        try {
            URL url = new URL(propertiesJarURL);
            InputStream is = url.openStream();
            properties.load(is);
            is.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to read properties file " + propertiesJarURL);
            throw exception;
        }
    }

    private Set<String> _getPropertyKeys(File file) throws Exception {
        try {
            List<String> lines = Files.readAllLines(file.toPath());
            return lines.stream().map(String::trim).filter(line -> !line.startsWith("#") && !line.equals("") && line.contains("=") && line.contains(".")).map(line -> line.substring(0, line.indexOf("="))).collect(Collectors.toSet());
        }
        catch (Exception exception) {
            System.out.println("Unable to read properties file " + file.getCanonicalPath());
            throw exception;
        }
    }

    private void _manageConfigurationProperties(SortedSet<PropertyProblem> problems) throws IOException {
        TreeMap<String, ConfigurationClassData> configClassesMap = new TreeMap<String, ConfigurationClassData>();
        try (Stream<Path> paths = Files.walk(_bundlePath, new FileVisitOption[0]);){
            Stream<File> files = paths.map(path -> path.toFile());
            files.filter(file -> {
                String absolutePath = file.getAbsolutePath();
                return (absolutePath.endsWith(".jar") || absolutePath.endsWith(".lpkg")) && !absolutePath.contains("/osgi/state/");
            }).forEach(file -> {
                block46: {
                    try {
                        String absolutePath = file.getAbsolutePath();
                        if (PropertiesLocator._isLiferayJar(absolutePath)) {
                            FileInputStream inputStream = new FileInputStream(absolutePath);
                            try (JarInputStream jarIs = new JarInputStream(inputStream);){
                                ZipEntry zipEntryJar = jarIs.getNextEntry();
                                while (zipEntryJar != null) {
                                    String name = zipEntryJar.getName();
                                    if (name.endsWith("Configuration.class")) {
                                        configClassesMap.put(name.replace(".class", ""), new ConfigurationClassData(jarIs));
                                    }
                                    zipEntryJar = jarIs.getNextEntry();
                                }
                                break block46;
                            }
                            catch (Exception exception) {
                                System.out.println("Unable to read the content of " + absolutePath);
                                return;
                            }
                        }
                        if (!absolutePath.endsWith(".lpkg")) break block46;
                        try (ZipFile zipFile = new ZipFile(absolutePath);){
                            Enumeration<? extends ZipEntry> enu = zipFile.entries();
                            while (enu.hasMoreElements()) {
                                ZipEntry zipEntry = enu.nextElement();
                                if (!PropertiesLocator._isLiferayJar(zipEntry.getName())) continue;
                                InputStream inputStream = zipFile.getInputStream(zipEntry);
                                try {
                                    JarInputStream jarIs = new JarInputStream(inputStream);
                                    Throwable throwable = null;
                                    try {
                                        ZipEntry zipEntryJar = jarIs.getNextEntry();
                                        while (zipEntryJar != null) {
                                            String name = zipEntryJar.getName();
                                            if (name.endsWith("Configuration.class")) {
                                                configClassesMap.put(name.replace(".class", ""), new ConfigurationClassData(jarIs));
                                            }
                                            zipEntryJar = jarIs.getNextEntry();
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        if (jarIs == null) continue;
                                        if (throwable != null) {
                                            try {
                                                jarIs.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            continue;
                                        }
                                        jarIs.close();
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Unable to get portlet properties");
                        return;
                    }
                }
            });
        }
        List<Pair<String, String[]>> configurationProperties = this._getConfigurationProperties(configClassesMap);
        problems.stream().filter(problem -> problem.getType() == PropertyProblemType.MISSING).forEach(problem -> {
            String property = problem.getPropertyName();
            List<Pair<String, String>> mostLikelyMatches = this._getMostLikelyMatches(property, configurationProperties, this._getPortletNames(property));
            if (!mostLikelyMatches.isEmpty()) {
                problem.setReplacements(mostLikelyMatches);
                problem.setType(PropertyProblemType.OSGI);
            }
        });
    }

    private void _manageExceptions(SortedSet<PropertyProblem> problems) {
        for (PropertyProblem problem : problems) {
            if (problem.getType() != PropertyProblemType.MISSING) continue;
            String property = problem.getPropertyName();
            if (property.endsWith("display.templates.config") && !property.equals("blogs.display.templates.config") && !property.equals("dl.display.templates.config")) {
                problem.setMessage("Overwrite the method in the ADT handler. See LPS-67466");
                problem.setType(PropertyProblemType.REMOVED);
                continue;
            }
            if (property.endsWith("breadcrumb.display.style.default")) {
                problem.setMessage("Use ddmTemplateKeyDefault in com.liferay.site.navigation.breadcrumb.web.internal.configuration.SiteNavigationBreadcrumbWebTemplateConfiguration. More information at Breaking Changes for Liferay 7: https://dev.liferay.com/develop/reference/-/knowledge_base/7-0/breaking-changes#replaced-the-breadcrumb-portlets-display-styles-with-adts");
                problem.setType(PropertyProblemType.OSGI);
                continue;
            }
            if (property.endsWith("breadcrumb.display.style.options")) {
                problem.setMessage("Any DDM template as ddmTemplate_BREADCRUMB-HORIZONTAL-FTL can be used. More information at Breaking Changes for Liferay 7: https://dev.liferay.com/develop/reference/-/knowledge_base/7-0/breaking-changes#replaced-the-breadcrumb-portlets-display-styles-with-adts");
                problem.setType(PropertyProblemType.REMOVED);
                continue;
            }
            if (!property.startsWith("upgrade.processes")) continue;
            problem.setMessage("Upgrade process properties are not longer needed");
            problem.setType(PropertyProblemType.REMOVED);
        }
    }

    private void _managePortletProperties(SortedSet<PropertyProblem> problems) throws Exception {
        ArrayList portletsProperties = new ArrayList();
        Predicate<Path> ignoreStateFilter = p -> {
            String path = p.toString();
            return !path.contains("/osgi/state/");
        };
        Predicate<Path> lpkgFilter = p -> {
            String path = p.toString();
            return path.endsWith(".lpkg");
        };
        Path searchPathRoot = _bundlePath.resolve("osgi");
        try (Stream<Path> paths = Files.walk(searchPathRoot, new FileVisitOption[0]);){
            Stream<Path> filter = paths.filter(ignoreStateFilter);
            filter.map(jarPath -> jarPath.toAbsolutePath()).map(absolutePath -> absolutePath.toString()).filter(PropertiesLocator::_isLiferayJar).forEach(absolutePath -> {
                try (JarFile jarFile = new JarFile((String)absolutePath);){
                    JarEntry portletPropertiesFile = jarFile.getJarEntry("portlet.properties");
                    Properties portletProperties = new Properties();
                    if (portletPropertiesFile != null) {
                        this._getPropertiesFromJar("jar:file:" + absolutePath + "!/portlet.properties", portletProperties);
                    }
                    Enumeration<Object> enuKeys = portletProperties.keys();
                    String[] propertyKeys = new String[]{};
                    while (enuKeys.hasMoreElements()) {
                        propertyKeys = ArrayUtil.append(propertyKeys, (String)enuKeys.nextElement());
                    }
                    if (propertyKeys.length != 0) {
                        portletsProperties.add(new Pair<String, String[]>(absolutePath + "/portlet.properties", propertyKeys));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        paths = Files.walk(searchPathRoot, new FileVisitOption[0]);
        var7_7 = null;
        try {
            paths.filter(ignoreStateFilter).filter(lpkgFilter).map(lpkgPath -> lpkgPath.toAbsolutePath()).map(absolutePath -> absolutePath.toString()).forEach(lpkgAbsolutePath -> {
                try (ZipFile zipFile = new ZipFile((String)lpkgAbsolutePath);){
                    Enumeration<? extends ZipEntry> enu = zipFile.entries();
                    block22: while (enu.hasMoreElements()) {
                        ZipEntry zipEntry = enu.nextElement();
                        if (!PropertiesLocator._isLiferayJar(zipEntry.getName())) continue;
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        try {
                            JarInputStream jarIs = new JarInputStream(inputStream);
                            Throwable throwable = null;
                            try {
                                ZipEntry zipEntryJar = jarIs.getNextEntry();
                                while (zipEntryJar != null) {
                                    String zipEntryJarName = zipEntryJar.getName();
                                    if (zipEntryJarName.equals("portlet.properties")) {
                                        Properties portletProperties = new Properties();
                                        portletProperties.load(jarIs);
                                        Enumeration<Object> enuKeys = portletProperties.keys();
                                        String[] propertyKeys = new String[]{};
                                        while (enuKeys.hasMoreElements()) {
                                            propertyKeys = ArrayUtil.append(propertyKeys, (String)enuKeys.nextElement());
                                        }
                                        if (propertyKeys.length == 0) continue block22;
                                        String prop = lpkgAbsolutePath + "/" + zipEntry.getName() + "/portlet.properties";
                                        portletsProperties.add(new Pair<String, String[]>(prop, propertyKeys));
                                        continue block22;
                                    }
                                    zipEntryJar = jarIs.getNextEntry();
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (jarIs == null) continue;
                                if (throwable != null) {
                                    try {
                                        jarIs.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                jarIs.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (paths != null) {
                if (var7_7 != null) {
                    try {
                        paths.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    paths.close();
                }
            }
        }
        problems.stream().filter(problem -> problem.getType() == PropertyProblemType.MISSING).forEach(problem -> {
            String property = problem.getPropertyName();
            List<Pair<String, String>> mostLikelyMatches = this._getMostLikelyMatches(property, portletsProperties, this._getPortletNames(property));
            if (!mostLikelyMatches.isEmpty()) {
                problem.setReplacements(mostLikelyMatches);
                problem.setType(PropertyProblemType.MODULARIZED);
            }
        });
    }

    private boolean _match(String originalProperty, String newProperty, String newPropertyPath, int minOccurrences, String[] portletNames) {
        if (!this._pathContainsPortletName(newPropertyPath, portletNames)) {
            return false;
        }
        int numOccurrences = this._getOccurrences(originalProperty, newProperty);
        return numOccurrences != 0 && numOccurrences >= minOccurrences;
    }

    private boolean _matchSuffix(String originalProperty, String property) {
        String[] propertyWords;
        String propertySuffix;
        if (!property.contains(".")) {
            property = CamelCaseUtil.fromCamelCase(property, ".".charAt(0));
        }
        return originalProperty.endsWith(propertySuffix = (propertyWords = StringUtil.split(property, "."))[propertyWords.length - 2] + "." + propertyWords[propertyWords.length - 1]);
    }

    private boolean _pathContainsPortletName(String propertyPath, String[] portletNames) {
        for (String portletName : portletNames) {
            if ((portletName = this._getEquivalence(portletName)) == null || !propertyPath.contains(portletName)) continue;
            return true;
        }
        return false;
    }

    private void _printInfo(PrintWriter outputFile, SortedSet<PropertyProblem> problems) {
        problems.forEach(problem -> {
            outputFile.println(problem.getPropertyName());
            outputFile.print("\t");
            if (problem.getType() == PropertyProblemType.NONE) {
                outputFile.println("KEEP - This property is still present in the new portal.properties.");
            } else if (problem.getType() == PropertyProblemType.MISSING) {
                outputFile.println("ANALYZE - This property is not present in thew new portal.properties. Check if you still need it or check the documentation to find a replacement");
            } else if (problem.getType() == PropertyProblemType.REMOVED) {
                outputFile.println("REMOVE - " + problem.getMessage());
            } else if (problem.getType() == PropertyProblemType.OSGI) {
                outputFile.print("MODULARIZE AS OSGI - ");
                if (problem.getMessage() != null) {
                    outputFile.print(problem.getMessage());
                } else {
                    outputFile.println("This property matches with the following OSGI config, select the most appropriate:");
                    this._printOSGIReplacements(outputFile, problem.getReplacements());
                }
            } else if (problem.getType() == PropertyProblemType.MODULARIZED) {
                outputFile.print("MODULARIZE - ");
                if (problem.getMessage() != null) {
                    outputFile.print(problem.getMessage());
                } else {
                    outputFile.println("This property matches with the following portlet properties, select the most appropriate:");
                    this._printModularizedReplacements(outputFile, problem.getReplacements());
                }
            }
            outputFile.println();
        });
    }

    private void _printModularizedReplacements(PrintWriter outputFile, List<Pair<String, String>> replacements) {
        replacements.forEach(replacement -> {
            String path = String.valueOf(_bundlePath.relativize(Paths.get((String)replacement.first(), new String[0])));
            path = path.replaceAll("\\\\", "/");
            outputFile.print("\t\t- ");
            outputFile.println((String)replacement.second() + " from " + path);
        });
    }

    private void _printOSGIReplacements(PrintWriter outputFile, List<Pair<String, String>> replacements) {
        replacements.stream().sorted((r1, r2) -> {
            String r1First = (String)r1.first();
            String r2First = (String)r2.first();
            return r1First.compareTo(r2First);
        }).forEach(replacement -> {
            String path = (String)replacement.first();
            String configFileName = StringUtil.replace(path, "/".charAt(0), ".".charAt(0));
            outputFile.print("\t\t- ");
            outputFile.println((String)replacement.second() + " from " + configFileName);
        });
    }

    private String _removeCommonPrefix(String property) {
        for (String prefix : _COMMON_PREFIXES) {
            if (!property.startsWith(prefix)) continue;
            if (!(property = property.replace(prefix, "")).startsWith(".")) break;
            property = property.substring(1);
            break;
        }
        return property;
    }

    private void _removeScopedProperties(Properties properties) {
        Set<String> propertiesSet = properties.stringPropertyNames();
        for (String property : propertiesSet) {
            if (property.contains("[")) {
                property = property.substring(0, property.indexOf("["));
            }
            properties.put(property, "");
        }
    }

    static {
        _portletNameEquivalences = new TreeMap<String, String>(){
            {
                this.put("dl", "document-library");
            }
        };
    }
}

