/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class StringUtil {
    private static String[] _emptyStringArray = new String[0];

    public static boolean contains(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.contains(s2);
    }

    public static boolean equals(String s1, Object o) {
        if (s1 == null || o == null) {
            return false;
        }
        return s1.equals(o.toString());
    }

    public static boolean isNullOrEmpty(String arg) {
        boolean hasContent = Optional.of(arg).filter(s -> s != null).map(String::trim).filter(s -> s.length() != 0).isPresent();
        return !hasContent;
    }

    public static String replace(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return s.replace(oldSub, newSub);
    }

    public static String[] split(String s, char delimiter) {
        if (s == null) {
            return _emptyStringArray;
        }
        if ((s = s.trim()).length() == 0) {
            return _emptyStringArray;
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        StringUtil._split(nodeValues, s, 0, delimiter);
        return nodeValues.toArray(new String[0]);
    }

    public static String[] split(String s, String delimiter) {
        if (s == null || delimiter == null || delimiter.equals("")) {
            return _emptyStringArray;
        }
        if ((s = s.trim()).equals(delimiter)) {
            return _emptyStringArray;
        }
        if (delimiter.length() == 1) {
            return StringUtil.split(s, delimiter.charAt(0));
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        int offset = 0;
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            nodeValues.add(s.substring(offset, pos));
            offset = pos + delimiter.length();
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            nodeValues.add(s.substring(offset));
        }
        return nodeValues.toArray(new String[0]);
    }

    private static void _split(Collection<String> values, String s, int offset, char delimiter) {
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            values.add(s.substring(offset, pos));
            offset = pos + 1;
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            values.add(s.substring(offset));
        }
    }
}

