/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.WatchArgs;
import com.liferay.blade.cli.gradle.GradleExec;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WatchCommand
extends BaseCommand<WatchArgs> {
    @Override
    public void execute() throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        WatchArgs watchArgs = (WatchArgs)this.getArgs();
        File base = watchArgs.getBase();
        Path watchPath = Paths.get(base.getCanonicalPath(), new String[0]);
        if (!Files.isDirectory(watchPath, new LinkOption[0])) {
            bladeCLI.error("Error: base dir is not a directory: " + watchPath);
            return;
        }
        List<String> ignorePaths = watchArgs.getIgnorePaths();
        Map<String, Path> projectPaths = this._getProjectPaths(watchPath, watchArgs.getProjectPaths(), ignorePaths);
        if (!watchArgs.isQuiet()) {
            bladeCLI.out("Watching projects...");
        }
        projectPaths.keySet().stream().forEach(bladeCLI::out);
        this._watch(watchPath, projectPaths, watchArgs.getFastPaths(), ignorePaths, !watchArgs.isSkipInit());
    }

    @Override
    public Class<WatchArgs> getArgsClass() {
        return WatchArgs.class;
    }

    private void _addError(String prefix, String msg) {
        this.getBladeCLI().addErrors(prefix, Collections.singleton(msg));
    }

    private void _addPathMatcher(List<PathMatcher> pathMatchers, FileSystem fileSystem, String pattern) {
        if (File.separatorChar == '\\') {
            pattern = pattern.replace("/", "\\\\");
        }
        pathMatchers.add(fileSystem.getPathMatcher("glob:" + pattern));
    }

    private String _getGradlePath(Path path, Path basePath) {
        String gradlePath = ":" + String.valueOf(basePath.relativize(path));
        return gradlePath.replaceAll(Matcher.quoteReplacement(File.separator), ":");
    }

    private Path _getGradleProjectPath(Path basePath, Path path, Map<String, Path> projectPaths) {
        String gradlePath = this._getGradlePath(path, basePath);
        for (Map.Entry<String, Path> entry : projectPaths.entrySet()) {
            String projectPath = entry.getKey();
            if (!gradlePath.startsWith(projectPath)) continue;
            return projectPaths.get(projectPath);
        }
        return basePath;
    }

    private List<PathMatcher> _getPathMatchers(Path baseDirPath, String ... patterns) {
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> pathMatchers = new ArrayList<PathMatcher>(patterns.length);
        String patternPrefix = baseDirPath.toAbsolutePath() + File.separator;
        if (File.separatorChar != '/') {
            patternPrefix = patternPrefix.replace(File.separatorChar, '/');
        }
        for (String pattern : patterns) {
            String absolutePattern;
            if (pattern.startsWith("**/")) {
                absolutePattern = patternPrefix + pattern.substring(3);
                this._addPathMatcher(pathMatchers, fileSystem, absolutePattern);
            }
            absolutePattern = patternPrefix + pattern;
            this._addPathMatcher(pathMatchers, fileSystem, absolutePattern);
        }
        return pathMatchers;
    }

    private Map<String, Path> _getProjectPaths(final Path watchPath, final List<String> projectPaths, List<String> ignorePaths) throws Exception {
        final HashMap<String, Path> foundProjectPaths = new HashMap<String, Path>();
        FileSystem fileSystem = FileSystems.getDefault();
        final List ignorePathMatchers = ignorePaths.stream().map(ignorePath -> fileSystem.getPathMatcher("glob:" + ignorePath)).collect(Collectors.toList());
        Files.walkFileTree(watchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                boolean shouldIgnorePath = ignorePathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path));
                if (shouldIgnorePath) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                try (Stream<Path> files = Files.list(path);){
                    if (files.map(p -> p.getFileName()).filter(p -> !ignorePathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path.resolve((Path)p)))).anyMatch(p -> projectPaths.stream().anyMatch(pp -> Objects.equals(pp, p.toString())))) {
                        foundProjectPaths.put(WatchCommand.this._getGradlePath(path, watchPath), path);
                        FileVisitResult fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                        return fileVisitResult;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return foundProjectPaths;
    }

    private void _registerDirectory(WatchService watcher, Map<WatchKey, Path> keys, Path dir) throws IOException {
        WatchKey watchKey = dir.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
        keys.put(watchKey, dir);
    }

    private void _walkAndRegisterDirectories(final WatchService watchService, final Map<WatchKey, Path> watchKeys, Path basePath, final List<PathMatcher> ignorePathMatchers) throws IOException {
        Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                for (PathMatcher pathMatcher : ignorePathMatchers) {
                    if (!pathMatcher.matches(path)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                WatchCommand.this._registerDirectory(watchService, watchKeys, path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void _watch(final Path watchPath, final Map<String, Path> projectPaths, final List<String> fastPaths, final List<String> ignorePaths, final boolean deploy) throws Exception {
        Thread watchThread = new Thread(){

            @Override
            public void run() {
                BladeCLI bladeCLI = WatchCommand.this.getBladeCLI();
                BaseArgs baseArgs = bladeCLI.getArgs();
                try (FileSystem fileSystem = FileSystems.getDefault();
                     WatchService watchService = fileSystem.newWatchService();){
                    HashMap watchKeys = new HashMap();
                    List ignorePathMatchers = WatchCommand.this._getPathMatchers(watchPath, ignorePaths.toArray(new String[0]));
                    List fastPathMatchers = WatchCommand.this._getPathMatchers(watchPath, fastPaths.toArray(new String[0]));
                    WatchCommand.this._walkAndRegisterDirectories(watchService, watchKeys, watchPath, ignorePathMatchers);
                    GradleExec gradleExec = new GradleExec(bladeCLI);
                    if (deploy) {
                        if (!baseArgs.isQuiet()) {
                            bladeCLI.out("Deploying...  To skip initial deployment, use `blade watch -s`");
                        }
                        gradleExec.executeTask("deploy", false);
                    }
                    while (true) {
                        WatchKey watchKey;
                        try {
                            watchKey = watchService.take();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        Path dir = (Path)watchKeys.get(watchKey);
                        if (dir == null) {
                            bladeCLI.error("WatchKey not recognized!!");
                            continue;
                        }
                        for (WatchEvent<?> event : watchKey.pollEvents()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            Path path = (Path)event.context();
                            Path resolvedPath = dir.resolve(path);
                            boolean ignoredPath = false;
                            for (PathMatcher pathMatcher : ignorePathMatchers) {
                                if (!pathMatcher.matches(resolvedPath)) continue;
                                ignoredPath = true;
                                break;
                            }
                            if (ignoredPath) continue;
                            boolean directory = Files.isDirectory(resolvedPath, new LinkOption[0]);
                            Path projectPath = WatchCommand.this._getGradleProjectPath(watchPath, resolvedPath, projectPaths);
                            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                if (directory) {
                                    try {
                                        WatchCommand.this._walkAndRegisterDirectories(watchService, watchKeys, resolvedPath, ignorePathMatchers);
                                    }
                                    catch (IOException ioException) {
                                        bladeCLI.error("Could not register directory:" + resolvedPath);
                                    }
                                }
                                if (!baseArgs.isQuiet()) {
                                    bladeCLI.out(resolvedPath + " has been created, deploying...");
                                }
                                gradleExec.executeTask("deploy", projectPath.toFile(), false);
                            } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                if (!baseArgs.isQuiet()) {
                                    bladeCLI.out(resolvedPath + " has been deleted, redeploying...");
                                }
                                gradleExec.executeTask("clean deploy", projectPath.toFile(), false);
                            } else if (!directory) {
                                boolean fastExtension = false;
                                for (PathMatcher pathMatcher : fastPathMatchers) {
                                    if (!pathMatcher.matches(resolvedPath)) continue;
                                    fastExtension = true;
                                    break;
                                }
                                if (fastExtension) {
                                    if (!baseArgs.isQuiet()) {
                                        bladeCLI.out(resolvedPath + " has changed, fast deploying...");
                                    }
                                    gradleExec.executeTask("deployFast -a", projectPath.toFile(), false);
                                } else {
                                    System.out.println(resolvedPath + " has changed, deploying...");
                                    gradleExec.executeTask("deploy -a", projectPath.toFile(), false);
                                }
                            }
                            if (baseArgs.isQuiet()) continue;
                            bladeCLI.out("Watching files in " + watchPath + ". Press Crtl + C to stop.");
                        }
                        boolean valid = watchKey.reset();
                        if (valid) continue;
                        watchKeys.remove(watchKey);
                        if (watchKeys.isEmpty()) break;
                    }
                }
                catch (Exception exception) {
                    WatchCommand.this._addError("watch", exception.getMessage());
                    PrintStream error = bladeCLI.error();
                    exception.printStackTrace(error);
                }
            }
        };
        watchThread.start();
        watchThread.join();
    }
}

