/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.results;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.lazerycode.jmeter.results.CSVScanResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;

public class CSVFileScanner {
    private static final String ROW_NAME_SUCCESS = "success";
    private static final String ROW_NAME_FAILURE_MESSAGE = "failureMessage";
    private static final CsvMapper CSV_MAPPER = new CsvMapper();
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    protected static CSVScanResult scanCsvForValues(File file, List<String> values) throws MojoExecutionException {
        Map<String, Integer> specificFailureMessages = values.stream().collect(Collectors.toMap(Function.identity(), a -> 0));
        int successCount = 0;
        int failureCount = 0;
        try {
            char separator = CSVFileScanner.computeSeparator(file);
            CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator(separator);
            try (FileReader fr = new FileReader(file);
                 BufferedReader reader = new BufferedReader(fr, 8192);){
                MappingIterator it = CSV_MAPPER.readerFor(Map.class).with((FormatSchema)schema).readValues((Reader)reader);
                while (it.hasNext()) {
                    Map row = (Map)it.next();
                    if (Boolean.parseBoolean((String)row.get(ROW_NAME_SUCCESS))) {
                        ++successCount;
                        continue;
                    }
                    ++failureCount;
                    for (Map.Entry entry : specificFailureMessages.entrySet()) {
                        String failureMessage = (String)row.get(ROW_NAME_FAILURE_MESSAGE);
                        if (!((String)entry.getKey()).equalsIgnoreCase(failureMessage)) continue;
                        entry.setValue(entry.getValue() + 1);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An unexpected error occurred while reading file " + file.getAbsolutePath(), (Exception)e);
        }
        return new CSVScanResult(specificFailureMessages, successCount, failureCount);
    }

    private static char computeSeparator(File file) throws IOException {
        try (FileReader fr = new FileReader(file);
             BufferedReader reader = new BufferedReader(fr, 8192);){
            String line = reader.readLine();
            if (line != null) {
                char c = CSVFileScanner.lookForDelimiter(line);
                return c;
            }
            throw new IllegalArgumentException("No line read from file " + file.getAbsolutePath());
        }
    }

    private static char lookForDelimiter(String line) {
        for (char ch : line.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return ch;
        }
        throw new IllegalStateException("Cannot find delimiter in header " + line);
    }
}

