/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BigSegmentStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataSourceStatusProviderImpl;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.DiagnosticAccumulator;
import com.launchdarkly.sdk.server.DiagnosticId;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.EventFactory;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagTrackerImpl;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.Loggers;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.sdk.server.interfaces.EventProcessor;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagTracker;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.org.apache.commons.codec.binary.Hex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class LDClient
implements LDClientInterface {
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private final String sdkKey;
    private final boolean offline;
    private final Evaluator evaluator;
    final EventProcessor eventProcessor;
    final DataSource dataSource;
    final DataStore dataStore;
    private final BigSegmentStoreStatusProvider bigSegmentStoreStatusProvider;
    private final BigSegmentStoreWrapper bigSegmentStoreWrapper;
    private final DataSourceUpdates dataSourceUpdates;
    private final DataStoreStatusProviderImpl dataStoreStatusProvider;
    private final DataSourceStatusProviderImpl dataSourceStatusProvider;
    private final FlagTrackerImpl flagTracker;
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster;
    private final ScheduledExecutorService sharedExecutor;
    private final EventFactory eventFactoryDefault;
    private final EventFactory eventFactoryWithReasons;

    public LDClient(String sdkKey) {
        this(sdkKey, LDConfig.DEFAULT);
    }

    private static final DataModel.FeatureFlag getFlag(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.FEATURES, key);
        return item == null ? null : (DataModel.FeatureFlag)item.getItem();
    }

    private static final DataModel.Segment getSegment(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.SEGMENTS, key);
        return item == null ? null : (DataModel.Segment)item.getItem();
    }

    public LDClient(String sdkKey, LDConfig config) {
        Preconditions.checkNotNull(config, "config must not be null");
        this.sdkKey = Preconditions.checkNotNull(sdkKey, "sdkKey must not be null");
        if (!Util.isAsciiHeaderValue(sdkKey)) {
            throw new IllegalArgumentException("SDK key contained an invalid character");
        }
        this.offline = config.offline;
        this.sharedExecutor = this.createSharedExecutor(config);
        boolean eventsDisabled = Components.isNullImplementation(config.eventProcessorFactory);
        if (eventsDisabled) {
            this.eventFactoryDefault = EventFactory.Disabled.INSTANCE;
            this.eventFactoryWithReasons = EventFactory.Disabled.INSTANCE;
        } else {
            this.eventFactoryDefault = EventFactory.DEFAULT;
            this.eventFactoryWithReasons = EventFactory.DEFAULT_WITH_REASONS;
        }
        boolean useDiagnostics = !config.diagnosticOptOut && config.eventProcessorFactory instanceof EventProcessorBuilder;
        ClientContextImpl context = new ClientContextImpl(sdkKey, config, this.sharedExecutor, useDiagnostics ? new DiagnosticAccumulator(new DiagnosticId(sdkKey)) : null);
        this.eventProcessor = config.eventProcessorFactory.createEventProcessor(context);
        EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> bigSegmentStoreStatusNotifier = EventBroadcasterImpl.forBigSegmentStoreStatus(this.sharedExecutor);
        BigSegmentsConfiguration bigSegmentsConfig = config.bigSegmentsConfigBuilder.createBigSegmentsConfiguration(context);
        this.bigSegmentStoreWrapper = bigSegmentsConfig.getStore() != null ? new BigSegmentStoreWrapper(bigSegmentsConfig, bigSegmentStoreStatusNotifier, this.sharedExecutor) : null;
        this.bigSegmentStoreStatusProvider = new BigSegmentStoreStatusProviderImpl(bigSegmentStoreStatusNotifier, this.bigSegmentStoreWrapper);
        EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> dataStoreStatusNotifier = EventBroadcasterImpl.forDataStoreStatus(this.sharedExecutor);
        DataStoreUpdatesImpl dataStoreUpdates = new DataStoreUpdatesImpl(dataStoreStatusNotifier);
        this.dataStore = config.dataStoreFactory.createDataStore(context, dataStoreUpdates);
        this.evaluator = new Evaluator(new Evaluator.Getters(){

            @Override
            public DataModel.FeatureFlag getFlag(String key) {
                return LDClient.getFlag(LDClient.this.dataStore, key);
            }

            @Override
            public DataModel.Segment getSegment(String key) {
                return LDClient.getSegment(LDClient.this.dataStore, key);
            }

            @Override
            public BigSegmentStoreWrapper.BigSegmentsQueryResult getBigSegments(String key) {
                BigSegmentStoreWrapper wrapper = LDClient.this.bigSegmentStoreWrapper;
                return wrapper == null ? null : wrapper.getUserMembership(key);
            }
        });
        this.flagChangeBroadcaster = EventBroadcasterImpl.forFlagChangeEvents(this.sharedExecutor);
        this.flagTracker = new FlagTrackerImpl(this.flagChangeBroadcaster, (key, user) -> this.jsonValueVariation((String)key, (LDUser)user, LDValue.ofNull()));
        this.dataStoreStatusProvider = new DataStoreStatusProviderImpl(this.dataStore, dataStoreUpdates);
        EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier = EventBroadcasterImpl.forDataSourceStatus(this.sharedExecutor);
        DataSourceUpdatesImpl dataSourceUpdates = new DataSourceUpdatesImpl(this.dataStore, this.dataStoreStatusProvider, this.flagChangeBroadcaster, dataSourceStatusNotifier, this.sharedExecutor, context.getLogging().getLogDataSourceOutageAsErrorAfter());
        this.dataSourceUpdates = dataSourceUpdates;
        this.dataSource = config.dataSourceFactory.createDataSource(context, dataSourceUpdates);
        this.dataSourceStatusProvider = new DataSourceStatusProviderImpl(dataSourceStatusNotifier, dataSourceUpdates);
        Future<Void> startFuture = this.dataSource.start();
        if (!config.startWait.isZero() && !config.startWait.isNegative()) {
            if (!(this.dataSource instanceof ComponentsImpl.NullDataSource)) {
                Loggers.MAIN.info("Waiting up to " + config.startWait.toMillis() + " milliseconds for LaunchDarkly client to start...");
            }
            try {
                startFuture.get(config.startWait.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                Loggers.MAIN.error("Timeout encountered waiting for LaunchDarkly client initialization");
            }
            catch (Exception e) {
                Loggers.MAIN.error("Exception encountered waiting for LaunchDarkly client initialization: {}", (Object)e.toString());
                Loggers.MAIN.debug(e.toString(), (Throwable)e);
            }
            if (!this.dataSource.isInitialized()) {
                Loggers.MAIN.warn("LaunchDarkly client was not successfully initialized");
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.dataSource.isInitialized();
    }

    @Override
    public void track(String eventName, LDUser user) {
        this.trackData(eventName, user, LDValue.ofNull());
    }

    @Override
    public void trackData(String eventName, LDUser user, LDValue data) {
        if (user == null || user.getKey() == null || user.getKey().isEmpty()) {
            Loggers.MAIN.warn("Track called with null user or null/empty user key!");
        } else {
            this.eventProcessor.sendEvent(this.eventFactoryDefault.newCustomEvent(eventName, user, data, null));
        }
    }

    @Override
    public void trackMetric(String eventName, LDUser user, LDValue data, double metricValue) {
        if (user == null || user.getKey() == null || user.getKey().isEmpty()) {
            Loggers.MAIN.warn("Track called with null user or null/empty user key!");
        } else {
            this.eventProcessor.sendEvent(this.eventFactoryDefault.newCustomEvent(eventName, user, data, metricValue));
        }
    }

    @Override
    public void identify(LDUser user) {
        if (user == null || user.getKey() == null || user.getKey().isEmpty()) {
            Loggers.MAIN.warn("Identify called with null user or null/empty user key!");
        } else {
            this.eventProcessor.sendEvent(this.eventFactoryDefault.newIdentifyEvent(user));
        }
    }

    private void sendFlagRequestEvent(Event.FeatureRequest event) {
        if (event != null) {
            this.eventProcessor.sendEvent(event);
        }
    }

    @Override
    public FeatureFlagsState allFlagsState(LDUser user, FlagsStateOption ... options) {
        DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> flags;
        FeatureFlagsState.Builder builder = FeatureFlagsState.builder(options);
        if (this.isOffline()) {
            Loggers.EVALUATION.debug("allFlagsState() was called when client is in offline mode.");
        }
        if (!this.isInitialized()) {
            if (this.dataStore.isInitialized()) {
                Loggers.EVALUATION.warn("allFlagsState() was called before client initialized; using last known values from data store");
            } else {
                Loggers.EVALUATION.warn("allFlagsState() was called before client initialized; data store unavailable, returning no data");
                return builder.valid(false).build();
            }
        }
        if (user == null || user.getKey() == null) {
            Loggers.EVALUATION.warn("allFlagsState() was called with null user or null user key! returning no data");
            return builder.valid(false).build();
        }
        boolean clientSideOnly = FlagsStateOption.hasOption(options, FlagsStateOption.CLIENT_SIDE_ONLY);
        try {
            flags = this.dataStore.getAll(DataModel.FEATURES);
        }
        catch (Exception e) {
            Loggers.EVALUATION.error("Exception from data store when evaluating all flags: {}", (Object)e.toString());
            Loggers.EVALUATION.debug(e.toString(), (Throwable)e);
            return builder.valid(false).build();
        }
        for (Map.Entry<String, DataStoreTypes.ItemDescriptor> entry : flags.getItems()) {
            if (entry.getValue().getItem() == null) continue;
            DataModel.FeatureFlag flag = (DataModel.FeatureFlag)entry.getValue().getItem();
            if (clientSideOnly && !flag.isClientSide()) continue;
            try {
                Evaluator.EvalResult result = this.evaluator.evaluate(flag, user, this.eventFactoryDefault);
                builder.addFlag(flag, result);
            }
            catch (Exception e) {
                Loggers.EVALUATION.error("Exception caught for feature flag \"{}\" when evaluating all flags: {}", (Object)entry.getKey(), (Object)e.toString());
                Loggers.EVALUATION.debug(e.toString(), (Throwable)e);
                builder.addFlag(flag, new Evaluator.EvalResult(LDValue.ofNull(), -1, EvaluationReason.exception(e)));
            }
        }
        return builder.build();
    }

    @Override
    public boolean boolVariation(String featureKey, LDUser user, boolean defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).booleanValue();
    }

    @Override
    public int intVariation(String featureKey, LDUser user, int defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).intValue();
    }

    @Override
    public double doubleVariation(String featureKey, LDUser user, double defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).doubleValue();
    }

    @Override
    public String stringVariation(String featureKey, LDUser user, String defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).stringValue();
    }

    @Override
    public LDValue jsonValueVariation(String featureKey, LDUser user, LDValue defaultValue) {
        return this.evaluate(featureKey, user, LDValue.normalize(defaultValue), false);
    }

    @Override
    public EvaluationDetail<Boolean> boolVariationDetail(String featureKey, LDUser user, boolean defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, this.eventFactoryWithReasons);
        return EvaluationDetail.fromValue(result.getValue().booleanValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<Integer> intVariationDetail(String featureKey, LDUser user, int defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, this.eventFactoryWithReasons);
        return EvaluationDetail.fromValue(result.getValue().intValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<Double> doubleVariationDetail(String featureKey, LDUser user, double defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, this.eventFactoryWithReasons);
        return EvaluationDetail.fromValue(result.getValue().doubleValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<String> stringVariationDetail(String featureKey, LDUser user, String defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, this.eventFactoryWithReasons);
        return EvaluationDetail.fromValue(result.getValue().stringValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<LDValue> jsonValueVariationDetail(String featureKey, LDUser user, LDValue defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.normalize(defaultValue), false, this.eventFactoryWithReasons);
        return EvaluationDetail.fromValue(result.getValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public boolean isFlagKnown(String featureKey) {
        if (!this.isInitialized()) {
            if (this.dataStore.isInitialized()) {
                Loggers.MAIN.warn("isFlagKnown called before client initialized for feature flag \"{}\"; using last known values from data store", (Object)featureKey);
            } else {
                Loggers.MAIN.warn("isFlagKnown called before client initialized for feature flag \"{}\"; data store unavailable, returning false", (Object)featureKey);
                return false;
            }
        }
        try {
            if (LDClient.getFlag(this.dataStore, featureKey) != null) {
                return true;
            }
        }
        catch (Exception e) {
            Loggers.MAIN.error("Encountered exception while calling isFlagKnown for feature flag \"{}\": {}", (Object)featureKey, (Object)e.toString());
            Loggers.MAIN.debug(e.toString(), (Throwable)e);
        }
        return false;
    }

    private LDValue evaluate(String featureKey, LDUser user, LDValue defaultValue, boolean checkType) {
        return this.evaluateInternal(featureKey, user, defaultValue, checkType, this.eventFactoryDefault).getValue();
    }

    private Evaluator.EvalResult errorResult(EvaluationReason.ErrorKind errorKind, LDValue defaultValue) {
        return new Evaluator.EvalResult(defaultValue, -1, EvaluationReason.error(errorKind));
    }

    private Evaluator.EvalResult evaluateInternal(String featureKey, LDUser user, LDValue defaultValue, boolean checkType, EventFactory eventFactory) {
        if (!this.isInitialized()) {
            if (this.dataStore.isInitialized()) {
                Loggers.EVALUATION.warn("Evaluation called before client initialized for feature flag \"{}\"; using last known values from data store", (Object)featureKey);
            } else {
                Loggers.EVALUATION.warn("Evaluation called before client initialized for feature flag \"{}\"; data store unavailable, returning default value", (Object)featureKey);
                this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.CLIENT_NOT_READY));
                return this.errorResult(EvaluationReason.ErrorKind.CLIENT_NOT_READY, defaultValue);
            }
        }
        DataModel.FeatureFlag featureFlag = null;
        try {
            featureFlag = LDClient.getFlag(this.dataStore, featureKey);
            if (featureFlag == null) {
                Loggers.EVALUATION.info("Unknown feature flag \"{}\"; returning default value", (Object)featureKey);
                this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
                return this.errorResult(EvaluationReason.ErrorKind.FLAG_NOT_FOUND, defaultValue);
            }
            if (user == null || user.getKey() == null) {
                Loggers.EVALUATION.warn("Null user or null user key when evaluating flag \"{}\"; returning default value", (Object)featureKey);
                this.sendFlagRequestEvent(eventFactory.newDefaultFeatureRequestEvent(featureFlag, user, defaultValue, EvaluationReason.ErrorKind.USER_NOT_SPECIFIED));
                return this.errorResult(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED, defaultValue);
            }
            if (user.getKey().isEmpty()) {
                Loggers.EVALUATION.warn("User key is blank. Flag evaluation will proceed, but the user will not be stored in LaunchDarkly");
            }
            Evaluator.EvalResult evalResult = this.evaluator.evaluate(featureFlag, user, eventFactory);
            for (Event.FeatureRequest event : evalResult.getPrerequisiteEvents()) {
                this.eventProcessor.sendEvent(event);
            }
            if (evalResult.isDefault()) {
                evalResult.setValue(defaultValue);
            } else {
                LDValue value = evalResult.getValue();
                if (checkType && !value.isNull() && !defaultValue.isNull() && defaultValue.getType() != value.getType()) {
                    Loggers.EVALUATION.error("Feature flag evaluation expected result as {}, but got {}", (Object)defaultValue.getType(), (Object)value.getType());
                    this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.WRONG_TYPE));
                    return this.errorResult(EvaluationReason.ErrorKind.WRONG_TYPE, defaultValue);
                }
            }
            this.sendFlagRequestEvent(eventFactory.newFeatureRequestEvent(featureFlag, user, evalResult, defaultValue));
            return evalResult;
        }
        catch (Exception e) {
            Loggers.EVALUATION.error("Encountered exception while evaluating feature flag \"{}\": {}", (Object)featureKey, (Object)e.toString());
            Loggers.EVALUATION.debug(e.toString(), (Throwable)e);
            if (featureFlag == null) {
                this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.EXCEPTION));
            } else {
                this.sendFlagRequestEvent(eventFactory.newDefaultFeatureRequestEvent(featureFlag, user, defaultValue, EvaluationReason.ErrorKind.EXCEPTION));
            }
            return new Evaluator.EvalResult(defaultValue, -1, EvaluationReason.exception(e));
        }
    }

    @Override
    public FlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Override
    public BigSegmentStoreStatusProvider getBigSegmentStoreStatusProvider() {
        return this.bigSegmentStoreStatusProvider;
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    @Override
    public DataSourceStatusProvider getDataSourceStatusProvider() {
        return this.dataSourceStatusProvider;
    }

    @Override
    public void close() throws IOException {
        Loggers.MAIN.info("Closing LaunchDarkly Client");
        this.dataStore.close();
        this.eventProcessor.close();
        this.dataSource.close();
        this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.OFF, null);
        if (this.bigSegmentStoreWrapper != null) {
            this.bigSegmentStoreWrapper.close();
        }
        this.sharedExecutor.shutdownNow();
    }

    @Override
    public void flush() {
        this.eventProcessor.flush();
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public String secureModeHash(LDUser user) {
        if (user == null || user.getKey() == null) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(new SecretKeySpec(this.sdkKey.getBytes(), HMAC_ALGORITHM));
            return Hex.encodeHexString(mac.doFinal(user.getKey().getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            Loggers.MAIN.error("Could not generate secure mode hash: {}", (Object)e.toString());
            Loggers.MAIN.debug(e.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void alias(LDUser user, LDUser previousUser) {
        this.eventProcessor.sendEvent(this.eventFactoryDefault.newAliasEvent(user, previousUser));
    }

    @Override
    public String version() {
        return "5.8.0";
    }

    private ScheduledExecutorService createSharedExecutor(LDConfig config) {
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-tasks-%d").setPriority(config.threadPriority).build();
        return Executors.newSingleThreadScheduledExecutor(threadFactory2);
    }
}

