/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;

class EventBroadcasterImpl<ListenerT, EventT> {
    private final CopyOnWriteArrayList<ListenerT> listeners = new CopyOnWriteArrayList();
    private final BiConsumer<ListenerT, EventT> broadcastAction;
    private final ExecutorService executor;
    private final LDLogger logger;

    EventBroadcasterImpl(BiConsumer<ListenerT, EventT> broadcastAction, ExecutorService executor, LDLogger logger) {
        this.broadcastAction = broadcastAction;
        this.executor = executor;
        this.logger = logger;
    }

    static EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> forFlagChangeEvents(ExecutorService executor, LDLogger logger) {
        return new EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent>(FlagChangeListener::onFlagChange, executor, logger);
    }

    static EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> forDataSourceStatus(ExecutorService executor, LDLogger logger) {
        return new EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status>(DataSourceStatusProvider.StatusListener::dataSourceStatusChanged, executor, logger);
    }

    static EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> forDataStoreStatus(ExecutorService executor, LDLogger logger) {
        return new EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status>(DataStoreStatusProvider.StatusListener::dataStoreStatusChanged, executor, logger);
    }

    static EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> forBigSegmentStoreStatus(ExecutorService executor, LDLogger logger) {
        return new EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status>(BigSegmentStoreStatusProvider.StatusListener::bigSegmentStoreStatusChanged, executor, logger);
    }

    void register(ListenerT listener) {
        this.listeners.add(listener);
    }

    void unregister(ListenerT listener) {
        this.listeners.remove(listener);
    }

    boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    void broadcast(EventT event) {
        if (this.executor == null) {
            return;
        }
        for (ListenerT l : this.listeners) {
            this.executor.execute(() -> {
                try {
                    this.broadcastAction.accept(l, event);
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected error from listener ({}): {}", (Object)l.getClass(), LogValues.exceptionSummary(e));
                    this.logger.debug("{}", LogValues.exceptionTrace(e));
                }
            });
        }
    }
}

