/*
 * Decompiled with CFR 0.152.
 */
package com.knappsack.swagger4springweb.util;

import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.model.Model;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;
import scala.Option;
import scala.collection.immutable.HashMap;

public class ModelUtils {
    public static String getSwaggerTypeFor(Class<?> parameterType) {
        Class<?> type = parameterType;
        if (parameterType.isArray()) {
            type = type.getComponentType();
        }
        if (String.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return "boolean";
        }
        if (Byte.class.isAssignableFrom(type)) {
            return "byte";
        }
        if (Long.class.isAssignableFrom(type)) {
            return "int64";
        }
        if (Integer.class.isAssignableFrom(type)) {
            return "int32";
        }
        if (Float.class.isAssignableFrom(type)) {
            return "float";
        }
        if (MultipartFile.class.isAssignableFrom(type)) {
            return "file";
        }
        if (Number.class.isAssignableFrom(type)) {
            return "double";
        }
        if (Double.class.isAssignableFrom(type)) {
            return "double";
        }
        if (Date.class.isAssignableFrom(type)) {
            return "date";
        }
        return type.getSimpleName();
    }

    public static boolean isSet(String value) {
        return value != null && !value.trim().isEmpty() && !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(value);
    }

    public static boolean isAllowMultiple(Class parameterType) {
        return parameterType != null && (parameterType.isArray() || Collection.class.isAssignableFrom(parameterType));
    }

    static boolean isIgnorableModel(String name) {
        return name.equalsIgnoreCase("map") || name.equalsIgnoreCase("list") || name.equalsIgnoreCase("string") || name.equalsIgnoreCase("set") || name.equalsIgnoreCase("collection");
    }

    public static void addModels(Class<?> clazz, Map<String, Model> models) {
        Model model;
        Option modelOption = ModelConverters.read(clazz, (scala.collection.immutable.Map)new HashMap());
        if (!modelOption.isEmpty() && !ModelUtils.isIgnorableModel((model = (Model)modelOption.get()).name())) {
            models.put(model.name(), model);
        }
    }

    public static void addModels(Type type, Map<String, Model> models) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ModelUtils.addModels(parameterizedType.getRawType(), models);
            for (Type t : parameterizedType.getActualTypeArguments()) {
                ModelUtils.addModels(t, models);
            }
        } else if (type instanceof Class) {
            ModelUtils.addModels((Class)type, models);
        }
    }
}

