/*
 * Decompiled with CFR 0.152.
 */
package com.knappsack.swagger4springweb.util;

import com.google.common.collect.Lists;
import com.knappsack.swagger4springweb.model.AnnotatedParameter;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.RequestMapping;

public class AnnotationUtils {
    public static boolean hasApiParam(Method method) {
        Annotation[][] parameterAnnotations;
        Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotation;
            for (Annotation annotation : parameterAnnotation = annotationArray[i]) {
                if (!(annotation instanceof ApiParam)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getMethodRequestMappingValue(Method method) {
        String[] requestMappingValues;
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        String requestMappingValue = "";
        if (requestMapping != null && (requestMappingValues = requestMapping.value()) != null && requestMappingValues.length > 0) {
            requestMappingValue = requestMappingValues[0];
        }
        return requestMappingValue;
    }

    public static List<AnnotatedParameter> getAnnotatedParameters(Method method) {
        String[] parameterNames;
        ArrayList<AnnotatedParameter> annotatedParameters = new ArrayList<AnnotatedParameter>();
        BytecodeReadingParanamer paranamer = new BytecodeReadingParanamer();
        try {
            parameterNames = paranamer.lookupParameterNames((AccessibleObject)method);
        }
        catch (Exception e) {
            Parameter[] parameters = method.getParameters();
            parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                parameterNames[i] = parameter.getName();
            }
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        int i = 0;
        for (Object[] objectArray : parameterAnnotations) {
            if (objectArray.length > 0) {
                AnnotatedParameter annotatedParameter = new AnnotatedParameter();
                annotatedParameter.setParameterClass(parameterTypes[i]);
                annotatedParameter.setParameterName(parameterNames[i]);
                annotatedParameter.setParameterType(genericParameterTypes[i]);
                annotatedParameter.addAnnotations(Lists.newArrayList((Object[])objectArray));
                annotatedParameters.add(annotatedParameter);
            }
            ++i;
        }
        return annotatedParameters;
    }

    public static Set<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Method[] methods = clazz.getDeclaredMethods();
        HashSet<Method> annotatedMethods = new HashSet<Method>(methods.length);
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }
}

