/*
 * Decompiled with CFR 0.152.
 */
package com.knappsack.swagger4springweb.parser;

import com.knappsack.swagger4springweb.controller.ApiDocumentationController;
import com.knappsack.swagger4springweb.filter.ApiExcludeFilter;
import com.knappsack.swagger4springweb.filter.Filter;
import com.knappsack.swagger4springweb.parser.ApiDescriptionParser;
import com.knappsack.swagger4springweb.parser.ApiModelParser;
import com.knappsack.swagger4springweb.parser.ApiOperationParser;
import com.knappsack.swagger4springweb.parser.ApiParser;
import com.knappsack.swagger4springweb.parser.SpringApiReader;
import com.knappsack.swagger4springweb.util.AnnotationUtils;
import com.knappsack.swagger4springweb.util.ApiListingUtil;
import com.knappsack.swagger4springweb.util.JavaToScalaUtil;
import com.knappsack.swagger4springweb.util.ScalaToJavaUtil;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.model.ApiDescription;
import com.wordnik.swagger.model.ApiInfo;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ApiListingReference;
import com.wordnik.swagger.model.Model;
import com.wordnik.swagger.model.Operation;
import com.wordnik.swagger.model.ResourceListing;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.Option;

public class ApiParserImpl
implements ApiParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiParserImpl.class);
    private static final String swaggerVersion = SwaggerSpec.version();
    private final Map<String, ApiListing> apiListingMap = new HashMap<String, ApiListing>();
    private final List<String> controllerPackages;
    private final List<String> ignorableAnnotations;
    private final List<Filter> filters;
    private String basePath = "";
    private String apiVersion = "v1";
    private boolean ignoreUnusedPathVariables;
    private SwaggerConfig swaggerConfig;

    public ApiParserImpl(ApiInfo apiInfo, List<String> baseControllerPackage, String basePath, String servletPath, String apiVersion, List<String> ignorableAnnotations, boolean ignoreUnusedPathVariables, List<Filter> filters) {
        this.controllerPackages = baseControllerPackage;
        this.ignorableAnnotations = ignorableAnnotations;
        this.ignoreUnusedPathVariables = ignoreUnusedPathVariables;
        this.basePath = basePath;
        this.apiVersion = apiVersion;
        this.swaggerConfig = new SwaggerConfig();
        if (apiInfo != null) {
            this.swaggerConfig.setApiInfo(apiInfo);
        }
        this.swaggerConfig.setApiPath(servletPath);
        this.swaggerConfig.setApiVersion(apiVersion);
        this.swaggerConfig.setBasePath(basePath);
        this.swaggerConfig.setSwaggerVersion(swaggerVersion);
        this.filters = new ArrayList<Filter>();
        this.filters.add(new ApiExcludeFilter());
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    @Override
    public ResourceListing getResourceListing(Map<String, ApiListing> apiListingMap) {
        ArrayList<ApiListingReference> apiListingReferences = new ArrayList<ApiListingReference>();
        for (String key : apiListingMap.keySet()) {
            ApiListing apiListing = apiListingMap.get(key);
            String docPath = "/doc";
            ApiListingReference apiListingReference = new ApiListingReference(docPath + key, apiListing.description(), apiListing.position());
            apiListingReferences.add(apiListingReference);
        }
        Collections.sort(apiListingReferences, new Comparator<ApiListingReference>(){

            @Override
            public int compare(ApiListingReference o1, ApiListingReference o2) {
                if (o1.position() == o2.position()) {
                    return 0;
                }
                if (o1.position() == 0) {
                    return 1;
                }
                if (o2.position() == 0) {
                    return -1;
                }
                if (o1.position() < o2.position()) {
                    return -1;
                }
                if (o1.position() > o2.position()) {
                    return 1;
                }
                return 0;
            }
        });
        return new ResourceListing(this.apiVersion, swaggerVersion, JavaToScalaUtil.toScalaList(apiListingReferences), null, this.swaggerConfig.info());
    }

    @Override
    public Map<String, ApiListing> createApiListings() {
        HashSet controllerClasses = new HashSet();
        for (String controllerPackage : this.controllerPackages) {
            Reflections reflections = new Reflections(controllerPackage, new Scanner[0]);
            controllerClasses.addAll(reflections.getTypesAnnotatedWith(Controller.class));
            try {
                controllerClasses.addAll(reflections.getTypesAnnotatedWith(RestController.class));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.debug("No RestController found.  RestController is found in Spring 4.  This is potentially an earlier version of Spring", (Throwable)e);
            }
        }
        return this.processControllers(controllerClasses);
    }

    private Map<String, ApiListing> processControllers(Set<Class<?>> controllerClasses) {
        for (Class<?> controllerClass : controllerClasses) {
            ApiListing existingApiListing;
            if (ApiDocumentationController.class.isAssignableFrom(controllerClass)) continue;
            Set<Method> requestMappingMethods = AnnotationUtils.getAnnotatedMethods(controllerClass, RequestMapping.class);
            ApiListing apiListing = this.processControllerApi(controllerClass);
            String description = "";
            Api controllerApi = controllerClass.getAnnotation(Api.class);
            if (controllerApi != null) {
                description = controllerApi.description();
            }
            if (apiListing.apis().size() == 0) {
                apiListing = this.processMethods(requestMappingMethods, controllerClass, apiListing, description);
            }
            if ((existingApiListing = this.apiListingMap.get(apiListing.resourcePath())) != null) {
                apiListing = ApiListingUtil.mergeApiListing(existingApiListing, apiListing);
            }
            if (apiListing.apis() == null || apiListing.apis().isEmpty()) continue;
            this.apiListingMap.put(apiListing.resourcePath(), apiListing);
        }
        return this.apiListingMap;
    }

    private ApiListing processControllerApi(Class<?> controllerClass) {
        String docRoot;
        String resourcePath = "";
        Api controllerApi = controllerClass.getAnnotation(Api.class);
        if (controllerApi != null) {
            resourcePath = controllerApi.basePath();
        }
        if (controllerApi == null || resourcePath.isEmpty()) {
            RequestMapping controllerRequestMapping = controllerClass.getAnnotation(RequestMapping.class);
            resourcePath = controllerRequestMapping != null && controllerRequestMapping.value() != null && controllerRequestMapping.value().length > 0 ? controllerRequestMapping.value()[0] : controllerClass.getName();
        }
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        if ((docRoot = resourcePath).contains(controllerClass.getName())) {
            docRoot = docRoot.replace(controllerClass.getName(), "");
        }
        SpringApiReader reader = new SpringApiReader();
        Option<ApiListing> apiListingOption = reader.read(docRoot, controllerClass, this.swaggerConfig);
        ApiListing apiListing = null;
        if (apiListingOption.nonEmpty()) {
            apiListing = (ApiListing)apiListingOption.get();
        }
        if (apiListing != null) {
            return apiListing;
        }
        return ApiListingUtil.baseApiListing(this.apiVersion, swaggerVersion, this.basePath, resourcePath);
    }

    private ApiListing processMethods(Collection<Method> methods, Class<?> controllerClass, ApiListing apiListing, String description) {
        HashMap<String, ApiDescription> endpoints = new HashMap<String, ApiDescription>();
        HashMap<String, Model> models = new HashMap<String, Model>();
        HashMap operations = new HashMap();
        ArrayList<ApiDescription> descriptions = new ArrayList<ApiDescription>();
        this.populateApiDescriptionMapForApiListing(apiListing, endpoints);
        ApiModelParser apiModelParser = new ApiModelParser(models);
        String resourcePath = apiListing.resourcePath();
        if (resourcePath.contains(controllerClass.getName())) {
            resourcePath = resourcePath.replace("/" + controllerClass.getName(), "");
        }
        for (Method method : methods) {
            ArrayList<Operation> ops;
            if (this.ignore(method)) continue;
            String value = AnnotationUtils.getMethodRequestMappingValue(method);
            ApiDescriptionParser documentationEndPointParser = new ApiDescriptionParser();
            ApiDescription apiDescription = documentationEndPointParser.parseApiDescription(method, description, resourcePath);
            if (!endpoints.containsKey(value)) {
                endpoints.put(value, apiDescription);
            }
            if ((ops = (ArrayList<Operation>)operations.get(value)) == null) {
                ops = new ArrayList<Operation>();
                operations.put(value, ops);
            }
            ApiOperationParser apiOperationParser = new ApiOperationParser(resourcePath, this.ignorableAnnotations, this.ignoreUnusedPathVariables, models);
            Operation operation = apiOperationParser.parseDocumentationOperation(method);
            ops.add(operation);
            apiModelParser.parseResponseBodyModels(method);
        }
        for (String key : endpoints.keySet()) {
            ApiDescription apiDescription = (ApiDescription)endpoints.get(key);
            ApiDescription newApiDescription = new ApiDescription(apiDescription.path(), apiDescription.description(), JavaToScalaUtil.toScalaList((List)operations.get(key)));
            descriptions.add(newApiDescription);
        }
        Option modelOptions = Option.apply(JavaToScalaUtil.toScalaImmutableMap(models));
        return new ApiListing(apiListing.apiVersion(), apiListing.swaggerVersion(), apiListing.basePath(), apiListing.resourcePath(), apiListing.produces(), apiListing.consumes(), apiListing.protocols(), apiListing.authorizations(), JavaToScalaUtil.toScalaList(descriptions), modelOptions, apiListing.description(), apiListing.position());
    }

    private void populateApiDescriptionMapForApiListing(ApiListing apiListing, Map<String, ApiDescription> apiDescriptionMap) {
        if (apiListing.apis() != null) {
            List<ApiDescription> apiDescriptions = ScalaToJavaUtil.toJavaList(apiListing.apis());
            for (ApiDescription apiDescription : apiDescriptions) {
                apiDescriptionMap.put(apiDescription.path(), apiDescription);
            }
        }
    }

    private boolean ignore(Method method) {
        for (Filter filter : this.filters) {
            if (!filter.isApplicable(method) || !filter.ignore(method)) continue;
            return true;
        }
        return false;
    }
}

