/*
 * Decompiled with CFR 0.152.
 */
package com.knappsack.swagger4springweb.parser;

import com.knappsack.swagger4springweb.parser.ApiParameterParser;
import com.knappsack.swagger4springweb.parser.ApiPathParser;
import com.knappsack.swagger4springweb.util.JavaToScalaUtil;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.model.AuthorizationScope;
import com.wordnik.swagger.model.Model;
import com.wordnik.swagger.model.Operation;
import com.wordnik.swagger.model.Parameter;
import com.wordnik.swagger.model.ResponseMessage;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import scala.Option;
import scala.collection.immutable.Map;

public class ApiOperationParser {
    private final java.util.Map<String, Model> models;
    private String resourcePath;
    private List<String> ignorableAnnotations;
    private boolean ignoreUnusedPathVariables;

    public ApiOperationParser(String resourcePath, List<String> ignorableAnnotations, boolean ignoreUnusedPathVariables, java.util.Map<String, Model> models) {
        this.ignorableAnnotations = ignorableAnnotations;
        this.ignoreUnusedPathVariables = ignoreUnusedPathVariables;
        this.resourcePath = resourcePath;
        this.models = models;
    }

    public Operation parseDocumentationOperation(Method method) {
        ApiResponses apiResponses;
        ApiResponse apiResponse;
        ParameterizedType parameterizedType;
        DocumentationOperation documentationOperation = new DocumentationOperation();
        documentationOperation.setNickname(method.getName());
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)returnType).getActualTypeArguments().length == 1) {
            Type type = parameterizedType.getActualTypeArguments()[0];
            documentationOperation.setResponseClass(this.getResponseClass(type));
            documentationOperation.setResponseContainer((Class)parameterizedType.getRawType());
        }
        if (StringUtils.isEmpty((Object)documentationOperation.getResponseClass())) {
            Class<?> clazz = method.getReturnType();
            if (clazz.isArray()) {
                documentationOperation.setResponseClass(clazz.getComponentType());
            } else {
                documentationOperation.setResponseClass(clazz);
            }
        }
        String httpMethod = "";
        RequestMapping methodRequestMapping = method.getAnnotation(RequestMapping.class);
        for (RequestMethod requestMethod : methodRequestMapping.method()) {
            httpMethod = httpMethod + requestMethod.name() + " ";
        }
        if (StringUtils.isEmpty((Object)(httpMethod = httpMethod.trim())) || " ".equals(httpMethod)) {
            httpMethod = HttpMethod.GET.toString();
        }
        documentationOperation.setHttpMethod(httpMethod);
        documentationOperation.addConsumes(this.getConsumes(method, methodRequestMapping));
        documentationOperation.addProduces(this.getProduces(method, methodRequestMapping));
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            documentationOperation.setHttpMethod(apiOperation.httpMethod());
            documentationOperation.setResponseClass(apiOperation.response());
            documentationOperation.setResponseContainer(apiOperation.responseContainer());
            documentationOperation.addProduces(apiOperation.produces());
            documentationOperation.addConsumes(apiOperation.consumes());
            documentationOperation.setSummary(apiOperation.value());
            documentationOperation.setNotes(apiOperation.notes());
            documentationOperation.setPosition(apiOperation.position());
            documentationOperation.addProtocols(apiOperation.protocols());
            documentationOperation.addAuthorizations(apiOperation.authorizations());
        }
        if ((apiResponse = method.getAnnotation(ApiResponse.class)) != null) {
            this.addResponse(documentationOperation, apiResponse);
        }
        if ((apiResponses = method.getAnnotation(ApiResponses.class)) != null) {
            ApiResponse[] responses;
            for (ApiResponse response : responses = apiResponses.value()) {
                this.addResponse(documentationOperation, response);
            }
        }
        ApiParameterParser apiParameterParser = new ApiParameterParser(this.ignorableAnnotations, this.models);
        List<Parameter> documentationParameters = apiParameterParser.parseApiParametersAndArgumentModels(method);
        documentationOperation.setParameters(documentationParameters);
        this.addUnusedPathVariables(documentationOperation, methodRequestMapping.value());
        return documentationOperation.toScalaOperation();
    }

    private void addResponse(DocumentationOperation documentationOperation, ApiResponse apiResponse) {
        Option responseOption = Option.apply((Object)apiResponse.response().getName());
        ResponseMessage responseMessage = new ResponseMessage(apiResponse.code(), apiResponse.message(), responseOption);
        documentationOperation.addResponseMessage(responseMessage);
    }

    private void addUnusedPathVariables(DocumentationOperation documentationOperation, String[] methodPath) {
        if (this.ignoreUnusedPathVariables) {
            return;
        }
        for (Parameter documentationParameter : new ApiPathParser().getPathParameters(this.resourcePath, methodPath)) {
            if (this.isParameterPresented(documentationOperation, documentationParameter.name())) continue;
            documentationOperation.addParameter(documentationParameter);
        }
    }

    private boolean isParameterPresented(DocumentationOperation documentationOperation, String parameter) {
        if (documentationOperation.getParameters().isEmpty()) {
            return false;
        }
        for (Parameter documentationParameter : documentationOperation.getParameters()) {
            if (!parameter.equals(documentationParameter.name())) continue;
            return true;
        }
        return false;
    }

    private List<String> getConsumes(Method method, RequestMapping methodRequestMapping) {
        RequestMapping controllerRequestMapping;
        List<String> consumes = Arrays.asList(methodRequestMapping.consumes());
        if (consumes.isEmpty() && (controllerRequestMapping = method.getDeclaringClass().getAnnotation(RequestMapping.class)) != null) {
            consumes = Arrays.asList(controllerRequestMapping.consumes());
        }
        return consumes;
    }

    private List<String> getProduces(Method method, RequestMapping methodRequestMapping) {
        RequestMapping controllerRequestMapping;
        List<String> produces = Arrays.asList(methodRequestMapping.produces());
        if (produces.isEmpty() && (controllerRequestMapping = method.getDeclaringClass().getAnnotation(RequestMapping.class)) != null) {
            produces = Arrays.asList(controllerRequestMapping.produces());
        }
        return produces;
    }

    private Class<?> getResponseClass(Type type) {
        Class responseClass = null;
        if (type instanceof ParameterizedType) {
            responseClass = (Class)((ParameterizedType)type).getRawType();
        } else if (type instanceof WildcardType) {
            Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (lowerBounds.length > 0) {
                responseClass = (Class)lowerBounds[0];
            } else if (upperBounds.length > 0) {
                responseClass = (Class)upperBounds[0];
            }
        } else {
            responseClass = (Class)type;
        }
        return responseClass;
    }

    class DocumentationOperation {
        private String nickname;
        private String responseClass;
        private String summary;
        private String notes;
        private String httpMethod;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private List<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        private int position;
        private List<String> produces = new ArrayList<String>();
        private List<String> consumes = new ArrayList<String>();
        private List<String> protocols = new ArrayList<String>();
        private List<com.wordnik.swagger.model.Authorization> authorizations = new ArrayList<com.wordnik.swagger.model.Authorization>();

        DocumentationOperation() {
        }

        Operation toScalaOperation() {
            return new Operation(this.httpMethod, this.summary, this.notes, this.responseClass, this.nickname, this.position, JavaToScalaUtil.toScalaList(this.produces), JavaToScalaUtil.toScalaList(this.consumes), JavaToScalaUtil.toScalaList(this.protocols), JavaToScalaUtil.toScalaList(this.authorizations), JavaToScalaUtil.toScalaList(this.parameters), JavaToScalaUtil.toScalaList(this.responseMessages), null);
        }

        void setNickname(String nickname) {
            this.nickname = nickname;
        }

        void setResponseClass(Class<?> responseClass) {
            if (responseClass == null || responseClass == Void.class) {
                return;
            }
            Option model = ModelConverters.read(responseClass, (Map)ModelConverters.typeMap());
            this.responseClass = model.nonEmpty() ? ((Model)model.get()).name() : responseClass.getSimpleName();
        }

        void setSummary(String summary) {
            this.summary = summary;
        }

        void setNotes(String notes) {
            this.notes = notes;
        }

        void setHttpMethod(String httpMethod) {
            if (StringUtils.isEmpty((Object)httpMethod)) {
                return;
            }
            this.httpMethod = httpMethod;
        }

        void setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
        }

        void setPosition(int position) {
            this.position = position;
        }

        void addConsumes(List<String> consumes) {
            this.consumes.addAll(consumes);
        }

        void addProduces(List<String> produces) {
            this.produces.addAll(produces);
        }

        public void addResponseMessage(ResponseMessage responseMessage) {
            this.responseMessages.add(responseMessage);
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void addParameter(Parameter parameter) {
            this.parameters.add(parameter);
        }

        public void addAuthorizations(Authorization[] authorizations) {
            if (ArrayUtils.isEmpty((Object[])authorizations)) {
                return;
            }
            for (Authorization authorization : authorizations) {
                AuthorizationScope[] authorizationScopes = new AuthorizationScope[authorization.scopes().length];
                for (int i = 0; i < authorization.scopes().length; ++i) {
                    com.wordnik.swagger.annotations.AuthorizationScope authScope = authorization.scopes()[i];
                    authorizationScopes[i] = new AuthorizationScope(authScope.scope(), authScope.description());
                }
                this.authorizations.add(new com.wordnik.swagger.model.Authorization(authorization.value(), authorizationScopes));
            }
        }

        void addProtocols(String protocols) {
            if (StringUtils.isEmpty((Object)protocols)) {
                return;
            }
            this.protocols.add(protocols);
        }

        public void addProduces(String produces) {
            if (StringUtils.isEmpty((Object)produces)) {
                return;
            }
            this.produces.add(produces);
        }

        public void addConsumes(String consumes) {
            if (StringUtils.isEmpty((Object)consumes)) {
                return;
            }
            this.consumes.add(consumes);
        }

        public void setResponseContainer(String container) {
            if (StringUtils.isEmpty((Object)container)) {
                return;
            }
            this.responseClass = String.format("%s[%s]", container, this.responseClass);
        }

        public void setResponseContainer(Class<?> type) {
            Option model = ModelConverters.read(type, (Map)ModelConverters.typeMap());
            if (model.nonEmpty()) {
                this.setResponseContainer(((Model)model.get()).name());
            } else {
                this.setResponseContainer(type.getSimpleName());
            }
        }

        public String getResponseClass() {
            return this.responseClass;
        }
    }
}

