/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.DetailData;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class BufferList
implements DetailData {
    private boolean enabled = true;
    private int bufferSize = 50;
    private String[] header;
    private LinkedList bufferList = new LinkedList();

    public BufferList(String[] header) {
        this.header = header;
    }

    public BufferList(String[] header, int bufferSize) {
        this.header = header;
        this.bufferSize = bufferSize;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized void setBufferSize(int newBufferSize) {
        if (this.bufferSize > newBufferSize) {
            this.resetBuffer(this.reduceBuffer(newBufferSize));
        }
        this.bufferSize = newBufferSize;
    }

    private LinkedList reduceBuffer(int newSize) {
        LinkedList newBuffer = new LinkedList();
        Collections.reverse(this.bufferList);
        Iterator iter = this.bufferList.iterator();
        for (int i = 0; iter.hasNext() && i < newSize; ++i) {
            newBuffer.add(iter.next());
        }
        return newBuffer;
    }

    public synchronized void resetBuffer() {
        this.resetBuffer(new LinkedList());
    }

    private void resetBuffer(LinkedList bufferList) {
        this.bufferList = bufferList;
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public boolean hasData() {
        return !this.isEmpty();
    }

    public int getRowCount() {
        return this.bufferList == null ? 0 : this.bufferList.size();
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized void reset() {
        this.bufferList = new LinkedList();
    }

    public String[] getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getData() {
        Object[] bufferListArray = null;
        BufferList bufferList = this;
        synchronized (bufferList) {
            if (this.bufferList.size() > 0) {
                bufferListArray = this.bufferList.toArray();
            }
        }
        if (bufferListArray == null) {
            return null;
        }
        Object[][] data = new Object[bufferListArray.length][];
        for (int i = 0; i < bufferListArray.length; ++i) {
            data[i] = bufferListArray[i] instanceof Object[] ? (Object[])bufferListArray[i] : new Object[]{bufferListArray[i]};
        }
        return data;
    }

    public synchronized void addRow(Object[] row) {
        this.addRow((Object)row);
    }

    public synchronized void addRow(Object obj) {
        if (!this.enabled || this.bufferSize <= 0) {
            return;
        }
        if (this.bufferList.size() >= this.bufferSize) {
            this.bufferList.removeFirst();
        }
        this.bufferList.addLast(obj);
    }
}

