package com.jamonapi;

/** Used in MonKeys.  Pass a generalized form to the summaryLabel and a specific form to the 
 * detailLabel.  (i.e. summary=myproc ?,?, detail=myproc 'steve','souza'.  Make sure you 
 * don't pass the arguments in the wrong order as jamon uses the summary label for jamon aggregate
 * stats, and you don't want every non-generalized form to become a jamon record.
 * 
 * @author steve souza
 *
 */
public class MonKeyItemBase implements MonKeyItem {
	private String summaryLabel;
	private String detailLabel;

	public MonKeyItemBase(String summaryLabel) {
		this.summaryLabel=summaryLabel;
		this.detailLabel=summaryLabel;
	}
	
	public MonKeyItemBase(String summaryLabel, String detailLabel) {
		this.summaryLabel=summaryLabel;
		this.detailLabel=detailLabel;
	}
	

	public String getDetailLabel() {
		return detailLabel;
	}
	
	public void setDetailLabel(String detailLabel) {
		this.detailLabel=detailLabel;
    }

	
	/** should call getSummaryLabel */
	public String toString(){
		return summaryLabel;
	}


}
