package com.jamonapi;

import com.jamonapi.utils.*;

/** JAMonListener that puts jamon data into a buffer that allows you to display the last N configurble
 * detail events.  The buffer will have the detail label, value and invocation date for the monitor that 
 * was fired.
 * 
 * @author steve souza
 *
 */

public  class JAMonBufferListener implements JAMonListener, DetailData, CopyJAMonListener {

	private BufferList list;
	private String name;
	
	public JAMonBufferListener() {
		this("JAMonBufferListener");
	}
	
	/** Pass in the jamonListener name */
	
	public JAMonBufferListener(String name){
		this(name, new BufferList(new String[] {"Label","Value","Active","Date"},50));
	}
	
	/** Name the listener and pass in the jamon BufferList to use */
	public JAMonBufferListener(String name, BufferList list) {
		this.name=name;
		this.list=list;
	}
		
	/** When this event is fired the monitor will be added to the rolling buffer */
	public void processEvent(Monitor mon) {
		list.addRow(mon.getJAMonDetailRow());
	}
	
	/** Add a row to the buffer */
	public void addRow(JAMonDetailRow row) {
		list.addRow(row);
	}
	
	/** get teh underlying bufferList which can then be used to display its contents */
	public BufferList getBufferList() {
		return list;
	}

	public String getName() {
	    return name;
    }
	
	public void setName(String name) {
	   this.name=name;
	    
    }
	
	public JAMonListener copy() {
		return new JAMonBufferListener(getName(), new BufferList(getHeader(), list.getBufferSize()));
	}



	public Object[][] getData() {
		Object[][] data=list.getData();
		for (int i=0;i<list.getRowCount();i++) {
      	   if (data[i][0] instanceof JAMonDetailRow)
	         data[i]=((JAMonDetailRow)data[i][0]).getJAMonDetailRow(); 
		}

	    return data;
    }

	public String[] getHeader() {
	    return list.getHeader();
    }



	

}
