/*
 * Decompiled with CFR 0.152.
 */
package com.jackpocket.spinwheelview;

import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class SpinnerTask
implements Runnable {
    private static final int UPDATE_RATE = 12;
    private SpinTaskCallbacks callbacks;
    private boolean canceled = false;
    private float startingRotation = 0.0f;
    private float currentRotationDegrees = 0.0f;
    private float targetRotationDifference = 0.0f;
    private long startTime = 0L;
    private float duration = 4950.0f;
    private float percentCompleted = 0.0f;
    private Interpolator interpolator = new DecelerateInterpolator();

    public SpinnerTask(float startingRotationDegrees, float targetRotationDegrees, float force, SpinTaskCallbacks callbacks) {
        this.currentRotationDegrees = this.startingRotation = startingRotationDegrees % 360.0f;
        this.targetRotationDifference = (float)(360 * (int)(3.0f * force)) + targetRotationDegrees - this.startingRotation;
        this.callbacks = callbacks;
    }

    public SpinnerTask setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        try {
            while ((float)(System.currentTimeMillis() - this.startTime) < this.duration && !this.canceled) {
                this.percentCompleted = this.interpolator.getInterpolation((float)(System.currentTimeMillis() - this.startTime) / this.duration);
                this.currentRotationDegrees = this.startingRotation + this.percentCompleted * this.targetRotationDifference;
                this.callbacks.update(this.currentRotationDegrees);
                Thread.sleep(12L);
            }
            if (!this.canceled) {
                this.callbacks.onSpinComplete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    public static interface SpinTaskCallbacks {
        public void update(float var1);

        public void onSpinComplete();
    }
}

