/*
 * Decompiled with CFR 0.152.
 */
package com.jackpocket.spinwheelview;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.jackpocket.spinwheelview.SpinnerTask;

public class SpinWheelView
extends ImageView
implements SpinnerTask.SpinTaskCallbacks {
    public static final float MIN_FORCE = 0.0f;
    public static final float MAX_FORCE = 3.0f;
    private static final float FORCE_ADJUSTMENT = 2.0f;
    private float currentRotationDegrees = 0.0f;
    private SpinnerTask spinnerTask;
    private boolean running = false;
    private Runnable spinCompletionListener;

    public SpinWheelView(Context context) {
        super(context);
        this.init();
    }

    public SpinWheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SpinWheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.setWillNotDraw(false);
    }

    public SpinWheelView setSpinCompletionListener(Runnable spinCompletionListener) {
        this.spinCompletionListener = spinCompletionListener;
        return this;
    }

    public void spinTo(float targetRotationDegrees) {
        this.spinTo(targetRotationDegrees, 1.5f);
    }

    public void spinTo(float targetRotationDegrees, float force) {
        this.spinTo(targetRotationDegrees, force, true);
    }

    public void spinTo(float targetRotationDegrees, float force, boolean clockwise) {
        if (this.running) {
            return;
        }
        this.stop();
        force = Math.min(force, 3.0f);
        force = Math.max(force, 0.0f);
        this.spinnerTask = new SpinnerTask(this.currentRotationDegrees, targetRotationDegrees % 360.0f, (force += 2.0f) * (float)(clockwise ? 1 : -1), this);
        this.running = true;
        new Thread(this.spinnerTask).start();
    }

    @Override
    public void update(final float currentRotationDegrees) {
        this.post(new Runnable(){

            @Override
            public void run() {
                SpinWheelView.this.currentRotationDegrees = currentRotationDegrees;
                SpinWheelView.this.invalidate();
            }
        });
    }

    @Override
    public void onSpinComplete() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (SpinWheelView.this.spinCompletionListener != null) {
                    SpinWheelView.this.spinCompletionListener.run();
                }
            }
        });
        this.stop();
    }

    public void onDraw(Canvas canvas) {
        canvas.save();
        canvas.rotate(this.currentRotationDegrees, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
        super.onDraw(canvas);
        canvas.restore();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    private void stop() {
        this.running = false;
        try {
            if (this.spinnerTask != null) {
                this.spinnerTask.cancel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

