/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;

public class ClipPathSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer {
    private AbstractSvgNodeRenderer clippedRenderer;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        ClipPathSvgNodeRenderer copy = new ClipPathSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    @Override
    void preDraw(SvgDrawContext context) {
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        for (ISvgNodeRenderer child : this.getChildren()) {
            currentCanvas.saveState();
            if (child instanceof AbstractSvgNodeRenderer) {
                ((AbstractSvgNodeRenderer)child).setPartOfClipPath(true);
            }
            child.draw(context);
            if (child instanceof AbstractSvgNodeRenderer) {
                ((AbstractSvgNodeRenderer)child).setPartOfClipPath(false);
            }
            if (this.clippedRenderer != null) {
                this.clippedRenderer.preDraw(context);
                this.clippedRenderer.doDraw(context);
                this.clippedRenderer.postDraw(context);
            }
            currentCanvas.restoreState();
        }
    }

    public void setClippedRenderer(AbstractSvgNodeRenderer clippedRenderer) {
        this.clippedRenderer = clippedRenderer;
    }
}

