/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.selector;

import com.itextpdf.styledxmlparser.css.parse.CssSelectorParser;
import com.itextpdf.styledxmlparser.css.pseudo.CssPseudoElementNode;
import com.itextpdf.styledxmlparser.css.selector.AbstractCssSelector;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoElementSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssSeparatorSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.ICssSelectorItem;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.List;

public class CssSelector
extends AbstractCssSelector {
    public CssSelector(List<ICssSelectorItem> selectorItems) {
        super(selectorItems);
    }

    public CssSelector(String selector) {
        this(CssSelectorParser.parseSelectorItems(selector));
    }

    @Override
    public boolean matches(INode element) {
        return this.matches(element, this.selectorItems.size() - 1);
    }

    public boolean notMatches(INode element) {
        for (int counter = 0; counter != this.selectorItems.size(); ++counter) {
            boolean matches = this.matches(element, this.selectorItems.size() - counter - 1);
            if (!matches) continue;
            return false;
        }
        return true;
    }

    private boolean matches(INode element, int lastSelectorItemInd) {
        if (!(element instanceof IElementNode)) {
            return false;
        }
        if (lastSelectorItemInd < 0) {
            return true;
        }
        boolean isPseudoElement = element instanceof CssPseudoElementNode;
        for (int i = lastSelectorItemInd; i >= 0; --i) {
            ICssSelectorItem currentItem;
            if (isPseudoElement && this.selectorItems.get(lastSelectorItemInd) instanceof CssPseudoElementSelectorItem && i < lastSelectorItemInd) {
                element = element.parentNode();
                isPseudoElement = false;
            }
            if ((currentItem = (ICssSelectorItem)this.selectorItems.get(i)) instanceof CssSeparatorSelectorItem) {
                char separator = ((CssSeparatorSelectorItem)currentItem).getSeparator();
                switch (separator) {
                    case '>': {
                        return this.matches(element.parentNode(), i - 1);
                    }
                    case ' ': {
                        for (INode parent = element.parentNode(); parent != null; parent = parent.parentNode()) {
                            boolean parentMatches = this.matches(parent, i - 1);
                            if (!parentMatches) continue;
                            return true;
                        }
                        return false;
                    }
                    case '~': {
                        INode parent = element.parentNode();
                        if (parent != null) {
                            int indexOfElement = parent.childNodes().indexOf(element);
                            for (int j = indexOfElement - 1; j >= 0; --j) {
                                if (!this.matches(parent.childNodes().get(j), i - 1)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    case '+': {
                        INode parent = element.parentNode();
                        if (parent != null) {
                            int indexOfElement = parent.childNodes().indexOf(element);
                            INode previousElement = null;
                            for (int j = indexOfElement - 1; j >= 0; --j) {
                                if (!(parent.childNodes().get(j) instanceof IElementNode)) continue;
                                previousElement = parent.childNodes().get(j);
                                break;
                            }
                            if (previousElement != null) {
                                return indexOfElement > 0 && this.matches(previousElement, i - 1);
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
            if (currentItem.matches(element)) continue;
            return false;
        }
        return true;
    }
}

