/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.xml;

import com.itextpdf.signatures.validation.report.xml.CertificateWrapper;
import com.itextpdf.signatures.validation.report.xml.CollectableObjectVisitor;
import com.itextpdf.signatures.validation.report.xml.Identifier;
import com.itextpdf.signatures.validation.report.xml.POEValidationReport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XmlGeneratorCollectableObjectVisitor
implements CollectableObjectVisitor {
    private final Document doc;
    private final Node parent;

    public XmlGeneratorCollectableObjectVisitor(Document doc, Node parent) {
        this.doc = doc;
        this.parent = parent;
    }

    @Override
    public void visit(CertificateWrapper certificateWrapper) {
        Node validationObject = this.createValidationObjectElement(certificateWrapper.getIdentifier(), "urn:etsi:019102:validationObject:certificate");
        Element representation = this.doc.createElement("ValidationObjectRepresentation");
        Element b64 = this.doc.createElement("base64");
        b64.setTextContent(certificateWrapper.getBase64ASN1Structure());
        representation.appendChild(b64);
        validationObject.appendChild(representation);
        this.parent.appendChild(validationObject);
    }

    @Override
    public void visit(POEValidationReport poeValidationReport) {
    }

    private Node createValidationObjectElement(Identifier identifier, String typeName) {
        Element validationObject = this.doc.createElement("ValidationObject");
        validationObject.setAttribute("id", identifier.getId());
        Element objectType = this.doc.createElement("ObjectType");
        objectType.setTextContent(typeName);
        validationObject.appendChild(objectType);
        return validationObject;
    }
}

