/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report;

import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ValidationReport {
    private final List<ReportItem> reportItems = new ArrayList<ReportItem>();

    public ValidationReport() {
    }

    public ValidationReport(ValidationReport report) {
        for (ReportItem item : report.reportItems) {
            this.addReportItem(new ReportItem(item));
        }
    }

    public ValidationResult getValidationResult() {
        if (this.reportItems.stream().anyMatch(reportItem -> reportItem.getStatus() == ReportItem.ReportItemStatus.INVALID)) {
            return ValidationResult.INVALID;
        }
        if (this.reportItems.stream().anyMatch(reportItem -> reportItem.getStatus() == ReportItem.ReportItemStatus.INDETERMINATE)) {
            return ValidationResult.INDETERMINATE;
        }
        return ValidationResult.VALID;
    }

    public List<ReportItem> getFailures() {
        return this.reportItems.stream().filter(item -> item.getStatus() != ReportItem.ReportItemStatus.INFO).collect(Collectors.toList());
    }

    public List<CertificateReportItem> getCertificateFailures() {
        return this.getFailures().stream().filter(item -> item instanceof CertificateReportItem).map(item -> (CertificateReportItem)item).collect(Collectors.toList());
    }

    public List<ReportItem> getLogs() {
        return Collections.unmodifiableList(this.reportItems);
    }

    public List<CertificateReportItem> getCertificateLogs() {
        return this.reportItems.stream().filter(item -> item instanceof CertificateReportItem).map(item -> (CertificateReportItem)item).collect(Collectors.toList());
    }

    public void addReportItem(ReportItem item) {
        this.reportItems.add(item);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValidationReport{validationResult=");
        sb.append((Object)this.getValidationResult()).append("\nreportItems=");
        for (ReportItem i : this.reportItems) {
            sb.append(i).append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public ValidationReport merge(ValidationReport subReport) {
        if (subReport != null) {
            for (ReportItem item : subReport.getLogs()) {
                this.addReportItem(item);
            }
        }
        return this;
    }

    public ValidationReport mergeWithDifferentStatus(ValidationReport subReport, ReportItem.ReportItemStatus newStatus) {
        if (subReport != null) {
            for (ReportItem item : subReport.getLogs()) {
                this.addReportItem(new ReportItem(item).setStatus(newStatus));
            }
        }
        return this;
    }

    public static enum ValidationResult {
        VALID,
        INVALID,
        INDETERMINATE;

    }
}

