/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.lotl.AbstractXmlCertificateHandler;
import com.itextpdf.signatures.validation.lotl.SimpleServiceContext;
import java.security.cert.X509Certificate;
import java.util.HashMap;

class XmlDefaultCertificateHandler
extends AbstractXmlCertificateHandler {
    private StringBuilder information;

    XmlDefaultCertificateHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, HashMap<String, String> attributes) {
        if ("X509Certificate".equals(localName)) {
            this.information = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("X509Certificate".equals(localName)) {
            X509Certificate certificate = CertificateUtil.createCertificateFromEncodedData(XmlDefaultCertificateHandler.removeWhitespacesAndBreakLines(this.information.toString()));
            this.serviceContextList.add(new SimpleServiceContext(certificate));
        }
        this.information = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.information != null) {
            this.information.append(ch, start, length);
        }
    }

    private static String removeWhitespacesAndBreakLines(String data) {
        return data.replace(" ", "").replace("\n", "");
    }
}

