/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.signatures.validation.lotl.CountrySpecificLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanResourceFetcher;
import com.itextpdf.signatures.validation.lotl.IOnFailingCountryLotlData;
import com.itextpdf.signatures.validation.lotl.InvalidLotlDataException;
import com.itextpdf.signatures.validation.lotl.LotlCacheDataV1;
import com.itextpdf.signatures.validation.lotl.LotlServiceCache;
import com.itextpdf.signatures.validation.lotl.PivotFetcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class InMemoryLotlServiceCache
implements LotlServiceCache {
    private static final String CACHE_KEY_LOTL = "lotlCache";
    private static final String CACHE_KEY_EU_JOURNAL_CERTIFICATES = "europeanResourceFetcherCache";
    private final Object lock = new Object();
    private final long maxAllowedStalenessInMillis;
    private final HashMap<String, Long> timeStamps = new HashMap();
    private final IOnFailingCountryLotlData strategy;
    private EuropeanLotlFetcher.Result lotlCache = null;
    private PivotFetcher.Result pivotCache = null;
    private EuropeanResourceFetcher.Result europeanResourceFetcherCache = null;
    private Map<String, CountrySpecificLotlFetcher.Result> countrySpecificLotlCache = null;

    InMemoryLotlServiceCache(long maxAllowedStalenessInMillis, IOnFailingCountryLotlData strategy) {
        this.maxAllowedStalenessInMillis = maxAllowedStalenessInMillis;
        this.strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllValues(EuropeanLotlFetcher.Result lotlXml, EuropeanResourceFetcher.Result europeanResourceFetcherEUJournalCertificates, PivotFetcher.Result result, Map<String, CountrySpecificLotlFetcher.Result> countrySpecificResult) {
        Object object = this.lock;
        synchronized (object) {
            this.lotlCache = lotlXml;
            this.addToStaleTracker(CACHE_KEY_LOTL);
            this.europeanResourceFetcherCache = europeanResourceFetcherEUJournalCertificates;
            this.addToStaleTracker(CACHE_KEY_EU_JOURNAL_CERTIFICATES);
            this.pivotCache = result;
            this.addToStaleTracker(this.pivotCache.generateUniqueIdentifier());
            for (Map.Entry<String, CountrySpecificLotlFetcher.Result> entry : countrySpecificResult.entrySet()) {
                this.setSpecificCountryInternally(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PivotFetcher.Result getPivotResult() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isObjectStale(this.pivotCache.generateUniqueIdentifier())) {
                throw new InvalidLotlDataException("Cached data is older then configured staleness. This means that the cache has failed to update automatically for the configured period. Please, refresh using LotlService#intializeCache, or look into the generated log messages for more details on why the cache has not been updated.");
            }
            return this.pivotCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPivotResult(PivotFetcher.Result newResult) {
        Object object = this.lock;
        synchronized (object) {
            this.pivotCache = newResult;
            this.addToStaleTracker(newResult.generateUniqueIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, CountrySpecificLotlFetcher.Result> getCountrySpecificLotls() {
        Object object = this.lock;
        synchronized (object) {
            if (this.countrySpecificLotlCache == null) {
                this.countrySpecificLotlCache = new HashMap<String, CountrySpecificLotlFetcher.Result>();
            }
            HashMap<String, CountrySpecificLotlFetcher.Result> newValues = new HashMap<String, CountrySpecificLotlFetcher.Result>(this.countrySpecificLotlCache);
            for (String s : this.countrySpecificLotlCache.keySet()) {
                CountrySpecificLotlFetcher.Result result = this.getCountrySpecificLotl(s);
                newValues.put(s, result);
            }
            this.countrySpecificLotlCache = newValues;
            return Collections.unmodifiableMap(this.countrySpecificLotlCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCountrySpecificLotlResult(CountrySpecificLotlFetcher.Result countrySpecificLotlResult) {
        Object object = this.lock;
        synchronized (object) {
            this.setSpecificCountryInternally(countrySpecificLotlResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EuropeanLotlFetcher.Result getLotlResult() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isObjectStale(CACHE_KEY_LOTL)) {
                throw new InvalidLotlDataException("Cached data is older then configured staleness. This means that the cache has failed to update automatically for the configured period. Please, refresh using LotlService#intializeCache, or look into the generated log messages for more details on why the cache has not been updated.");
            }
            return this.lotlCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLotlResult(EuropeanLotlFetcher.Result data) {
        Object object = this.lock;
        synchronized (object) {
            this.lotlCache = data;
            this.addToStaleTracker(CACHE_KEY_LOTL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEuropeanResourceFetcherResult(EuropeanResourceFetcher.Result result) {
        Object object = this.lock;
        synchronized (object) {
            this.europeanResourceFetcherCache = result;
            this.addToStaleTracker(CACHE_KEY_EU_JOURNAL_CERTIFICATES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EuropeanResourceFetcher.Result getEUJournalCertificates() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isObjectStale(CACHE_KEY_EU_JOURNAL_CERTIFICATES)) {
                throw new InvalidLotlDataException("Cached data is older then configured staleness. This means that the cache has failed to update automatically for the configured period. Please, refresh using LotlService#intializeCache, or look into the generated log messages for more details on why the cache has not been updated.");
            }
            return this.europeanResourceFetcherCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, Long> getTimeStamps() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<String, Long>(this.timeStamps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeStamps(Map<String, Long> timeStamps) {
        Object object = this.lock;
        synchronized (object) {
            this.timeStamps.clear();
            this.timeStamps.putAll(timeStamps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LotlCacheDataV1 getAllData() {
        Object object = this.lock;
        synchronized (object) {
            return new LotlCacheDataV1(this.lotlCache, this.pivotCache, this.europeanResourceFetcherCache, this.countrySpecificLotlCache, this.timeStamps);
        }
    }

    private boolean isObjectStale(String key) {
        Long lastUpdated = this.timeStamps.get(key);
        if (lastUpdated == null) {
            return true;
        }
        long lastUpdatedInMillis = lastUpdated;
        long currentTime = SystemUtil.currentTimeMillis();
        long timeElapsed = currentTime - lastUpdatedInMillis;
        return timeElapsed > this.maxAllowedStalenessInMillis;
    }

    private void addToStaleTracker(String key) {
        this.timeStamps.put(key, SystemUtil.currentTimeMillis());
    }

    private CountrySpecificLotlFetcher.Result getCountrySpecificLotl(String country) {
        CountrySpecificLotlFetcher.Result result = this.countrySpecificLotlCache.get(country);
        if (this.isObjectStale(result.createUniqueIdentifier())) {
            this.strategy.onCountryFailure(result);
        }
        return result;
    }

    private void setSpecificCountryInternally(CountrySpecificLotlFetcher.Result countrySpecificLotlCache) {
        if (this.countrySpecificLotlCache == null) {
            this.countrySpecificLotlCache = new HashMap<String, CountrySpecificLotlFetcher.Result>();
        }
        String cacheId = countrySpecificLotlCache.createUniqueIdentifier();
        this.countrySpecificLotlCache.put(cacheId, countrySpecificLotlCache);
        this.addToStaleTracker(cacheId);
    }
}

