/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.signatures.validation.lotl.IServiceContext;
import com.itextpdf.signatures.validation.lotl.ServiceChronologicalInfo;
import java.security.cert.Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class CountryServiceContext
implements IServiceContext {
    private final List<Certificate> certificates = new ArrayList<Certificate>();
    private final List<ServiceChronologicalInfo> serviceChronologicalInfos = new ArrayList<ServiceChronologicalInfo>();
    private String serviceType;

    CountryServiceContext() {
    }

    @Override
    public List<Certificate> getCertificates() {
        return new ArrayList<Certificate>(this.certificates);
    }

    @Override
    public void addCertificate(Certificate certificate) {
        this.certificates.add(certificate);
    }

    public List<ServiceChronologicalInfo> getServiceChronologicalInfos() {
        return this.serviceChronologicalInfos;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public ServiceChronologicalInfo getServiceChronologicalInfoByDate(long milliseconds) {
        return this.getServiceChronologicalInfoByDate(DateTimeUtil.getTimeFromMillis((long)milliseconds));
    }

    public ServiceChronologicalInfo getServiceChronologicalInfoByDate(LocalDateTime time) {
        for (ServiceChronologicalInfo serviceChronologicalInfo : this.serviceChronologicalInfos) {
            if (time.isBefore(serviceChronologicalInfo.getServiceStatusStartingTime())) continue;
            return serviceChronologicalInfo;
        }
        return null;
    }

    public ServiceChronologicalInfo getCurrentChronologicalInfo() {
        return this.serviceChronologicalInfos.get(0);
    }

    void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    void addServiceChronologicalInfo(ServiceChronologicalInfo serviceChronologicalInfo) {
        this.serviceChronologicalInfos.add(serviceChronologicalInfo);
    }

    int getServiceChronologicalInfosSize() {
        return this.serviceChronologicalInfos.size();
    }
}

