/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.extensions;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.validation.extensions.DynamicCertificateExtension;
import java.security.cert.X509Certificate;

public class DynamicBasicConstraintsExtension
extends DynamicCertificateExtension {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    public static final String ERROR_MESSAGE = "Expected extension 2.5.29.19 to have a value of at least {0} but found {1}";
    private String errorMessage;

    public DynamicBasicConstraintsExtension() {
        super("2.5.29.19", FACTORY.createBasicConstraints(true).toASN1Primitive());
    }

    @Override
    public boolean existsInCertificate(X509Certificate certificate) {
        if (certificate.getBasicConstraints() >= this.getCertificateChainSize() - 1) {
            return true;
        }
        this.errorMessage = MessageFormatUtil.format((String)ERROR_MESSAGE, (Object[])new Object[]{this.getCertificateChainSize() - 1, certificate.getBasicConstraints()});
        return false;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }
}

