/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.eutrustedlistsresources.EuropeanTrustedListConfiguration;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.CertificateUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

class EuropeanTrustedCertificatesResourceLoader {
    private final EuropeanTrustedListConfiguration configuration;

    EuropeanTrustedCertificatesResourceLoader(EuropeanTrustedListConfiguration config) {
        this.configuration = config;
    }

    static void verifyCertificate(String hashB64Encoded, Certificate certificate) throws CertificateException, NoSuchAlgorithmException {
        if (hashB64Encoded == null) {
            throw new PdfException("Hash was null.");
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] certHash = digest.digest(certificate.getEncoded());
        if (!MessageDigest.isEqual(certHash, Base64.getDecoder().decode(hashB64Encoded))) {
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                throw new PdfException(MessageFormatUtil.format((String)"Certificate {0} hash mismatch.", (Object[])new Object[]{x509Certificate.getIssuerX500Principal().getName()}));
            }
            throw new PdfException(MessageFormatUtil.format((String)"Certificate {0} hash mismatch.", (Object[])new Object[]{hashB64Encoded}));
        }
    }

    public List<Certificate> loadCertificates() {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        for (EuropeanTrustedListConfiguration.PemCertificateWithHash pemContainer : this.configuration.getCertificates()) {
            Certificate certificate = CertificateUtil.readCertificatesFromPem(new ByteArrayInputStream(pemContainer.getPemCertificate().getBytes(StandardCharsets.UTF_8)))[0];
            result.add(certificate);
            try {
                EuropeanTrustedCertificatesResourceLoader.verifyCertificate(pemContainer.getHash(), certificate);
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

