/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class DocumentRevisionPdfObjectComparator {
    private DocumentRevisionPdfObjectComparator() {
    }

    public static boolean isSameReference(PdfIndirectReference indirectReference1, PdfIndirectReference indirectReference2) {
        if (indirectReference1 == null || indirectReference2 == null) {
            return false;
        }
        return indirectReference1.getObjNumber() == indirectReference2.getObjNumber() && indirectReference1.getGenNumber() == indirectReference2.getGenNumber();
    }

    public static boolean comparePdfObjects(PdfObject pdfObject1, PdfObject pdfObject2, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        return DocumentRevisionPdfObjectComparator.comparePdfObjects(pdfObject1, pdfObject2, new ArrayList<Tuple2<PdfObject, PdfObject>>(), usuallyModifiedObjects);
    }

    public static boolean isMaxGenerationObject(PdfIndirectReference indirectReference) {
        return indirectReference.getObjNumber() == 0 && indirectReference.getGenNumber() == 65535;
    }

    public static boolean comparePdfDictionaries(PdfDictionary dictionary1, PdfDictionary dictionary2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        Set entrySet1 = dictionary1.entrySet();
        Set entrySet2 = dictionary2.entrySet();
        if (entrySet1.size() != entrySet2.size()) {
            return false;
        }
        for (Map.Entry entry1 : entrySet1) {
            if (entrySet2.stream().anyMatch(entry2 -> ((PdfName)entry2.getKey()).equals(entry1.getKey()) && DocumentRevisionPdfObjectComparator.comparePdfObjects((PdfObject)entry2.getValue(), (PdfObject)entry1.getValue(), visitedObjects, usuallyModifiedObjects))) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePdfObjects(PdfObject pdfObject1, PdfObject pdfObject2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        for (Tuple2<PdfObject, PdfObject> pair : visitedObjects) {
            if (pair.getFirst() != pdfObject1) continue;
            return pair.getSecond() == pdfObject2;
        }
        visitedObjects.add((Tuple2<PdfObject, PdfObject>)new Tuple2((Object)pdfObject1, (Object)pdfObject2));
        if (Objects.equals(pdfObject1, pdfObject2)) {
            return true;
        }
        if (pdfObject1 == null || pdfObject2 == null) {
            return false;
        }
        if (pdfObject1.getClass() != pdfObject2.getClass()) {
            return false;
        }
        if (pdfObject1.getIndirectReference() != null && ((Set)usuallyModifiedObjects.getFirst()).stream().anyMatch(reference -> DocumentRevisionPdfObjectComparator.isSameReference(reference, pdfObject1.getIndirectReference())) && pdfObject2.getIndirectReference() != null && ((Set)usuallyModifiedObjects.getSecond()).stream().anyMatch(reference -> DocumentRevisionPdfObjectComparator.isSameReference(reference, pdfObject2.getIndirectReference()))) {
            return DocumentRevisionPdfObjectComparator.isSameReference(pdfObject1.getIndirectReference(), pdfObject2.getIndirectReference());
        }
        if (pdfObject1.getIndirectReference() == null ^ pdfObject2.getIndirectReference() == null) {
            return false;
        }
        switch (pdfObject1.getType()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                return pdfObject1.equals(pdfObject2);
            }
            case 5: {
                return DocumentRevisionPdfObjectComparator.comparePdfObjects(((PdfIndirectReference)pdfObject1).getRefersTo(), ((PdfIndirectReference)pdfObject2).getRefersTo(), visitedObjects, usuallyModifiedObjects);
            }
            case 1: {
                return DocumentRevisionPdfObjectComparator.comparePdfArrays((PdfArray)pdfObject1, (PdfArray)pdfObject2, visitedObjects, usuallyModifiedObjects);
            }
            case 3: {
                return DocumentRevisionPdfObjectComparator.comparePdfDictionaries((PdfDictionary)pdfObject1, (PdfDictionary)pdfObject2, visitedObjects, usuallyModifiedObjects);
            }
            case 9: {
                return DocumentRevisionPdfObjectComparator.comparePdfStreams((PdfStream)pdfObject1, (PdfStream)pdfObject2, visitedObjects, usuallyModifiedObjects);
            }
        }
        return false;
    }

    private static boolean comparePdfArrays(PdfArray array1, PdfArray array2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        if (array1.size() != array2.size()) {
            return false;
        }
        for (int i = 0; i < array1.size(); ++i) {
            if (DocumentRevisionPdfObjectComparator.comparePdfObjects(array1.get(i), array2.get(i), visitedObjects, usuallyModifiedObjects)) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePdfStreams(PdfStream stream1, PdfStream stream2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        return Arrays.equals(stream1.getBytes(false), stream2.getBytes(false)) && DocumentRevisionPdfObjectComparator.comparePdfDictionaries((PdfDictionary)stream1, (PdfDictionary)stream2, visitedObjects, usuallyModifiedObjects);
    }
}

