/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2025 Apryse Group NV
    Authors: Apryse Software.

    This program is offered under a commercial and under the AGPL license.
    For commercial licensing, contact us at https://itextpdf.com/sales.  For AGPL licensing, see below.

    AGPL licensing:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.itextpdf.signatures.validation.lotl;

class XmlTagConstants {
    static final String X509CERTIFICATE = "X509Certificate";
    static final String TSP_SERVICE = "TSPService";
    static final String SCHEME_INFORMATION_URI = "SchemeInformationURI";
    static final String SERVICE_TYPE = "ServiceTypeIdentifier";
    static final String SERVICE_STATUS = "ServiceStatus";
    static final String SERVICE_STATUS_STARTING_TIME = "StatusStartingTime";
    static final String SERVICE_INFORMATION = "ServiceInformation";
    static final String SERVICE_HISTORY_INSTANCE = "ServiceHistoryInstance";
    static final String OTHER_TSL_POINTER = "OtherTSLPointer";
    static final String SCHEME_TERRITORY = "SchemeTerritory";
    static final String TSL_LOCATION = "TSLLocation";
    static final String MIME_TYPE = "MimeType";
    static final String ADDITIONAL_INFORMATION_EXTENSION = "AdditionalServiceInformation";
    static final String URI = "URI";
    static final String URI_ATTRIBUTE = "uri";
    static final String QUALIFIER = "Qualifier";
    static final String QUALIFICATION_ELEMENT = "QualificationElement";
    static final String CRITERIA_LIST = "CriteriaList";
    static final String ASSERT = "assert";
    static final String CERT_SUBJECT_DN_ATTRIBUTE = "CertSubjectDNAttribute";
    static final String POLICY_SET = "PolicySet";
    static final String IDENTIFIER = "Identifier";
    static final String KEY_PURPOSE_ID = "KeyPurposeId";
    static final String EXTENDED_KEY_USAGE = "ExtendedKeyUsage";
    static final String KEY_USAGE = "KeyUsage";
    static final String KEY_USAGE_BIT = "KeyUsageBit";
    static final String NAME = "name";
}