/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.splitting;

import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.layout.splitting.ISplitCharacters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultSplitCharacters
implements ISplitCharacters {
    private static final Set<Integer> CHARS_NOT_STARTING_LINE = new HashSet<Integer>(Arrays.asList(8217, 8221, 41, 12309, 93, 125, 12297, 12299, 12301, 12303, 12305, 10630, 12313, 12311, 187, 12319, 8208, 12316, 12448, 8211, 33, 63, 8252, 8263, 8264, 8265, 12539, 58, 59, 12290, 46, 12289, 44, 12541, 12542, 12445, 12446, 12293, 12347, 12540, 12353, 12355, 12357, 12359, 12361, 12449, 12451, 12453, 12455, 12457, 12387, 12419, 12421, 12423, 12430, 12437, 12438, 12483, 12515, 12517, 12519, 12526, 12533, 12534, 12784, 12785, 12786, 12787, 12788, 12789, 12790, 12791, 12792, 12793, 12794, 12795, 12796, 12797, 12798, 12799, 41, 12309, 93));
    private static final Set<Integer> CHARS_NOT_ENDING_LINE = new HashSet<Integer>(Arrays.asList(8216, 8220, 40, 12308, 91, 123, 12296, 12298, 12300, 12302, 12304, 10629, 12312, 12310, 171, 12317));
    private static final Map<Integer, Integer> CHARS_INSEPARABLE = new HashMap<Integer, Integer>();

    @Override
    public boolean isSplitCharacter(GlyphLine text, int glyphPos) {
        if (!text.get(glyphPos).hasValidUnicode()) {
            return false;
        }
        int charCode = text.get(glyphPos).getUnicode();
        if (text.size() - 1 > glyphPos) {
            if (glyphPos == 0 && charCode == 45 && DefaultSplitCharacters.isDigitChar(text, glyphPos + 1)) {
                return false;
            }
            int nextCharCode = text.get(glyphPos + 1).getUnicode();
            if (CHARS_NOT_STARTING_LINE.contains(nextCharCode)) {
                return false;
            }
            Integer secondInseparable = CHARS_INSEPARABLE.get(charCode);
            if (secondInseparable != null && secondInseparable == nextCharCode) {
                return false;
            }
        }
        if (CHARS_NOT_ENDING_LINE.contains(charCode)) {
            return false;
        }
        return charCode <= 32 || charCode == 45 || charCode == 8208 || charCode >= 8194 && charCode <= 8203 || charCode >= 11904 && charCode < 55200 || charCode >= 63744 && charCode < 64256 || charCode >= 65072 && charCode < 65104 || charCode >= 65377 && charCode < 65440;
    }

    private static boolean isDigitChar(GlyphLine text, int glyphPos) {
        return Character.isDigit(text.get(glyphPos).getChars()[0]);
    }

    static {
        CHARS_INSEPARABLE.put(8211, 8211);
        CHARS_INSEPARABLE.put(8230, 8230);
        CHARS_INSEPARABLE.put(8229, 8229);
        CHARS_INSEPARABLE.put(12339, 12341);
        CHARS_INSEPARABLE.put(12340, 12341);
    }
}

