/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.HashMap;
import java.util.Map;

public class TargetCounterHandler {
    private Map<String, Integer> renderersPages = new HashMap<String, Integer>();
    private Map<String, Integer> previousRenderersPages = new HashMap<String, Integer>();

    public TargetCounterHandler(TargetCounterHandler targetCounterHandler) {
        this.renderersPages = targetCounterHandler.renderersPages;
        this.previousRenderersPages = targetCounterHandler.previousRenderersPages;
    }

    public TargetCounterHandler() {
    }

    public static void addPageByID(IRenderer renderer) {
        TargetCounterHandler targetCounterHandler;
        String id = (String)renderer.getProperty(126);
        if (id != null && (targetCounterHandler = TargetCounterHandler.getTargetCounterHandler(renderer)) != null && renderer.getOccupiedArea() != null) {
            int currentPageNumber = renderer.getOccupiedArea().getPageNumber();
            targetCounterHandler.renderersPages.put(id, currentPageNumber);
        }
    }

    public static Integer getPageByID(IRenderer renderer, String id) {
        TargetCounterHandler targetCounterHandler = TargetCounterHandler.getTargetCounterHandler(renderer);
        return targetCounterHandler == null ? null : targetCounterHandler.previousRenderersPages.get(id);
    }

    public static boolean isValueDefinedForThisId(IRenderer renderer, String id) {
        TargetCounterHandler targetCounterHandler = TargetCounterHandler.getTargetCounterHandler(renderer);
        return targetCounterHandler != null && targetCounterHandler.renderersPages.containsKey(id);
    }

    public boolean isRelayoutRequired() {
        for (Map.Entry<String, Integer> rendererPage : this.renderersPages.entrySet()) {
            if (rendererPage.getValue().equals(this.previousRenderersPages.get(rendererPage.getKey()))) continue;
            return true;
        }
        return false;
    }

    public void prepareHandlerToRelayout() {
        this.previousRenderersPages = new HashMap<String, Integer>(this.renderersPages);
    }

    private static TargetCounterHandler getTargetCounterHandler(IRenderer renderer) {
        IRenderer rootRenderer = renderer;
        while (rootRenderer.getParent() != null) {
            rootRenderer = rootRenderer.getParent();
        }
        if (rootRenderer instanceof DocumentRenderer) {
            return ((DocumentRenderer)rootRenderer).getTargetCounterHandler();
        }
        return null;
    }
}

