/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.io.font.FontProgramDescriptor;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FontSelector {
    protected List<FontInfo> fonts;
    private static final int EXPECTED_FONT_IS_BOLD_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_BOLD_AWARD = 3;
    private static final int EXPECTED_FONT_WEIGHT_IS_EQUALS_AWARD = 1;
    private static final int EXPECTED_FONT_WEIGHT_IS_FAR_AWARD = 1;
    private static final int EXPECTED_FONT_IS_ITALIC_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_ITALIC_AWARD = 3;
    private static final int EXPECTED_FONT_IS_MONOSPACED_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_MONOSPACED_AWARD = 1;
    private static final int FONT_FAMILY_EQUALS_AWARD = 13;

    public FontSelector(Collection<FontInfo> allFonts, List<String> fontFamilies, FontCharacteristics fc) {
        this.fonts = new ArrayList<FontInfo>(allFonts);
        Collections.sort(this.fonts, this.getComparator(fontFamilies, fc));
    }

    public final FontInfo bestMatch() {
        return this.fonts.get(0);
    }

    public final Iterable<FontInfo> getFonts() {
        return this.fonts;
    }

    protected Comparator<FontInfo> getComparator(List<String> fontFamilies, FontCharacteristics fc) {
        return new PdfFontComparator(fontFamilies, fc);
    }

    private static class PdfFontComparator
    implements Comparator<FontInfo> {
        List<String> fontFamilies = new ArrayList<String>();
        List<FontCharacteristics> fontStyles = new ArrayList<FontCharacteristics>();

        PdfFontComparator(List<String> fontFamilies, FontCharacteristics fc) {
            if (fontFamilies != null && fontFamilies.size() > 0) {
                for (String fontFamily : fontFamilies) {
                    String lowercaseFontFamily = StringNormalizer.toLowerCase((String)fontFamily);
                    this.fontFamilies.add(lowercaseFontFamily);
                    this.fontStyles.add(PdfFontComparator.parseFontStyle(lowercaseFontFamily, fc));
                }
            } else {
                this.fontStyles.add(fc);
            }
        }

        @Override
        public int compare(FontInfo o1, FontInfo o2) {
            int res = 0;
            for (int i = 0; i < this.fontFamilies.size() && res == 0; ++i) {
                boolean isLastFontFamilyToBeProcessed;
                FontCharacteristics fc = this.fontStyles.get(i);
                String fontFamily = this.fontFamilies.get(i);
                if ("monospace".equalsIgnoreCase(fontFamily)) {
                    fc.setMonospaceFlag(true);
                }
                if ((res = PdfFontComparator.characteristicsSimilarity(fontFamily, fc, o2, isLastFontFamilyToBeProcessed = i == this.fontFamilies.size() - 1) - PdfFontComparator.characteristicsSimilarity(fontFamily, fc, o1, isLastFontFamilyToBeProcessed)) != 0) continue;
                res = PdfFontComparator.family2Similarity(fontFamily, fc, o2) - PdfFontComparator.family2Similarity(fontFamily, fc, o1);
            }
            return res;
        }

        private static FontCharacteristics parseFontStyle(String fontFamily, FontCharacteristics fc) {
            if (fc == null) {
                fc = new FontCharacteristics();
            }
            if (fc.isUndefined()) {
                if (fontFamily.contains("bold")) {
                    fc.setBoldFlag(true);
                }
                if (fontFamily.contains("italic") || fontFamily.contains("oblique")) {
                    fc.setItalicFlag(true);
                }
            }
            return fc;
        }

        private static int characteristicsSimilarity(String fontFamily, FontCharacteristics fc, FontInfo fontInfo, boolean isLastFontFamilyToBeProcessed) {
            int minWeight;
            int maxWeight;
            FontProgramDescriptor fontDescriptor = fontInfo.getDescriptor();
            boolean isFontBold = fontDescriptor.isBold() || fontDescriptor.getFontWeight() > 500;
            boolean isFontItalic = fontDescriptor.isItalic() || fontDescriptor.getItalicAngle() < 0.0f;
            boolean isFontMonospace = fontDescriptor.isMonospace();
            int score = 0;
            boolean fontFamilySetByCharacteristics = false;
            if (fc.isMonospace()) {
                fontFamilySetByCharacteristics = true;
                score = isFontMonospace ? (score += 5) : (score -= 5);
            } else if (isFontMonospace) {
                --score;
            }
            if (!fontFamilySetByCharacteristics) {
                if (!"".equals(fontFamily) && (null == fontInfo.getAlias() && null != fontDescriptor.getFamilyNameLowerCase() && fontDescriptor.getFamilyNameLowerCase().equals(fontFamily) || null != fontInfo.getAlias() && StringNormalizer.toLowerCase((String)fontInfo.getAlias()).equals(fontFamily))) {
                    score += 13;
                } else if (!isLastFontFamilyToBeProcessed) {
                    return score;
                }
            }
            if ((maxWeight = Math.max(fontDescriptor.getFontWeight(), fc.getFontWeight())) == (minWeight = Math.min(fontDescriptor.getFontWeight(), fc.getFontWeight()))) {
                ++score;
            } else if (maxWeight - minWeight >= 300) {
                --score;
            }
            if (fc.isBold()) {
                score = isFontBold ? (score += 5) : (score -= 5);
            } else if (isFontBold) {
                score -= 3;
            }
            if (fc.isItalic()) {
                score = isFontItalic ? (score += 5) : (score -= 5);
            } else if (isFontItalic) {
                score -= 3;
            }
            return score;
        }

        private static int family2Similarity(String fontFamily, FontCharacteristics fc, FontInfo fontInfo) {
            FontProgramDescriptor fontDescriptor = fontInfo.getDescriptor();
            if (!fc.isMonospace() && null == fontInfo.getAlias() && null != fontDescriptor.getFamilyName2LowerCase() && fontDescriptor.getFamilyName2LowerCase().equals(fontFamily)) {
                return 1;
            }
            return 0;
        }
    }
}

