/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.xmp.impl;

import com.itextpdf.kernel.xmp.XMPConst;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.impl.ParameterAsserts;
import com.itextpdf.kernel.xmp.impl.Utils;
import com.itextpdf.kernel.xmp.impl.XMPMetaImpl;
import com.itextpdf.kernel.xmp.impl.XMPNode;
import com.itextpdf.kernel.xmp.impl.XMPNodeUtils;
import com.itextpdf.kernel.xmp.impl.xpath.XMPPath;
import com.itextpdf.kernel.xmp.impl.xpath.XMPPathParser;
import com.itextpdf.kernel.xmp.options.PropertyOptions;
import com.itextpdf.kernel.xmp.properties.XMPAliasInfo;
import java.util.Iterator;

public final class XMPUtilsImpl
implements XMPConst {
    private static final int UCK_NORMAL = 0;
    private static final int UCK_SPACE = 1;
    private static final int UCK_COMMA = 2;
    private static final int UCK_SEMICOLON = 3;
    private static final int UCK_QUOTE = 4;
    private static final int UCK_CONTROL = 5;
    private static final String SPACES = " \u3000\u303f";
    private static final String COMMAS = ",\uff0c\uff64\ufe50\ufe51\u3001\u060c\u055d";
    private static final String SEMICOLA = ";\uff1b\ufe54\u061b\u037e";
    private static final String QUOTES = "\"\u00ab\u00bb\u301d\u301e\u301f\u2015\u2039\u203a";
    private static final String CONTROLS = "\u2028\u2029";

    private XMPUtilsImpl() {
    }

    public static int eofReadBytesValue() {
        return -1;
    }

    public static String catenateArrayItems(XMPMeta xmp, String schemaNS, String arrayName, String separator, String quotes, boolean allowCommas) throws XMPException {
        ParameterAsserts.assertSchemaNS(schemaNS);
        ParameterAsserts.assertArrayName(arrayName);
        ParameterAsserts.assertImplementation(xmp);
        if (separator == null || separator.length() == 0) {
            separator = "; ";
        }
        if (quotes == null || quotes.length() == 0) {
            quotes = "\"";
        }
        XMPMetaImpl xmpImpl = (XMPMetaImpl)xmp;
        XMPNode arrayNode = null;
        XMPNode currItem = null;
        XMPPath arrayPath = XMPPathParser.expandXPath(schemaNS, arrayName);
        arrayNode = XMPNodeUtils.findNode(xmpImpl.getRoot(), arrayPath, false, null);
        if (arrayNode == null) {
            return "";
        }
        if (!arrayNode.getOptions().isArray() || arrayNode.getOptions().isArrayAlternate()) {
            throw new XMPException("Named property must be non-alternate array", 4);
        }
        XMPUtilsImpl.checkSeparator(separator);
        char openQuote = quotes.charAt(0);
        char closeQuote = XMPUtilsImpl.checkQuotes(quotes, openQuote);
        StringBuffer catinatedString = new StringBuffer();
        Iterator it = arrayNode.iterateChildren();
        while (it.hasNext()) {
            currItem = (XMPNode)it.next();
            if (currItem.getOptions().isCompositeProperty()) {
                throw new XMPException("Array items must be simple", 4);
            }
            String str = XMPUtilsImpl.applyQuotes(currItem.getValue(), openQuote, closeQuote, allowCommas);
            catinatedString.append(str);
            if (!it.hasNext()) continue;
            catinatedString.append(separator);
        }
        return catinatedString.toString();
    }

    public static void separateArrayItems(XMPMeta xmp, String schemaNS, String arrayName, String catedStr, PropertyOptions arrayOptions, boolean preserveCommas) throws XMPException {
        ParameterAsserts.assertSchemaNS(schemaNS);
        ParameterAsserts.assertArrayName(arrayName);
        if (catedStr == null) {
            throw new XMPException("Parameter must not be null", 4);
        }
        ParameterAsserts.assertImplementation(xmp);
        XMPMetaImpl xmpImpl = (XMPMetaImpl)xmp;
        XMPNode arrayNode = XMPUtilsImpl.separateFindCreateArray(schemaNS, arrayName, arrayOptions, xmpImpl);
        int nextKind = 0;
        int charKind = 0;
        char ch = '\u0000';
        int itemEnd = 0;
        int endPos = catedStr.length();
        while (itemEnd < endPos) {
            String itemValue;
            int itemStart;
            for (itemStart = itemEnd; itemStart < endPos && (charKind = XMPUtilsImpl.classifyCharacter(ch = catedStr.charAt(itemStart))) != 0 && charKind != 4; ++itemStart) {
            }
            if (itemStart >= endPos) break;
            if (charKind != 4) {
                for (itemEnd = itemStart; itemEnd < endPos && ((charKind = XMPUtilsImpl.classifyCharacter(ch = catedStr.charAt(itemEnd))) == 0 || charKind == 4 || charKind == 2 && preserveCommas || charKind == 1 && itemEnd + 1 < endPos && ((nextKind = XMPUtilsImpl.classifyCharacter(ch = catedStr.charAt(itemEnd + 1))) == 0 || nextKind == 4 || nextKind == 2 && preserveCommas)); ++itemEnd) {
                }
                itemValue = catedStr.substring(itemStart, itemEnd);
            } else {
                char openQuote = ch;
                char closeQuote = XMPUtilsImpl.getClosingQuote(openQuote);
                itemValue = "";
                for (itemEnd = ++itemStart; itemEnd < endPos; ++itemEnd) {
                    char nextChar;
                    ch = catedStr.charAt(itemEnd);
                    charKind = XMPUtilsImpl.classifyCharacter(ch);
                    if (charKind != 4 || !XMPUtilsImpl.isSurroundingQuote(ch, openQuote, closeQuote)) {
                        itemValue = itemValue + ch;
                        continue;
                    }
                    if (itemEnd + 1 < endPos) {
                        nextChar = catedStr.charAt(itemEnd + 1);
                        nextKind = XMPUtilsImpl.classifyCharacter(nextChar);
                    } else {
                        nextKind = 3;
                        nextChar = ';';
                    }
                    if (ch == nextChar) {
                        itemValue = itemValue + ch;
                        ++itemEnd;
                        continue;
                    }
                    if (!XMPUtilsImpl.isClosingingQuote(ch, openQuote, closeQuote)) {
                        itemValue = itemValue + ch;
                        continue;
                    }
                    ++itemEnd;
                    break;
                }
            }
            int foundIndex = -1;
            for (int oldChild = 1; oldChild <= arrayNode.getChildrenLength(); ++oldChild) {
                if (!itemValue.equals(arrayNode.getChild(oldChild).getValue())) continue;
                foundIndex = oldChild;
                break;
            }
            XMPNode newItem = null;
            if (foundIndex >= 0) continue;
            newItem = new XMPNode("[]", itemValue, null);
            arrayNode.addChild(newItem);
        }
    }

    private static XMPNode separateFindCreateArray(String schemaNS, String arrayName, PropertyOptions arrayOptions, XMPMetaImpl xmp) throws XMPException {
        if (!(arrayOptions = XMPNodeUtils.verifySetOptions(arrayOptions, null)).isOnlyArrayOptions()) {
            throw new XMPException("Options can only provide array form", 103);
        }
        XMPPath arrayPath = XMPPathParser.expandXPath(schemaNS, arrayName);
        XMPNode arrayNode = XMPNodeUtils.findNode(xmp.getRoot(), arrayPath, false, null);
        if (arrayNode != null) {
            PropertyOptions arrayForm = arrayNode.getOptions();
            if (!arrayForm.isArray() || arrayForm.isArrayAlternate()) {
                throw new XMPException("Named property must be non-alternate array", 102);
            }
            if (arrayOptions.equalArrayTypes(arrayForm)) {
                throw new XMPException("Mismatch of specified and existing array form", 102);
            }
        } else {
            arrayNode = XMPNodeUtils.findNode(xmp.getRoot(), arrayPath, true, arrayOptions.setArray(true));
            if (arrayNode == null) {
                throw new XMPException("Failed to create named array", 102);
            }
        }
        return arrayNode;
    }

    public static void removeProperties(XMPMeta xmp, String schemaNS, String propName, boolean doAllProperties, boolean includeAliases) throws XMPException {
        block5: {
            XMPMetaImpl xmpImpl;
            block6: {
                block4: {
                    ParameterAsserts.assertImplementation(xmp);
                    xmpImpl = (XMPMetaImpl)xmp;
                    if (propName == null || propName.length() <= 0) break block4;
                    if (schemaNS == null || schemaNS.length() == 0) {
                        throw new XMPException("Property name requires schema namespace", 4);
                    }
                    XMPPath expPath = XMPPathParser.expandXPath(schemaNS, propName);
                    XMPNode propNode = XMPNodeUtils.findNode(xmpImpl.getRoot(), expPath, false, null);
                    if (propNode == null || !doAllProperties && Utils.isInternalProperty(expPath.getSegment(0).getName(), expPath.getSegment(1).getName())) break block5;
                    XMPNode parent = propNode.getParent();
                    parent.removeChild(propNode);
                    if (!parent.getOptions().isSchemaNode() || parent.hasChildren()) break block5;
                    parent.getParent().removeChild(parent);
                    break block5;
                }
                if (schemaNS == null || schemaNS.length() <= 0) break block6;
                XMPNode schemaNode = XMPNodeUtils.findSchemaNode(xmpImpl.getRoot(), schemaNS, false);
                if (schemaNode != null && XMPUtilsImpl.removeSchemaChildren(schemaNode, doAllProperties)) {
                    xmpImpl.getRoot().removeChild(schemaNode);
                }
                if (!includeAliases) break block5;
                XMPAliasInfo[] aliases = XMPMetaFactory.getSchemaRegistry().findAliases(schemaNS);
                for (int i = 0; i < aliases.length; ++i) {
                    XMPAliasInfo info = aliases[i];
                    XMPPath path = XMPPathParser.expandXPath(info.getNamespace(), info.getPropName());
                    XMPNode actualProp = XMPNodeUtils.findNode(xmpImpl.getRoot(), path, false, null);
                    if (actualProp == null) continue;
                    XMPNode parent = actualProp.getParent();
                    parent.removeChild(actualProp);
                }
                break block5;
            }
            Iterator it = xmpImpl.getRoot().iterateChildren();
            while (it.hasNext()) {
                XMPNode schema = (XMPNode)it.next();
                if (!XMPUtilsImpl.removeSchemaChildren(schema, doAllProperties)) continue;
                it.remove();
            }
        }
    }

    public static void appendProperties(XMPMeta source, XMPMeta destination, boolean doAllProperties, boolean replaceOldValues, boolean deleteEmptyValues) throws XMPException {
        ParameterAsserts.assertImplementation(source);
        ParameterAsserts.assertImplementation(destination);
        XMPMetaImpl src = (XMPMetaImpl)source;
        XMPMetaImpl dest = (XMPMetaImpl)destination;
        Iterator it = src.getRoot().iterateChildren();
        while (it.hasNext()) {
            XMPNode sourceSchema = (XMPNode)it.next();
            XMPNode destSchema = XMPNodeUtils.findSchemaNode(dest.getRoot(), sourceSchema.getName(), false);
            boolean createdSchema = false;
            if (destSchema == null) {
                destSchema = new XMPNode(sourceSchema.getName(), sourceSchema.getValue(), new PropertyOptions().setSchemaNode(true));
                dest.getRoot().addChild(destSchema);
                createdSchema = true;
            }
            Iterator ic = sourceSchema.iterateChildren();
            while (ic.hasNext()) {
                XMPNode sourceProp = (XMPNode)ic.next();
                if (!doAllProperties && Utils.isInternalProperty(sourceSchema.getName(), sourceProp.getName())) continue;
                XMPUtilsImpl.appendSubtree(dest, sourceProp, destSchema, replaceOldValues, deleteEmptyValues);
            }
            if (destSchema.hasChildren() || !createdSchema && !deleteEmptyValues) continue;
            dest.getRoot().removeChild(destSchema);
        }
    }

    private static boolean removeSchemaChildren(XMPNode schemaNode, boolean doAllProperties) {
        Iterator it = schemaNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode currProp = (XMPNode)it.next();
            if (!doAllProperties && Utils.isInternalProperty(schemaNode.getName(), currProp.getName())) continue;
            it.remove();
        }
        return !schemaNode.hasChildren();
    }

    private static void appendSubtree(XMPMetaImpl destXMP, XMPNode sourceNode, XMPNode destParent, boolean replaceOldValues, boolean deleteEmptyValues) throws XMPException {
        block18: {
            XMPNode destNode;
            block17: {
                destNode = XMPNodeUtils.findChildNode(destParent, sourceNode.getName(), false);
                boolean valueIsEmpty = false;
                if (deleteEmptyValues) {
                    boolean bl = sourceNode.getOptions().isSimple() ? sourceNode.getValue() == null || sourceNode.getValue().length() == 0 : (valueIsEmpty = !sourceNode.hasChildren());
                }
                if (!deleteEmptyValues || !valueIsEmpty) break block17;
                if (destNode == null) break block18;
                destParent.removeChild(destNode);
                break block18;
            }
            if (destNode == null) {
                destParent.addChild((XMPNode)sourceNode.clone());
            } else if (replaceOldValues) {
                destXMP.setNode(destNode, sourceNode.getValue(), sourceNode.getOptions(), true);
                destParent.removeChild(destNode);
                destNode = (XMPNode)sourceNode.clone();
                destParent.addChild(destNode);
            } else {
                PropertyOptions destForm;
                PropertyOptions sourceForm = sourceNode.getOptions();
                if (sourceForm != (destForm = destNode.getOptions())) {
                    return;
                }
                if (sourceForm.isStruct()) {
                    Iterator it = sourceNode.iterateChildren();
                    while (it.hasNext()) {
                        XMPNode sourceField = (XMPNode)it.next();
                        XMPUtilsImpl.appendSubtree(destXMP, sourceField, destNode, replaceOldValues, deleteEmptyValues);
                        if (!deleteEmptyValues || destNode.hasChildren()) continue;
                        destParent.removeChild(destNode);
                    }
                } else if (sourceForm.isArrayAltText()) {
                    Iterator it = sourceNode.iterateChildren();
                    while (it.hasNext()) {
                        XMPNode sourceItem = (XMPNode)it.next();
                        if (!sourceItem.hasQualifier() || !"xml:lang".equals(sourceItem.getQualifier(1).getName())) continue;
                        int destIndex = XMPNodeUtils.lookupLanguageItem(destNode, sourceItem.getQualifier(1).getValue());
                        if (deleteEmptyValues && (sourceItem.getValue() == null || sourceItem.getValue().length() == 0)) {
                            if (destIndex == -1) continue;
                            destNode.removeChild(destIndex);
                            if (destNode.hasChildren()) continue;
                            destParent.removeChild(destNode);
                            continue;
                        }
                        if (destIndex != -1) continue;
                        if (!"x-default".equals(sourceItem.getQualifier(1).getValue()) || !destNode.hasChildren()) {
                            sourceItem.cloneSubtree(destNode);
                            continue;
                        }
                        XMPNode destItem = new XMPNode(sourceItem.getName(), sourceItem.getValue(), sourceItem.getOptions());
                        sourceItem.cloneSubtree(destItem);
                        destNode.addChild(1, destItem);
                    }
                } else if (sourceForm.isArray()) {
                    Iterator is = sourceNode.iterateChildren();
                    while (is.hasNext()) {
                        XMPNode sourceItem = (XMPNode)is.next();
                        boolean match = false;
                        Iterator id = destNode.iterateChildren();
                        while (id.hasNext()) {
                            XMPNode destItem = (XMPNode)id.next();
                            if (!XMPUtilsImpl.itemValuesMatch(sourceItem, destItem)) continue;
                            match = true;
                        }
                        if (match) continue;
                        destNode = (XMPNode)sourceItem.clone();
                        destParent.addChild(destNode);
                    }
                }
            }
        }
    }

    private static boolean itemValuesMatch(XMPNode leftNode, XMPNode rightNode) throws XMPException {
        PropertyOptions rightForm;
        PropertyOptions leftForm = leftNode.getOptions();
        if (leftForm.equals(rightForm = rightNode.getOptions())) {
            return false;
        }
        if (leftForm.getOptions() == 0) {
            if (!leftNode.getValue().equals(rightNode.getValue())) {
                return false;
            }
            if (leftNode.getOptions().getHasLanguage() != rightNode.getOptions().getHasLanguage()) {
                return false;
            }
            if (leftNode.getOptions().getHasLanguage() && !leftNode.getQualifier(1).getValue().equals(rightNode.getQualifier(1).getValue())) {
                return false;
            }
        } else if (leftForm.isStruct()) {
            if (leftNode.getChildrenLength() != rightNode.getChildrenLength()) {
                return false;
            }
            Iterator it = leftNode.iterateChildren();
            while (it.hasNext()) {
                XMPNode leftField = (XMPNode)it.next();
                XMPNode rightField = XMPNodeUtils.findChildNode(rightNode, leftField.getName(), false);
                if (rightField != null && XMPUtilsImpl.itemValuesMatch(leftField, rightField)) continue;
                return false;
            }
        } else {
            assert (leftForm.isArray());
            Iterator il = leftNode.iterateChildren();
            while (il.hasNext()) {
                XMPNode leftItem = (XMPNode)il.next();
                boolean match = false;
                Iterator ir = rightNode.iterateChildren();
                while (ir.hasNext()) {
                    XMPNode rightItem = (XMPNode)ir.next();
                    if (!XMPUtilsImpl.itemValuesMatch(leftItem, rightItem)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    private static void checkSeparator(String separator) throws XMPException {
        boolean haveSemicolon = false;
        for (int i = 0; i < separator.length(); ++i) {
            int charKind = XMPUtilsImpl.classifyCharacter(separator.charAt(i));
            if (charKind == 3) {
                if (haveSemicolon) {
                    throw new XMPException("Separator can have only one semicolon", 4);
                }
                haveSemicolon = true;
                continue;
            }
            if (charKind == 1) continue;
            throw new XMPException("Separator can have only spaces and one semicolon", 4);
        }
        if (!haveSemicolon) {
            throw new XMPException("Separator must have one semicolon", 4);
        }
    }

    private static char checkQuotes(String quotes, char openQuote) throws XMPException {
        char closeQuote;
        int charKind = XMPUtilsImpl.classifyCharacter(openQuote);
        if (charKind != 4) {
            throw new XMPException("Invalid quoting character", 4);
        }
        if (quotes.length() == 1) {
            closeQuote = openQuote;
        } else {
            closeQuote = quotes.charAt(1);
            charKind = XMPUtilsImpl.classifyCharacter(closeQuote);
            if (charKind != 4) {
                throw new XMPException("Invalid quoting character", 4);
            }
        }
        if (closeQuote != XMPUtilsImpl.getClosingQuote(openQuote)) {
            throw new XMPException("Mismatched quote pair", 4);
        }
        return closeQuote;
    }

    private static int classifyCharacter(char ch) {
        if (SPACES.indexOf(ch) >= 0 || '\u2000' <= ch && ch <= '\u200b') {
            return 1;
        }
        if (COMMAS.indexOf(ch) >= 0) {
            return 2;
        }
        if (SEMICOLA.indexOf(ch) >= 0) {
            return 3;
        }
        if (QUOTES.indexOf(ch) >= 0 || '\u3008' <= ch && ch <= '\u300f' || '\u2018' <= ch && ch <= '\u201f') {
            return 4;
        }
        if (ch < ' ' || CONTROLS.indexOf(ch) >= 0) {
            return 5;
        }
        return 0;
    }

    private static char getClosingQuote(char openQuote) {
        switch (openQuote) {
            case '\"': {
                return '\"';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u00bb': {
                return '\u00ab';
            }
            case '\u2015': {
                return '\u2015';
            }
            case '\u2018': {
                return '\u2019';
            }
            case '\u201a': {
                return '\u201b';
            }
            case '\u201c': {
                return '\u201d';
            }
            case '\u201e': {
                return '\u201f';
            }
            case '\u2039': {
                return '\u203a';
            }
            case '\u203a': {
                return '\u2039';
            }
            case '\u3008': {
                return '\u3009';
            }
            case '\u300a': {
                return '\u300b';
            }
            case '\u300c': {
                return '\u300d';
            }
            case '\u300e': {
                return '\u300f';
            }
            case '\u301d': {
                return '\u301f';
            }
        }
        return '\u0000';
    }

    private static String applyQuotes(String item, char openQuote, char closeQuote, boolean allowCommas) {
        int i;
        if (item == null) {
            item = "";
        }
        boolean prevSpace = false;
        for (i = 0; i < item.length(); ++i) {
            char ch = item.charAt(i);
            int charKind = XMPUtilsImpl.classifyCharacter(ch);
            if (i == 0 && charKind == 4) break;
            if (charKind == 1) {
                if (prevSpace) break;
                prevSpace = true;
                continue;
            }
            prevSpace = false;
            if (charKind == 3 || charKind == 5 || charKind == 2 && !allowCommas) break;
        }
        if (i < item.length()) {
            int splitPoint;
            StringBuffer newItem = new StringBuffer(item.length() + 2);
            for (splitPoint = 0; splitPoint <= i && XMPUtilsImpl.classifyCharacter(item.charAt(i)) != 4; ++splitPoint) {
            }
            newItem.append(openQuote).append(item.substring(0, splitPoint));
            for (int charOffset = splitPoint; charOffset < item.length(); ++charOffset) {
                newItem.append(item.charAt(charOffset));
                if (XMPUtilsImpl.classifyCharacter(item.charAt(charOffset)) != 4 || !XMPUtilsImpl.isSurroundingQuote(item.charAt(charOffset), openQuote, closeQuote)) continue;
                newItem.append(item.charAt(charOffset));
            }
            newItem.append(closeQuote);
            item = newItem.toString();
        }
        return item;
    }

    private static boolean isSurroundingQuote(char ch, char openQuote, char closeQuote) {
        return ch == openQuote || XMPUtilsImpl.isClosingingQuote(ch, openQuote, closeQuote);
    }

    private static boolean isClosingingQuote(char ch, char openQuote, char closeQuote) {
        return ch == closeQuote || openQuote == '\u301d' && ch == '\u301e' || ch == '\u301f';
    }
}

