/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils.checkers;

import java.util.regex.Pattern;

public final class BCP47Validator {
    private static final String REGULAR = "(art-lojban|cel-gaulish|no-bok|no-nyn|zh-guoyu|zh-hakka|zh-min|zh-min-nan|zh-xiang)";
    private static final String IRREGULAR = "(en-GB-oed|i-ami|i-bnn|i-default|i-enochian|i-hak|i-klingon|i-lux|i-mingo|i-navajo|i-pwn|i-tao|i-tay|i-tsu|sgn-BE-FR|sgn-BE-NL|sgn-CH-DE)";
    private static final String GRANDFATHERED = "(?<grandfathered>(en-GB-oed|i-ami|i-bnn|i-default|i-enochian|i-hak|i-klingon|i-lux|i-mingo|i-navajo|i-pwn|i-tao|i-tay|i-tsu|sgn-BE-FR|sgn-BE-NL|sgn-CH-DE)|(art-lojban|cel-gaulish|no-bok|no-nyn|zh-guoyu|zh-hakka|zh-min|zh-min-nan|zh-xiang))";
    private static final String PRIVATE_USE = "(?<privateUse>x(-[A-Za-z0-9]{1,8})+)";
    private static final String SINGLETON = "[0-9A-WY-Za-wy-z]";
    private static final String EXTENSION = "(?<extension>[0-9A-WY-Za-wy-z](-[A-Za-z0-9]{2,8})+)";
    private static final String VARIANT = "(?<variant>[A-Za-z0-9]{5,8}|[0-9][A-Za-z0-9]{3})";
    private static final String REGION = "(?<region>[A-Za-z]{2}|[0-9]{3})";
    private static final String SCRIPT = "(?<script>[A-Za-z]{4})";
    private static final String EXTLANG = "(?<extlang>[A-Za-z]{3}(-[A-Za-z]{3}){0,2})";
    private static final String LANGUAGE = "(?<language>([A-Za-z]{2,3}(-(?<extlang>[A-Za-z]{3}(-[A-Za-z]{3}){0,2}))?)|[A-Za-z]{4}|[A-Za-z]{5,8})";
    private static final String LANGTAG = "((?<language>([A-Za-z]{2,3}(-(?<extlang>[A-Za-z]{3}(-[A-Za-z]{3}){0,2}))?)|[A-Za-z]{4}|[A-Za-z]{5,8})(-(?<script>[A-Za-z]{4}))?(-(?<region>[A-Za-z]{2}|[0-9]{3}))?(-(?<variant>[A-Za-z0-9]{5,8}|[0-9][A-Za-z0-9]{3}))*(-(?<extension>[0-9A-WY-Za-wy-z](-[A-Za-z0-9]{2,8})+))*(-(?<privateUse>x(-[A-Za-z0-9]{1,8})+))?)";
    private static final Pattern LANGUAGE_TAG_PATTERN = Pattern.compile("^((?<grandfathered>(en-GB-oed|i-ami|i-bnn|i-default|i-enochian|i-hak|i-klingon|i-lux|i-mingo|i-navajo|i-pwn|i-tao|i-tay|i-tsu|sgn-BE-FR|sgn-BE-NL|sgn-CH-DE)|(art-lojban|cel-gaulish|no-bok|no-nyn|zh-guoyu|zh-hakka|zh-min|zh-min-nan|zh-xiang))|((?<language>([A-Za-z]{2,3}(-(?<extlang>[A-Za-z]{3}(-[A-Za-z]{3}){0,2}))?)|[A-Za-z]{4}|[A-Za-z]{5,8})(-(?<script>[A-Za-z]{4}))?(-(?<region>[A-Za-z]{2}|[0-9]{3}))?(-(?<variant>[A-Za-z0-9]{5,8}|[0-9][A-Za-z0-9]{3}))*(-(?<extension>[0-9A-WY-Za-wy-z](-[A-Za-z0-9]{2,8})+))*(-(?<privateUse>x(-[A-Za-z0-9]{1,8})+))?)|" + "(?<privateUse>x(-[A-Za-z0-9]{1,8})+)".replace("privateUse", "privateUse1") + ")$");

    private BCP47Validator() {
    }

    public static boolean validate(String languageTag) {
        return LANGUAGE_TAG_PATTERN.matcher(languageTag).matches();
    }
}

