/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.crypto.modes.IGCMBlockCipher;
import com.itextpdf.kernel.exceptions.PdfException;
import java.security.GeneralSecurityException;

public class AESGCMCipher {
    public static final int MAC_SIZE_BITS = 128;
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final IGCMBlockCipher cipher;

    public AESGCMCipher(boolean forEncryption, byte[] key, byte[] iv) {
        try {
            this.cipher = BOUNCY_CASTLE_FACTORY.createGCMBlockCipher();
            this.cipher.init(forEncryption, key, 128, iv);
        }
        catch (GeneralSecurityException e) {
            throw new PdfException("Exception initializing AES cipher.", e);
        }
    }

    public byte[] update(byte[] b, int off, int len) {
        byte[] cipherBuffer = new byte[this.cipher.getUpdateOutputSize(len)];
        try {
            this.cipher.processBytes(b, off, len, cipherBuffer, 0);
        }
        catch (GeneralSecurityException e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
        return cipherBuffer;
    }

    public byte[] doFinal() {
        byte[] cipherBuffer = new byte[this.cipher.getOutputSize(0)];
        try {
            this.cipher.doFinal(cipherBuffer, 0);
            return cipherBuffer;
        }
        catch (IllegalArgumentException | GeneralSecurityException e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
    }
}

