/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.CjkResourceLoader;
import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapContentParser;
import com.itextpdf.io.font.cmap.CMapLocationFromBytes;
import com.itextpdf.io.font.cmap.CMapLocationResource;
import com.itextpdf.io.font.cmap.CMapParser;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.cmap.CMapUniCid;
import com.itextpdf.io.font.cmap.ICMapLocation;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.io.source.HighPrecisionOutputStream;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtil {
    private static final SecureRandom NUMBER_GENERATOR = new SecureRandom();
    private static final HashMap<String, CMapToUnicode> uniMaps = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(FontUtil.class);
    private static final String UNIVERSAL_CMAP_DIR = "toUnicode/";
    private static final Set<String> UNIVERSAL_CMAP_ORDERINGS = new HashSet<String>(Arrays.asList("CNS1", "GB1", "Japan1", "Korea1", "KR"));

    private FontUtil() {
    }

    public static String addRandomSubsetPrefixForFontName(String fontName) {
        StringBuilder newFontName = FontUtil.getRandomFontPrefix(6);
        newFontName.append('+').append(fontName);
        return newFontName.toString();
    }

    public static CMapToUnicode processToUnicode(PdfObject toUnicode) {
        CMapToUnicode cMapToUnicode = null;
        if (toUnicode instanceof PdfStream) {
            try {
                byte[] uniBytes = ((PdfStream)toUnicode).getBytes();
                CMapLocationFromBytes lb = new CMapLocationFromBytes(uniBytes);
                cMapToUnicode = new CMapToUnicode();
                CMapParser.parseCid((String)"", (AbstractCMap)cMapToUnicode, (ICMapLocation)lb);
            }
            catch (Exception e) {
                LOGGER.error("Unknown error while processing CMap.", (Throwable)e);
                cMapToUnicode = CMapToUnicode.EMPTY_CMAP;
            }
        } else if (PdfName.IdentityH.equals(toUnicode)) {
            cMapToUnicode = CMapToUnicode.getIdentity();
        }
        return cMapToUnicode;
    }

    public static IntHashtable convertCompositeWidthsArray(PdfArray widthsArray) {
        IntHashtable res = new IntHashtable();
        if (widthsArray == null) {
            return res;
        }
        for (int k = 0; k < widthsArray.size(); ++k) {
            PdfObject obj;
            int c1 = widthsArray.getAsNumber(k).intValue();
            if ((obj = widthsArray.get(++k)).isArray()) {
                PdfArray subWidths = (PdfArray)obj;
                for (int j = 0; j < subWidths.size(); ++j) {
                    int c2 = subWidths.getAsNumber(j).intValue();
                    res.put(c1++, c2);
                }
                continue;
            }
            int c2 = ((PdfNumber)obj).intValue();
            int w = widthsArray.getAsNumber(++k).intValue();
            while (c1 <= c2) {
                res.put(c1, w);
                ++c1;
            }
        }
        return res;
    }

    public static PdfStream getToUnicodeStream(Set<Glyph> glyphs) {
        HighPrecisionOutputStream stream = new HighPrecisionOutputStream((OutputStream)new ByteArrayOutputStream());
        stream.writeString("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><FFFF>\nendcodespacerange\n");
        ArrayList<Glyph> glyphGroup = new ArrayList<Glyph>(100);
        int bfranges = 0;
        for (Glyph glyph : glyphs) {
            if (glyph.getChars() == null) continue;
            glyphGroup.add(glyph);
            if (glyphGroup.size() != 100) continue;
            bfranges += FontUtil.writeBfrange((HighPrecisionOutputStream<ByteArrayOutputStream>)stream, glyphGroup);
        }
        if ((bfranges += FontUtil.writeBfrange((HighPrecisionOutputStream<ByteArrayOutputStream>)stream, glyphGroup)) == 0) {
            return null;
        }
        stream.writeString("endcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        return new PdfStream(((ByteArrayOutputStream)stream.getOutputStream()).toByteArray());
    }

    private static int writeBfrange(HighPrecisionOutputStream<ByteArrayOutputStream> stream, List<Glyph> range) {
        if (range.isEmpty()) {
            return 0;
        }
        stream.writeInteger(range.size());
        stream.writeString(" beginbfrange\n");
        for (Glyph glyph : range) {
            String fromTo = CMapContentParser.toHex((int)glyph.getCode());
            stream.writeString(fromTo);
            stream.writeString(fromTo);
            stream.writeByte(60);
            for (char ch : glyph.getChars()) {
                stream.writeString(FontUtil.toHex4(ch));
            }
            stream.writeByte(62);
            stream.writeByte(10);
        }
        stream.writeString("endbfrange\n");
        range.clear();
        return 1;
    }

    private static String toHex4(char ch) {
        String s = "0000" + Integer.toHexString(ch);
        return s.substring(s.length() - 4);
    }

    static CMapToUnicode parseUniversalToUnicodeCMap(String ordering) {
        if (!UNIVERSAL_CMAP_ORDERINGS.contains(ordering)) {
            return null;
        }
        String cmapRelPath = "toUnicode/Adobe-" + ordering + "-UCS2";
        CMapToUnicode cMapToUnicode = new CMapToUnicode();
        try {
            CMapParser.parseCid((String)cmapRelPath, (AbstractCMap)cMapToUnicode, (ICMapLocation)new CMapLocationResource());
        }
        catch (Exception e) {
            LOGGER.error("Unknown error while processing CMap.", (Throwable)e);
            return null;
        }
        return cMapToUnicode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CMapToUnicode getToUnicodeFromUniMap(String uniMap) {
        if (uniMap == null) {
            return null;
        }
        HashMap<String, CMapToUnicode> hashMap = uniMaps;
        synchronized (hashMap) {
            CMapToUnicode toUnicode;
            if (uniMaps.containsKey(uniMap)) {
                return uniMaps.get(uniMap);
            }
            if ("Identity-H".equals(uniMap)) {
                toUnicode = CMapToUnicode.getIdentity();
            } else {
                CMapUniCid uni = CjkResourceLoader.getUni2CidCmap((String)uniMap);
                toUnicode = uni.exportToUnicode();
            }
            uniMaps.put(uniMap, toUnicode);
            return toUnicode;
        }
    }

    static String createRandomFontName() {
        return FontUtil.getRandomFontPrefix(7).toString();
    }

    static int[] convertSimpleWidthsArray(PdfArray widthsArray, int first, int missingWidth) {
        int[] res = new int[256];
        Arrays.fill(res, missingWidth);
        if (widthsArray == null) {
            Logger logger = LoggerFactory.getLogger(FontUtil.class);
            logger.warn("Font dictionary does not contain required /Widths entry.");
            return res;
        }
        for (int i = 0; i < widthsArray.size() && first + i < 256; ++i) {
            PdfNumber number = widthsArray.getAsNumber(i);
            res[first + i] = number != null ? number.intValue() : missingWidth;
        }
        return res;
    }

    private static StringBuilder getRandomFontPrefix(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] randomByte = new byte[length];
        NUMBER_GENERATOR.nextBytes(randomByte);
        for (int k = 0; k < length; ++k) {
            stringBuilder.append((char)(Math.abs(randomByte[k] % 26) + 65));
        }
        return stringBuilder;
    }
}

