/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.function;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.function.AbstractPdfFunction;

public class PdfType2Function
extends AbstractPdfFunction<PdfDictionary> {
    private double[] c0;
    private double[] c1;
    private double n;

    public PdfType2Function(PdfDictionary dict) {
        super(dict);
        PdfNumber nObj = dict.getAsNumber(PdfName.N);
        if (nObj == null) {
            throw new PdfException("Invalid PDF Type 2 Function object, \"N\" field should exist and must be a number.");
        }
        this.n = nObj.doubleValue();
        if (super.getDomain().length < 2) {
            throw new PdfException("Invalid PDF Type 2 Function object, \"Domain\" array shall consist of 2 numbers.");
        }
        if (this.n != Math.floor(this.n) && super.getDomain()[0] < 0.0) {
            throw new PdfException("Invalid PDF Type 2 Function object, when \"N\" is not an integer, values of \"Domain\" shall define the input value as non-negative.");
        }
        if (this.n < 0.0 && super.clipInput(new double[]{0.0})[0] == 0.0) {
            throw new PdfException("Invalid PDF Type 2 Function object, when \"N\" is negative, values of \"Domain\" shall not allow zero as input value.");
        }
        PdfArray c0Obj = dict.getAsArray(PdfName.C0);
        PdfArray c1Obj = dict.getAsArray(PdfName.C1);
        PdfArray rangeObj = dict.getAsArray(PdfName.Range);
        this.c0 = PdfType2Function.initializeCArray(c0Obj, c1Obj, rangeObj, 0.0);
        this.c1 = PdfType2Function.initializeCArray(c1Obj, c0Obj, rangeObj, 1.0);
        if (this.c0.length != this.c1.length || super.getRange() != null && this.c0.length != super.getRange().length / 2) {
            throw new PdfException("Invalid PDF Type 2 Function object, if present the size of \"C0\", \"C1\" and half \"Range\" shall be equal.");
        }
    }

    public PdfType2Function(double[] domain, double[] range, double[] c0, double[] c1, double n) {
        super(new PdfDictionary(), 2, domain, range);
        this.setC0(c0);
        this.setC1(c1);
        this.setN(n);
    }

    public PdfType2Function(float[] domain, float[] range, float[] c0, float[] c1, double n) {
        this(PdfType2Function.convertFloatArrayToDoubleArray(domain), PdfType2Function.convertFloatArrayToDoubleArray(range), PdfType2Function.convertFloatArrayToDoubleArray(c0), PdfType2Function.convertFloatArrayToDoubleArray(c1), n);
    }

    @Override
    public double[] calculate(double[] input) {
        if (input == null || input.length != 1) {
            throw new PdfException("Invalid input value for PDF Type 2 Function, value should be a single number.");
        }
        double[] clipped = this.clipInput(input);
        double x = clipped[0];
        int outputSize = this.getOutputSize();
        double[] output = new double[outputSize];
        for (int i = 0; i < outputSize; ++i) {
            output[i] = this.c0[i] + Math.pow(x, this.n) * (this.c1[i] - this.c0[i]);
        }
        return this.clipOutput(output);
    }

    @Override
    public final int getOutputSize() {
        return this.getRange() == null ? this.c0.length : this.getRange().length / 2;
    }

    public final double[] getC0() {
        return this.c0;
    }

    public final void setC0(double[] value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.C0, new PdfArray(value));
        this.c0 = value;
    }

    public final double[] getC1() {
        return this.c1;
    }

    public final void setC1(double[] value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.C1, new PdfArray(value));
        this.c1 = value;
    }

    public final double getN() {
        return this.n;
    }

    public final void setN(double value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.N, new PdfNumber(value));
        this.n = value;
    }

    private static double[] initializeCArray(PdfArray c, PdfArray otherC, PdfArray range, double defaultValue) {
        if (c != null) {
            return c.toDoubleArray();
        }
        double[] result = otherC == null ? (range == null ? new double[1] : new double[range.size() / 2]) : new double[otherC.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = defaultValue;
        }
        return result;
    }
}

