/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.exceptions.MemoryLimitsAwareException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLimitsAwareHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryLimitsAwareHandler.class);
    private static final int SINGLE_SCALE_COEFFICIENT = 100;
    private static final int SUM_SCALE_COEFFICIENT = 500;
    private static final int MAX_NUMBER_OF_ELEMENTS_IN_XREF_STRUCTURE = 50000000;
    private static final int MIN_LIMIT_FOR_NUMBER_OF_ELEMENTS_IN_XREF_STRUCTURE = 500000;
    private static final int SINGLE_DECOMPRESSED_PDF_STREAM_MIN_SIZE = 21474836;
    private static final long SUM_OF_DECOMPRESSED_PDF_STREAMS_MIN_SIZE = 0x6666666L;
    private static final long MAX_X_OBJECTS_SIZE_PER_PAGE = 0xC0000000L;
    private int maxSizeOfSingleDecompressedPdfStream;
    private long maxSizeOfDecompressedPdfStreamsSum;
    private int maxNumberOfElementsInXrefStructure;
    private long maxXObjectsSizePerPage;
    private long allMemoryUsedForDecompression = 0L;
    private long memoryUsedForCurrentPdfStreamDecompression = 0L;
    boolean considerCurrentPdfStream = false;

    public MemoryLimitsAwareHandler() {
        this(21474836, 0x6666666L, 50000000, 0xC0000000L);
    }

    public MemoryLimitsAwareHandler(long documentSize) {
        this((int)MemoryLimitsAwareHandler.calculateDefaultParameter(documentSize, 100, 21474836L), MemoryLimitsAwareHandler.calculateDefaultParameter(documentSize, 500, 0x6666666L), MemoryLimitsAwareHandler.calculateMaxElementsInXref(documentSize), 0xC0000000L);
    }

    private MemoryLimitsAwareHandler(int maxSizeOfSingleDecompressedPdfStream, long maxSizeOfDecompressedPdfStreamsSum, int maxNumberOfElementsInXrefStructure, long maxXObjectsSizePerPage) {
        this.maxSizeOfSingleDecompressedPdfStream = maxSizeOfSingleDecompressedPdfStream;
        this.maxSizeOfDecompressedPdfStreamsSum = maxSizeOfDecompressedPdfStreamsSum;
        this.maxNumberOfElementsInXrefStructure = maxNumberOfElementsInXrefStructure;
        this.maxXObjectsSizePerPage = maxXObjectsSizePerPage;
    }

    public MemoryLimitsAwareHandler createNewInstance() {
        MemoryLimitsAwareHandler to = new MemoryLimitsAwareHandler();
        to.maxSizeOfSingleDecompressedPdfStream = this.maxSizeOfSingleDecompressedPdfStream;
        to.maxSizeOfDecompressedPdfStreamsSum = this.maxSizeOfDecompressedPdfStreamsSum;
        to.maxNumberOfElementsInXrefStructure = this.maxNumberOfElementsInXrefStructure;
        to.maxXObjectsSizePerPage = this.maxXObjectsSizePerPage;
        if (this.getClass() != MemoryLimitsAwareHandler.class) {
            LOGGER.warn("MemoryLimitsAwareHandler#createNewInstance method must be overriden.");
        }
        return to;
    }

    public int getMaxSizeOfSingleDecompressedPdfStream() {
        return this.maxSizeOfSingleDecompressedPdfStream;
    }

    public MemoryLimitsAwareHandler setMaxSizeOfSingleDecompressedPdfStream(int maxSizeOfSingleDecompressedPdfStream) {
        this.maxSizeOfSingleDecompressedPdfStream = maxSizeOfSingleDecompressedPdfStream;
        return this;
    }

    public long getMaxSizeOfDecompressedPdfStreamsSum() {
        return this.maxSizeOfDecompressedPdfStreamsSum;
    }

    public MemoryLimitsAwareHandler setMaxSizeOfDecompressedPdfStreamsSum(long maxSizeOfDecompressedPdfStreamsSum) {
        this.maxSizeOfDecompressedPdfStreamsSum = maxSizeOfDecompressedPdfStreamsSum;
        return this;
    }

    public boolean isMemoryLimitsAwarenessRequiredOnDecompression(PdfArray filters) {
        HashSet<PdfName> filterSet = new HashSet<PdfName>();
        for (int index = 0; index < filters.size(); ++index) {
            PdfName filterName = filters.getAsName(index);
            if (filterSet.add(filterName)) continue;
            return true;
        }
        return false;
    }

    public int getMaxNumberOfElementsInXrefStructure() {
        return this.maxNumberOfElementsInXrefStructure;
    }

    public long getMaxXObjectsSizePerPage() {
        return this.maxXObjectsSizePerPage;
    }

    public void setMaxXObjectsSizePerPage(long maxPageSize) {
        this.maxXObjectsSizePerPage = maxPageSize;
    }

    public void setMaxNumberOfElementsInXrefStructure(int maxNumberOfElementsInXrefStructure) {
        this.maxNumberOfElementsInXrefStructure = maxNumberOfElementsInXrefStructure;
    }

    public void checkIfXrefStructureExceedsTheLimit(int requestedCapacity) {
        if (requestedCapacity - 1 > this.maxNumberOfElementsInXrefStructure || requestedCapacity < 0) {
            throw new MemoryLimitsAwareException("Xref structure contains too many elements and may cause OOM exception. You can increase number of elements by setting custom MemoryLimitsAwareHandler.");
        }
    }

    public void checkIfPageSizeExceedsTheLimit(long totalXObjectsSize) {
        if (totalXObjectsSize > this.maxXObjectsSizePerPage) {
            throw new MemoryLimitsAwareException("Pdf contains too many xObject elements on a page and may cause OOM exception. You can increase page size limit by setting custom MemoryLimitsAwareHandler.");
        }
    }

    protected static int calculateMaxElementsInXref(long documentSizeInBytes) {
        int maxDocSizeForMaxLimit = 100;
        int documentSizeInMb = Math.max(1, Math.min((int)documentSizeInBytes / 0x100000, maxDocSizeForMaxLimit));
        return documentSizeInMb * 500000;
    }

    MemoryLimitsAwareHandler considerBytesOccupiedByDecompressedPdfStream(long numOfOccupiedBytes) {
        if (this.considerCurrentPdfStream && this.memoryUsedForCurrentPdfStreamDecompression < numOfOccupiedBytes) {
            this.memoryUsedForCurrentPdfStreamDecompression = numOfOccupiedBytes;
            if (this.memoryUsedForCurrentPdfStreamDecompression > (long)this.maxSizeOfSingleDecompressedPdfStream) {
                throw new MemoryLimitsAwareException("During decompression a single stream occupied more memory than allowed. Please either check your pdf or increase the allowed multiple decompressed pdf streams maximum size value by setting the appropriate parameter of ReaderProperties's MemoryLimitsAwareHandler.");
            }
        }
        return this;
    }

    MemoryLimitsAwareHandler beginDecompressedPdfStreamProcessing() {
        this.ensureCurrentStreamIsReset();
        this.considerCurrentPdfStream = true;
        return this;
    }

    MemoryLimitsAwareHandler endDecompressedPdfStreamProcessing() {
        this.allMemoryUsedForDecompression += this.memoryUsedForCurrentPdfStreamDecompression;
        if (this.allMemoryUsedForDecompression > this.maxSizeOfDecompressedPdfStreamsSum) {
            throw new MemoryLimitsAwareException("During decompression multiple streams in sum occupied more memory than allowed. Please either check your pdf or increase the allowed single decompressed pdf stream maximum size value by setting the appropriate parameter of ReaderProperties's MemoryLimitsAwareHandler.");
        }
        this.ensureCurrentStreamIsReset();
        this.considerCurrentPdfStream = false;
        return this;
    }

    long getAllMemoryUsedForDecompression() {
        return this.allMemoryUsedForDecompression;
    }

    private static long calculateDefaultParameter(long documentSize, int scale, long min) {
        long result = documentSize * (long)scale;
        if (result < min) {
            result = min;
        }
        if (result > min * (long)scale) {
            result = min * (long)scale;
        }
        return result;
    }

    private void ensureCurrentStreamIsReset() {
        this.memoryUsedForCurrentPdfStreamDecompression = 0L;
    }
}

