/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.listener;

import com.itextpdf.kernel.geom.LineSegment;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.canvas.parser.listener.ITextChunkLocation;

class TextChunkLocationDefaultImp
implements ITextChunkLocation {
    private static final float DIACRITICAL_MARKS_ALLOWED_VERTICAL_DEVIATION = 2.0f;
    private final Vector startLocation;
    private final Vector endLocation;
    private final Vector orientationVector;
    private final int orientationMagnitude;
    private final int distPerpendicular;
    private final float distParallelStart;
    private final float distParallelEnd;
    private final float charSpaceWidth;

    public TextChunkLocationDefaultImp(Vector startLocation, Vector endLocation, float charSpaceWidth) {
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.charSpaceWidth = charSpaceWidth;
        Vector oVector = endLocation.subtract(startLocation);
        if (oVector.length() == 0.0f) {
            oVector = new Vector(1.0f, 0.0f, 0.0f);
        }
        this.orientationVector = oVector.normalize();
        this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
        Vector origin = new Vector(0.0f, 0.0f, 1.0f);
        this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
        this.distParallelStart = this.orientationVector.dot(startLocation);
        this.distParallelEnd = this.orientationVector.dot(endLocation);
    }

    @Override
    public int orientationMagnitude() {
        return this.orientationMagnitude;
    }

    @Override
    public int distPerpendicular() {
        return this.distPerpendicular;
    }

    @Override
    public float distParallelStart() {
        return this.distParallelStart;
    }

    @Override
    public float distParallelEnd() {
        return this.distParallelEnd;
    }

    @Override
    public Vector getStartLocation() {
        return this.startLocation;
    }

    @Override
    public Vector getEndLocation() {
        return this.endLocation;
    }

    @Override
    public float getCharSpaceWidth() {
        return this.charSpaceWidth;
    }

    @Override
    public boolean sameLine(ITextChunkLocation as) {
        if (this.orientationMagnitude() != as.orientationMagnitude()) {
            return false;
        }
        float distPerpendicularDiff = this.distPerpendicular() - as.distPerpendicular();
        if (distPerpendicularDiff == 0.0f) {
            return true;
        }
        LineSegment mySegment = new LineSegment(this.startLocation, this.endLocation);
        LineSegment otherSegment = new LineSegment(as.getStartLocation(), as.getEndLocation());
        return Math.abs(distPerpendicularDiff) <= 2.0f && (mySegment.getLength() == 0.0f || otherSegment.getLength() == 0.0f);
    }

    @Override
    public float distanceFromEndOf(ITextChunkLocation other) {
        return this.distParallelStart() - other.distParallelEnd();
    }

    @Override
    public boolean isAtWordBoundary(ITextChunkLocation previous) {
        if (this.startLocation.equals(this.endLocation) || previous.getEndLocation().equals(previous.getStartLocation())) {
            return false;
        }
        float dist = this.distanceFromEndOf(previous);
        if (dist < 0.0f && (dist = previous.distanceFromEndOf(this)) < 0.0f) {
            return false;
        }
        return dist > this.getCharSpaceWidth() / 2.0f;
    }

    static boolean containsMark(ITextChunkLocation baseLocation, ITextChunkLocation markLocation) {
        return baseLocation.getStartLocation().get(0) <= markLocation.getStartLocation().get(0) && baseLocation.getEndLocation().get(0) >= markLocation.getEndLocation().get(0) && (float)Math.abs(baseLocation.distPerpendicular() - markLocation.distPerpendicular()) <= 2.0f;
    }
}

