/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PdfSoundAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -2319779211858842136L;

    public PdfSoundAnnotation(Rectangle rect, PdfStream sound) {
        super(rect);
        this.put(PdfName.Sound, sound);
    }

    protected PdfSoundAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfSoundAnnotation(PdfDocument document, Rectangle rect, InputStream soundStream, float sampleRate, PdfName encoding, int channels, int sampleSizeInBits) throws IOException {
        super(rect);
        PdfStream sound = new PdfStream(document, PdfSoundAnnotation.correctWavFile(soundStream));
        sound.put(PdfName.R, new PdfNumber(sampleRate));
        sound.put(PdfName.E, encoding);
        sound.put(PdfName.B, new PdfNumber(sampleSizeInBits));
        sound.put(PdfName.C, new PdfNumber(channels));
        this.put(PdfName.Sound, sound);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Sound;
    }

    public PdfStream getSound() {
        return ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.Sound);
    }

    private static InputStream correctWavFile(InputStream is) throws IOException {
        String header = "";
        BufferedInputStream bufferedIn = new BufferedInputStream(is);
        ((InputStream)bufferedIn).mark(0);
        for (int i = 0; i < 4; ++i) {
            header = header + (char)((InputStream)bufferedIn).read();
        }
        ((InputStream)bufferedIn).reset();
        if (header.equals("RIFF")) {
            ((InputStream)bufferedIn).read();
        }
        return bufferedIn;
    }

    public PdfName getIconName() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Name);
    }

    public PdfSoundAnnotation setIconName(PdfName name) {
        return (PdfSoundAnnotation)this.put(PdfName.Name, name);
    }
}

