/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.utils.PageRange;
import com.itextpdf.kernel.utils.PdfResourceCounter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PdfSplitter {
    private PdfDocument pdfDocument;
    private boolean preserveTagged;
    private boolean preserveOutlines;

    public PdfSplitter(PdfDocument pdfDocument) {
        if (pdfDocument.getWriter() != null) {
            throw new PdfException("cannot.split.document.that.is.being.written");
        }
        this.pdfDocument = pdfDocument;
        this.preserveTagged = true;
        this.preserveOutlines = true;
    }

    public void setPreserveTagged(boolean preserveTagged) {
        this.preserveTagged = preserveTagged;
    }

    public void setPreserveOutlines(boolean preserveOutlines) {
        this.preserveOutlines = preserveOutlines;
    }

    public List<PdfDocument> splitBySize(long size) {
        ArrayList<PageRange> splitRanges = new ArrayList<PageRange>();
        int currentPage = 1;
        int numOfPages = this.pdfDocument.getNumberOfPages();
        while (currentPage <= numOfPages) {
            PageRange nextRange = this.getNextRange(currentPage, numOfPages, size);
            splitRanges.add(nextRange);
            List<Integer> allPages = nextRange.getAllPages();
            currentPage = allPages.get(allPages.size() - 1) + 1;
        }
        return this.extractPageRanges(splitRanges);
    }

    public void splitByPageNumbers(List<Integer> pageNumbers, IDocumentReadyListener documentReady) {
        int currentPageNumber = 1;
        for (int ind = 0; ind <= pageNumbers.size(); ++ind) {
            int nextPageNumber;
            int n = nextPageNumber = ind == pageNumbers.size() ? this.pdfDocument.getNumberOfPages() + 1 : pageNumbers.get(ind);
            if (ind == 0 && nextPageNumber == 1) continue;
            PageRange currentPageRange = new PageRange().addPageSequence(currentPageNumber, nextPageNumber - 1);
            PdfDocument currentDocument = this.createPdfDocument(currentPageRange);
            this.pdfDocument.copyPagesTo(currentPageNumber, nextPageNumber - 1, currentDocument);
            documentReady.documentReady(currentDocument, currentPageRange);
            currentPageNumber = nextPageNumber;
        }
    }

    public List<PdfDocument> splitByPageNumbers(List<Integer> pageNumbers) {
        final ArrayList<PdfDocument> splitDocuments = new ArrayList<PdfDocument>();
        this.splitByPageNumbers(pageNumbers, new IDocumentReadyListener(){

            @Override
            public void documentReady(PdfDocument pdfDocument, PageRange pageRange) {
                splitDocuments.add(pdfDocument);
            }
        });
        return splitDocuments;
    }

    public void splitByPageCount(int pageCount, IDocumentReadyListener documentReady) {
        for (int startPage = 1; startPage <= this.pdfDocument.getNumberOfPages(); startPage += pageCount) {
            int endPage = Math.min(startPage + pageCount - 1, this.pdfDocument.getNumberOfPages());
            PageRange currentPageRange = new PageRange().addPageSequence(startPage, endPage);
            PdfDocument currentDocument = this.createPdfDocument(currentPageRange);
            this.pdfDocument.copyPagesTo(startPage, endPage, currentDocument);
            documentReady.documentReady(currentDocument, currentPageRange);
        }
    }

    public List<PdfDocument> splitByPageCount(int pageCount) {
        final ArrayList<PdfDocument> splitDocuments = new ArrayList<PdfDocument>();
        this.splitByPageCount(pageCount, new IDocumentReadyListener(){

            @Override
            public void documentReady(PdfDocument pdfDocument, PageRange pageRange) {
                splitDocuments.add(pdfDocument);
            }
        });
        return splitDocuments;
    }

    public List<PdfDocument> extractPageRanges(List<PageRange> pageRanges) {
        ArrayList<PdfDocument> splitDocuments = new ArrayList<PdfDocument>();
        for (PageRange currentPageRange : pageRanges) {
            PdfDocument currentPdfDocument = this.createPdfDocument(currentPageRange);
            splitDocuments.add(currentPdfDocument);
            this.pdfDocument.copyPagesTo(currentPageRange.getAllPages(), currentPdfDocument);
        }
        return splitDocuments;
    }

    public PdfDocument extractPageRange(PageRange pageRange) {
        return this.extractPageRanges(Collections.singletonList(pageRange)).get(0);
    }

    public PdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    protected PdfWriter getNextPdfWriter(PageRange documentPageRange) {
        return new PdfWriter((OutputStream)new ByteArrayOutputStream());
    }

    private PdfDocument createPdfDocument(PageRange currentPageRange) {
        PdfDocument newDocument = new PdfDocument(this.getNextPdfWriter(currentPageRange));
        if (this.pdfDocument.isTagged() && this.preserveTagged) {
            newDocument.setTagged();
        }
        if (this.pdfDocument.hasOutlines() && this.preserveOutlines) {
            newDocument.initializeOutlines();
        }
        return newDocument;
    }

    public List<PdfDocument> splitByOutlines(List<String> outlineTitles) {
        if (outlineTitles == null || outlineTitles.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PdfDocument> documentList = new ArrayList<PdfDocument>(outlineTitles.size());
        for (String title : outlineTitles) {
            PdfDocument document = this.splitByOutline(title);
            if (document == null) continue;
            documentList.add(document);
        }
        return documentList;
    }

    private PdfDocument splitByOutline(String outlineTitle) {
        int startPage = -1;
        int endPage = -1;
        PdfDocument toDocument = this.createPdfDocument(null);
        int size = this.pdfDocument.getNumberOfPages();
        block0: for (int i = 1; i <= size; ++i) {
            PdfPage pdfPage = this.pdfDocument.getPage(i);
            List<PdfOutline> outlineList = pdfPage.getOutlines(false);
            if (outlineList == null) continue;
            for (PdfOutline pdfOutline : outlineList) {
                PdfOutline nextOutLine;
                if (!pdfOutline.getTitle().equals(outlineTitle)) continue;
                startPage = this.pdfDocument.getPageNumber(pdfPage);
                if (startPage - (endPage = (nextOutLine = this.getAbsoluteTreeNextOutline(pdfOutline)) != null ? this.pdfDocument.getPageNumber(this.getPageByOutline(i, nextOutLine)) - 1 : size) != 1) continue block0;
                endPage = startPage;
                continue block0;
            }
        }
        if (startPage == -1 || endPage == -1) {
            return null;
        }
        this.pdfDocument.copyPagesTo(startPage, endPage, toDocument);
        return toDocument;
    }

    private PdfPage getPageByOutline(int fromPage, PdfOutline outline) {
        int size = this.pdfDocument.getNumberOfPages();
        for (int i = fromPage; i <= size; ++i) {
            PdfPage pdfPage = this.pdfDocument.getPage(i);
            List<PdfOutline> outlineList = pdfPage.getOutlines(false);
            if (outlineList == null) continue;
            for (PdfOutline pdfOutline : outlineList) {
                if (!pdfOutline.equals(outline)) continue;
                return pdfPage;
            }
        }
        return null;
    }

    private PdfOutline getAbsoluteTreeNextOutline(PdfOutline outline) {
        PdfObject nextPdfObject = outline.getContent().get(PdfName.Next);
        PdfOutline nextPdfOutline = null;
        if (outline.getParent() != null && nextPdfObject != null) {
            for (PdfOutline pdfOutline : outline.getParent().getAllChildren()) {
                if (!pdfOutline.getContent().getIndirectReference().equals(nextPdfObject.getIndirectReference())) continue;
                nextPdfOutline = pdfOutline;
                break;
            }
        }
        if (nextPdfOutline == null && outline.getParent() != null) {
            nextPdfOutline = this.getAbsoluteTreeNextOutline(outline.getParent());
        }
        return nextPdfOutline;
    }

    private PageRange getNextRange(int startPage, int endPage, long size) {
        PdfResourceCounter counter = new PdfResourceCounter(this.pdfDocument.getTrailer());
        Map<Integer, PdfObject> resources = counter.getResources();
        long lengthWithoutXref = counter.getLength(null);
        int currentPage = startPage;
        boolean oversized = false;
        do {
            PdfPage page = this.pdfDocument.getPage(currentPage++);
            counter = new PdfResourceCounter((PdfObject)page.getPdfObject());
            resources.putAll(counter.getResources());
            if ((lengthWithoutXref += counter.getLength(resources)) + this.xrefLength(resources.size()) <= size) continue;
            oversized = true;
        } while (currentPage <= endPage && !oversized);
        if (oversized && currentPage - 1 != startPage) {
            --currentPage;
        }
        return new PageRange().addPageSequence(startPage, currentPage - 1);
    }

    private long xrefLength(int size) {
        return 20L * (long)(size + 1);
    }

    public static interface IDocumentReadyListener {
        public void documentReady(PdfDocument var1, PageRange var2);
    }
}

