/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.ByteBufferOutputStream;
import com.itextpdf.kernel.pdf.EncryptionProperties;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectStream;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import com.itextpdf.kernel.pdf.WriterProperties;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfWriter
extends PdfOutputStream
implements Serializable {
    private static final long serialVersionUID = -6875544505477707103L;
    private static final byte[] obj = ByteUtils.getIsoBytes((String)" obj\n");
    private static final byte[] endobj = ByteUtils.getIsoBytes((String)"\nendobj\n");
    private HashMap<ByteStore, PdfIndirectReference> streamMap = new HashMap();
    private final HashMap<Integer, Integer> serialized = new HashMap();
    private PdfOutputStream duplicateStream = null;
    protected WriterProperties properties;
    PdfObjectStream objectStream = null;
    protected Map<Integer, PdfIndirectReference> copiedObjects = new HashMap<Integer, PdfIndirectReference>();
    protected boolean isUserWarnedAboutAcroFormCopying;

    public PdfWriter(OutputStream os) {
        this(os, new WriterProperties());
    }

    public PdfWriter(OutputStream os, WriterProperties properties) {
        super(new BufferedOutputStream(os));
        this.properties = properties;
        EncryptionProperties encryptProps = properties.encryptionProperties;
        if (properties.isStandardEncryptionUsed()) {
            this.crypto = new PdfEncryption(encryptProps.userPassword, encryptProps.ownerPassword, encryptProps.standardEncryptPermissions, encryptProps.encryptionAlgorithm, PdfEncryption.generateNewDocumentId());
        } else if (properties.isPublicKeyEncryptionUsed()) {
            this.crypto = new PdfEncryption(encryptProps.publicCertificates, encryptProps.publicKeyEncryptPermissions, encryptProps.encryptionAlgorithm);
        }
        if (properties.debugMode) {
            this.setDebugMode();
        }
    }

    public PdfWriter(String filename) throws FileNotFoundException {
        this(new FileOutputStream(filename), new WriterProperties());
    }

    public PdfWriter(String filename, WriterProperties properties) throws FileNotFoundException {
        this(new FileOutputStream(filename), properties);
    }

    public boolean isFullCompression() {
        return this.properties.isFullCompression != null ? this.properties.isFullCompression : false;
    }

    public int getCompressionLevel() {
        return this.properties.compressionLevel;
    }

    public PdfWriter setCompressionLevel(int compressionLevel) {
        this.properties.setCompressionLevel(compressionLevel);
        return this;
    }

    public PdfWriter setSmartMode(boolean smartMode) {
        this.properties.smartMode = smartMode;
        return this;
    }

    public void write(int b) throws IOException {
        super.write(b);
        if (this.duplicateStream != null) {
            this.duplicateStream.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        super.write(b);
        if (this.duplicateStream != null) {
            this.duplicateStream.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (this.duplicateStream != null) {
            this.duplicateStream.write(b, off, len);
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.duplicateStream != null) {
            this.duplicateStream.close();
        }
    }

    PdfObjectStream getObjectStream() throws IOException {
        if (!this.isFullCompression()) {
            return null;
        }
        if (this.objectStream == null) {
            this.objectStream = new PdfObjectStream(this.document);
        } else if (this.objectStream.getSize() == 200) {
            this.objectStream.flush();
            this.objectStream = new PdfObjectStream(this.objectStream);
        }
        return this.objectStream;
    }

    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) throws IOException {
        PdfIndirectReference indirectReference = pdfObject.getIndirectReference();
        if (this.isFullCompression() && canBeInObjStm) {
            PdfObjectStream objectStream = this.getObjectStream();
            objectStream.addObject(pdfObject);
        } else {
            indirectReference.setOffset(this.getCurrentPos());
            this.writeToBody(pdfObject);
        }
        indirectReference.setState((short)1).clearState((short)32);
        switch (pdfObject.getType()) {
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                ((PdfPrimitiveObject)pdfObject).content = null;
                break;
            }
            case 1: {
                PdfArray array = (PdfArray)pdfObject;
                this.markArrayContentToFlush(array);
                array.releaseContent();
                break;
            }
            case 3: 
            case 9: {
                PdfDictionary dictionary = (PdfDictionary)pdfObject;
                this.markDictionaryContentToFlush(dictionary);
                dictionary.releaseContent();
                break;
            }
            case 5: {
                this.markObjectToFlush(((PdfIndirectReference)pdfObject).getRefersTo(false));
            }
        }
    }

    protected PdfObject copyObject(PdfObject object, PdfDocument document, boolean allowDuplicating) {
        PdfObject copiedObject;
        PdfIndirectReference copiedIndirectReference;
        if (object instanceof PdfIndirectReference) {
            object = ((PdfIndirectReference)object).getRefersTo();
        }
        if (object == null) {
            object = PdfNull.PDF_NULL;
        }
        if (PdfWriter.checkTypeOfPdfDictionary(object, PdfName.Catalog)) {
            Logger logger = LoggerFactory.getLogger(PdfReader.class);
            logger.warn("Make copy of Catalog dictionary is forbidden.");
            object = PdfNull.PDF_NULL;
        }
        PdfIndirectReference indirectReference = object.getIndirectReference();
        int copyObjectKey = 0;
        if (!allowDuplicating && indirectReference != null && (copiedIndirectReference = this.copiedObjects.get(copyObjectKey = this.getCopyObjectKey(object))) != null) {
            return copiedIndirectReference.getRefersTo();
        }
        if (this.properties.smartMode && !PdfWriter.checkTypeOfPdfDictionary(object, PdfName.Page) && (copiedObject = this.smartCopyObject(object)) != null) {
            return this.copiedObjects.get(this.getCopyObjectKey(copiedObject)).getRefersTo();
        }
        PdfObject newObject = object.newInstance();
        if (indirectReference != null) {
            if (copyObjectKey == 0) {
                copyObjectKey = this.getCopyObjectKey(object);
            }
            PdfIndirectReference in = newObject.makeIndirect(document).getIndirectReference();
            this.copiedObjects.put(copyObjectKey, in);
        }
        newObject.copyContent(object, document);
        return newObject;
    }

    protected void writeToBody(PdfObject object) throws IOException {
        if (this.crypto != null) {
            this.crypto.setHashKeyForNextObject(object.getIndirectReference().getObjNumber(), object.getIndirectReference().getGenNumber());
        }
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.writeInteger(object.getIndirectReference().getObjNumber()))).writeSpace())).writeInteger(object.getIndirectReference().getGenNumber()))).writeBytes(obj);
        this.write(object);
        this.writeBytes(endobj);
    }

    protected void writeHeader() {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.writeByte(37))).writeString(this.document.getPdfVersion().toString()))).writeString("\n%\u00e2\u00e3\u00cf\u00d3\n");
    }

    protected void flushWaitingObjects() {
        PdfXrefTable xref = this.document.getXref();
        boolean needFlush = true;
        while (needFlush) {
            needFlush = false;
            for (int i = 1; i < xref.size(); ++i) {
                PdfObject object;
                PdfIndirectReference indirectReference = xref.get(i);
                if (indirectReference == null || !indirectReference.checkState((short)32) || (object = indirectReference.getRefersTo(false)) == null) continue;
                object.flush();
                needFlush = true;
            }
        }
        if (this.objectStream != null && this.objectStream.getSize() > 0) {
            this.objectStream.flush();
            this.objectStream = null;
        }
    }

    protected void flushModifiedWaitingObjects() {
        PdfXrefTable xref = this.document.getXref();
        for (int i = 1; i < xref.size(); ++i) {
            PdfObject object;
            PdfIndirectReference indirectReference = xref.get(i);
            if (null == indirectReference || (object = indirectReference.getRefersTo(false)) == null || object.equals(this.objectStream) || !object.isModified()) continue;
            object.flush();
        }
        if (this.objectStream != null && this.objectStream.getSize() > 0) {
            this.objectStream.flush();
            this.objectStream = null;
        }
    }

    protected int getCopyObjectKey(PdfObject object) {
        PdfIndirectReference in = object.isIndirectReference() ? (PdfIndirectReference)object : object.getIndirectReference();
        int result = in.hashCode();
        result = 31 * result + in.getDocument().hashCode();
        return result;
    }

    private void markArrayContentToFlush(PdfArray array) {
        for (PdfObject item : array) {
            this.markObjectToFlush(item);
        }
    }

    private void markDictionaryContentToFlush(PdfDictionary dictionary) {
        for (PdfObject item : dictionary.values()) {
            this.markObjectToFlush(item);
        }
    }

    private void markObjectToFlush(PdfObject pdfObject) {
        if (pdfObject != null) {
            PdfIndirectReference indirectReference = pdfObject.getIndirectReference();
            if (indirectReference != null) {
                if (!indirectReference.checkState((short)1)) {
                    indirectReference.setState((short)32);
                }
            } else if (pdfObject.getType() == 5) {
                if (!pdfObject.checkState((short)1)) {
                    pdfObject.setState((short)32);
                }
            } else if (pdfObject.getType() == 1) {
                this.markArrayContentToFlush((PdfArray)pdfObject);
            } else if (pdfObject.getType() == 3) {
                this.markDictionaryContentToFlush((PdfDictionary)pdfObject);
            }
        }
    }

    private PdfWriter setDebugMode() {
        this.duplicateStream = new PdfOutputStream((OutputStream)new ByteArrayOutputStream());
        return this;
    }

    private PdfObject smartCopyObject(PdfObject object) {
        if (object.isStream()) {
            ByteStore streamKey = new ByteStore((PdfStream)object, this.serialized);
            PdfIndirectReference streamRef = this.streamMap.get(streamKey);
            if (streamRef != null) {
                return streamRef;
            }
            this.streamMap.put(streamKey, object.getIndirectReference());
        } else if (object.isDictionary()) {
            ByteStore streamKey = new ByteStore((PdfDictionary)object, this.serialized);
            PdfIndirectReference streamRef = this.streamMap.get(streamKey);
            if (streamRef != null) {
                return streamRef.getRefersTo();
            }
            this.streamMap.put(streamKey, object.getIndirectReference());
        }
        return null;
    }

    private byte[] getDebugBytes() throws IOException {
        if (this.duplicateStream != null) {
            this.duplicateStream.flush();
            return ((ByteArrayOutputStream)this.duplicateStream.getOutputStream()).toByteArray();
        }
        return null;
    }

    private static boolean checkTypeOfPdfDictionary(PdfObject dictionary, PdfName expectedType) {
        return dictionary.isDictionary() && expectedType.equals(((PdfDictionary)dictionary).getAsName(PdfName.Type));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.outputStream == null) {
            this.outputStream = new BufferedOutputStream((OutputStream)new ByteArrayOutputStream().assignBytes(this.getDebugBytes()));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.duplicateStream == null) {
            throw new NotSerializableException(this.getClass().getName() + ": debug mode is disabled!");
        }
        OutputStream tempOutputStream = this.outputStream;
        this.outputStream = null;
        out.defaultWriteObject();
        this.outputStream = tempOutputStream;
    }

    static class ByteStore {
        private final byte[] b;
        private final int hash;
        private MessageDigest md5;

        private void serObject(PdfObject obj, int level, ByteBufferOutputStream bb, HashMap<Integer, Integer> serialized) {
            Integer key;
            if (level <= 0) {
                return;
            }
            if (obj == null) {
                bb.append("$Lnull");
                return;
            }
            PdfIndirectReference ref = null;
            ByteBufferOutputStream savedBb = null;
            if (obj.isIndirectReference()) {
                ref = (PdfIndirectReference)obj;
                key = this.getCopyObjectKey(obj);
                if (serialized.containsKey(key)) {
                    bb.append(serialized.get(key));
                    return;
                }
                savedBb = bb;
                bb = new ByteBufferOutputStream();
            }
            if (obj.isStream()) {
                bb.append("$B");
                this.serDic((PdfDictionary)obj, level - 1, bb, serialized);
                if (level > 0) {
                    this.md5.reset();
                    bb.append(this.md5.digest(((PdfStream)obj).getBytes(false)));
                }
            } else if (obj.isDictionary()) {
                this.serDic((PdfDictionary)obj, level - 1, bb, serialized);
            } else if (obj.isArray()) {
                this.serArray((PdfArray)obj, level - 1, bb, serialized);
            } else if (obj.isString()) {
                bb.append("$S").append(obj.toString());
            } else if (obj.isName()) {
                bb.append("$N").append(obj.toString());
            } else {
                bb.append("$L").append(obj.toString());
            }
            if (savedBb != null) {
                key = this.getCopyObjectKey(ref);
                if (!serialized.containsKey(key)) {
                    serialized.put(key, ByteStore.calculateHash(bb.getBuffer()));
                }
                savedBb.append(bb);
            }
        }

        private void serDic(PdfDictionary dic, int level, ByteBufferOutputStream bb, HashMap<Integer, Integer> serialized) {
            bb.append("$D");
            if (level <= 0) {
                return;
            }
            Object[] keys = dic.keySet().toArray();
            Arrays.sort(keys);
            for (Object key : keys) {
                if (key.equals(PdfName.P) && (dic.get((PdfName)key).isIndirectReference() || dic.get((PdfName)key).isDictionary()) || key.equals(PdfName.Parent)) continue;
                this.serObject((PdfObject)key, level, bb, serialized);
                this.serObject(dic.get((PdfName)key, false), level, bb, serialized);
            }
        }

        private void serArray(PdfArray array, int level, ByteBufferOutputStream bb, HashMap<Integer, Integer> serialized) {
            bb.append("$A");
            if (level <= 0) {
                return;
            }
            for (int k = 0; k < array.size(); ++k) {
                this.serObject(array.get(k, false), level, bb, serialized);
            }
        }

        ByteStore(PdfStream str, HashMap<Integer, Integer> serialized) {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                throw new PdfException(e);
            }
            ByteBufferOutputStream bb = new ByteBufferOutputStream();
            int level = 100;
            this.serObject(str, level, bb, serialized);
            this.b = bb.toByteArray();
            this.hash = ByteStore.calculateHash(this.b);
            this.md5 = null;
        }

        ByteStore(PdfDictionary dict, HashMap<Integer, Integer> serialized) {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                throw new PdfException(e);
            }
            ByteBufferOutputStream bb = new ByteBufferOutputStream();
            int level = 100;
            this.serObject(dict, level, bb, serialized);
            this.b = bb.toByteArray();
            this.hash = ByteStore.calculateHash(this.b);
            this.md5 = null;
        }

        private static int calculateHash(byte[] b) {
            int hash = 0;
            int len = b.length;
            for (int k = 0; k < len; ++k) {
                hash = hash * 31 + (b[k] & 0xFF);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof ByteStore && this.hashCode() == obj.hashCode() && Arrays.equals(this.b, ((ByteStore)obj).b);
        }

        public int hashCode() {
            return this.hash;
        }

        protected int getCopyObjectKey(PdfObject object) {
            PdfIndirectReference in = object.isIndirectReference() ? (PdfIndirectReference)object : object.getIndirectReference();
            int result = in.hashCode();
            result = 31 * result + in.getDocument().hashCode();
            return result;
        }
    }
}

