/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.LoggerFactory;

public class PdfStream
extends PdfDictionary {
    private static final long serialVersionUID = -8259929152054328141L;
    protected int compressionLevel;
    private PdfOutputStream outputStream;
    private InputStream inputStream;
    private long offset;
    private int length = -1;

    public PdfStream(byte[] bytes, int compressionLevel) {
        this.setState((short)64);
        this.compressionLevel = compressionLevel;
        if (bytes != null && bytes.length > 0) {
            this.outputStream = new PdfOutputStream((OutputStream)new ByteArrayOutputStream(bytes.length));
            this.outputStream.writeBytes(bytes);
        } else {
            this.outputStream = new PdfOutputStream((OutputStream)new ByteArrayOutputStream());
        }
    }

    public PdfStream(byte[] bytes) {
        this(bytes, Integer.MIN_VALUE);
    }

    public PdfStream(PdfDocument doc, InputStream inputStream, int compressionLevel) {
        if (doc == null) {
            throw new PdfException("cannot.create.pdfstream.by.inputstream.without.pdfdocument");
        }
        this.makeIndirect(doc);
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        this.inputStream = inputStream;
        this.compressionLevel = compressionLevel;
        this.put(PdfName.Length, new PdfNumber(-1).makeIndirect(doc));
    }

    public PdfStream(PdfDocument doc, InputStream inputStream) {
        this(doc, inputStream, Integer.MIN_VALUE);
    }

    public PdfStream(int compressionLevel) {
        this(null, compressionLevel);
    }

    public PdfStream() {
        this((byte[])null);
    }

    PdfStream(long offset, PdfDictionary keys) {
        this.compressionLevel = Integer.MIN_VALUE;
        this.offset = offset;
        this.putAll(keys);
        PdfNumber length = this.getAsNumber(PdfName.Length);
        this.length = length == null ? 0 : length.intValue();
    }

    public PdfOutputStream getOutputStream() {
        return this.outputStream;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public byte getType() {
        return 9;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBytes() {
        return this.getBytes(true);
    }

    public byte[] getBytes(boolean decoded) {
        PdfReader reader;
        if (this.inputStream != null) {
            LoggerFactory.getLogger(PdfStream.class).warn("PdfStream was created by InputStream.getBytes() always returns null in this case");
            return null;
        }
        byte[] bytes = null;
        if (this.outputStream != null && this.outputStream.getOutputStream() != null) {
            assert (this.outputStream.getOutputStream() instanceof ByteArrayOutputStream) : "Invalid OutputStream: ByteArrayByteArrayOutputStream expected";
            try {
                this.outputStream.getOutputStream().flush();
                bytes = ((ByteArrayOutputStream)this.outputStream.getOutputStream()).toByteArray();
            }
            catch (IOException ioe) {
                throw new PdfException("cannot.get.pdfstream.bytes", ioe, this);
            }
        }
        if (this.getIndirectReference() != null && (reader = this.getIndirectReference().getReader()) != null) {
            try {
                bytes = reader.readStreamBytes(this, decoded);
            }
            catch (IOException ioe) {
                throw new PdfException("cannot.get.pdfstream.bytes", ioe, this);
            }
        }
        return bytes;
    }

    public void setData(byte[] bytes) {
        this.setData(bytes, false);
    }

    public void setData(byte[] bytes, boolean append) {
        boolean outputStreamIsUninitialized;
        if (this.inputStream != null) {
            throw new PdfException("cannot.set.data.to.pdfstream.which.was.created.by.inputstream");
        }
        boolean bl = outputStreamIsUninitialized = this.outputStream == null;
        if (outputStreamIsUninitialized) {
            this.outputStream = new PdfOutputStream((OutputStream)new ByteArrayOutputStream());
        }
        if (append) {
            if (outputStreamIsUninitialized && this.getIndirectReference() != null && this.getIndirectReference().getReader() != null) {
                byte[] oldBytes;
                try {
                    oldBytes = this.getBytes();
                }
                catch (PdfException ex) {
                    throw new PdfException("cannot.read.a.stream.in.order.to.append.new.bytes.reason {0}", ex);
                }
                this.offset = 0L;
                this.outputStream.writeBytes(oldBytes);
            }
            if (bytes != null) {
                this.outputStream.writeBytes(bytes);
            }
        } else if (bytes != null) {
            this.outputStream.assignBytes(bytes, bytes.length);
        } else {
            this.outputStream.reset();
        }
        this.remove(PdfName.Filter);
    }

    @Override
    public PdfStream makeIndirect(PdfDocument document) {
        return (PdfStream)super.makeIndirect(document);
    }

    @Override
    public PdfStream makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfStream)super.makeIndirect(document, reference);
    }

    @Override
    public PdfStream copyTo(PdfDocument document) {
        return (PdfStream)super.copyTo(document, true);
    }

    @Override
    public PdfStream copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfStream)super.copyTo(document, allowDuplicating);
    }

    @Override
    protected PdfStream newInstance() {
        return new PdfStream();
    }

    protected long getOffset() {
        return this.offset;
    }

    protected void updateLength(int length) {
        this.length = length;
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfStream stream = (PdfStream)from;
        assert (this.inputStream == null) : "Try to copy the PdfStream that has been just created.";
        byte[] bytes = stream.getBytes(false);
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException ioe) {
            throw new PdfException("cannot.copy.object.content", ioe, stream);
        }
    }

    protected void initOutputStream(OutputStream stream) {
        if (this.getOutputStream() == null && this.inputStream == null) {
            this.outputStream = new PdfOutputStream(stream != null ? stream : new ByteArrayOutputStream());
        }
    }

    @Override
    protected void releaseContent() {
        super.releaseContent();
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (IOException e) {
            throw new PdfException("io.exception", e);
        }
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }
}

