/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.CFFFontSubset;
import com.itextpdf.io.font.CMapEncoding;
import com.itextpdf.io.font.CidFont;
import com.itextpdf.io.font.CidFontProperties;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.cmap.CMapContentParser;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.DocTrueTypeFont;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.IDocFontProgram;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfType0Font
extends PdfFont {
    private static final long serialVersionUID = -8033620300884193397L;
    private static final byte[] rotbits = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    protected static final int CID_FONT_TYPE_0 = 0;
    protected static final int CID_FONT_TYPE_2 = 2;
    protected boolean vertical;
    protected CMapEncoding cmapEncoding;
    protected Map<Integer, int[]> longTag;
    protected int cidFontType;
    protected char[] specificUnicodeDifferences;

    PdfType0Font(TrueTypeFont ttf, String cmap) {
        if (!cmap.equals("Identity-H") && !cmap.equals("Identity-V")) {
            throw new PdfException("only.identity.cmaps.supports.with.truetype");
        }
        if (!ttf.getFontNames().allowEmbedding()) {
            throw new PdfException("1.cannot.be.embedded.due.to.licensing.restrictions").setMessageParams(ttf.getFontNames().getFontName() + ttf.getFontNames().getStyle());
        }
        this.fontProgram = ttf;
        this.embedded = true;
        this.vertical = cmap.endsWith("V");
        this.cmapEncoding = new CMapEncoding(cmap);
        this.longTag = new LinkedHashMap<Integer, int[]>();
        this.cidFontType = 2;
        if (ttf.isFontSpecific()) {
            this.specificUnicodeDifferences = new char[256];
            byte[] bytes = new byte[1];
            for (int k = 0; k < 256; ++k) {
                int ch;
                bytes[0] = (byte)k;
                String s = PdfEncodings.convertToString((byte[])bytes, null);
                this.specificUnicodeDifferences[k] = ch = s.length() > 0 ? (int)s.charAt(0) : 63;
            }
        }
    }

    PdfType0Font(CidFont font, String cmap) {
        if (!CidFontProperties.isCidFont((String)font.getFontNames().getFontName(), (String)cmap)) {
            throw new PdfException("font.1.with.2.encoding.is.not.a.cjk.font").setMessageParams(font.getFontNames().getFontName(), cmap);
        }
        this.fontProgram = font;
        this.vertical = cmap.endsWith("V");
        String uniMap = this.getCompatibleUniMap(this.fontProgram.getRegistry());
        this.cmapEncoding = new CMapEncoding(cmap, uniMap);
        this.longTag = new LinkedHashMap<Integer, int[]>();
        this.cidFontType = 0;
    }

    PdfType0Font(PdfDictionary fontDictionary) {
        super(fontDictionary);
        this.checkFontDictionary(fontDictionary, PdfName.Type0);
        this.newFont = false;
        PdfDictionary cidFont = fontDictionary.getAsArray(PdfName.DescendantFonts).getAsDictionary(0);
        String cmap = fontDictionary.getAsName(PdfName.Encoding).getValue();
        if ("Identity-H".equals(cmap) || "Identity-V".equals(cmap)) {
            String uniMap;
            PdfObject toUnicode = fontDictionary.get(PdfName.ToUnicode);
            CMapToUnicode toUnicodeCMap = FontUtil.processToUnicode(toUnicode);
            if (toUnicodeCMap == null && (toUnicodeCMap = FontUtil.getToUnicodeFromUniMap(uniMap = PdfType0Font.getUniMapFromOrdering(PdfType0Font.getOrdering(cidFont)))) == null) {
                toUnicodeCMap = FontUtil.getToUnicodeFromUniMap("Identity-H");
                Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
                logger.error(MessageFormat.format("Unknown CMap {0}", uniMap));
            }
            this.fontProgram = DocTrueTypeFont.createFontProgram(cidFont, toUnicodeCMap);
            this.cmapEncoding = new CMapEncoding(cmap);
            assert (this.fontProgram instanceof IDocFontProgram);
            this.embedded = ((IDocFontProgram)this.fontProgram).getFontFile() != null;
            this.cidFontType = 2;
        } else {
            String cidFontName = cidFont.getAsName(PdfName.BaseFont).getValue();
            String uniMap = PdfType0Font.getUniMapFromOrdering(PdfType0Font.getOrdering(cidFont));
            if (uniMap != null && uniMap.startsWith("Uni") && CidFontProperties.isCidFont((String)cidFontName, (String)uniMap)) {
                try {
                    this.fontProgram = FontProgramFactory.createFont((String)cidFontName);
                    this.cmapEncoding = new CMapEncoding(cmap, uniMap);
                    this.embedded = false;
                }
                catch (IOException ignored) {
                    this.fontProgram = null;
                    this.cmapEncoding = null;
                }
            } else {
                CMapToUnicode toUnicodeCMap = FontUtil.getToUnicodeFromUniMap(uniMap);
                if (toUnicodeCMap != null) {
                    this.fontProgram = DocTrueTypeFont.createFontProgram(cidFont, toUnicodeCMap);
                    this.cmapEncoding = new CMapEncoding(cmap, uniMap);
                }
            }
            if (this.fontProgram == null) {
                throw new PdfException(MessageFormat.format("Cannot recognise document font {0} with {1} encoding", cidFontName, cmap));
            }
            this.cidFontType = 0;
        }
        this.longTag = new LinkedHashMap<Integer, int[]>();
        this.subset = false;
    }

    private static String getOrdering(PdfDictionary cidFont) {
        PdfDictionary cidinfo = cidFont.getAsDictionary(PdfName.CIDSystemInfo);
        if (cidinfo == null) {
            return null;
        }
        return cidinfo.containsKey(PdfName.Ordering) ? cidinfo.get(PdfName.Ordering).toString() : null;
    }

    @Override
    public Glyph getGlyph(int unicode) {
        Glyph glyph = this.getFontProgram().getGlyph(unicode);
        if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null) {
            Glyph notdef = this.getFontProgram().getGlyphByCode(0);
            glyph = notdef != null ? new Glyph(notdef, unicode) : new Glyph(-1, 0, unicode);
            this.notdefGlyphs.put(unicode, glyph);
        }
        return glyph;
    }

    @Override
    public byte[] convertToBytes(String text) {
        int len = text.length();
        char[] glyphs = new char[len];
        int i = 0;
        if (this.fontProgram.isFontSpecific()) {
            byte[] b = PdfEncodings.convertToBytes((String)text, (String)"symboltt");
            len = b.length;
            for (int k = 0; k < len; ++k) {
                Glyph glyph = this.fontProgram.getGlyph(b[k] & 0xFF);
                if (glyph == null || this.longTag.containsKey(glyph.getCode())) continue;
                this.longTag.put(glyph.getCode(), new int[]{glyph.getCode(), glyph.getWidth(), glyph.hasValidUnicode() ? glyph.getUnicode() : 0});
                glyphs[i++] = (char)this.cmapEncoding.getCmapCode(glyph.getCode());
            }
        } else {
            for (int k = 0; k < len; ++k) {
                int val;
                if (TextUtil.isSurrogatePair((String)text, (int)k)) {
                    val = TextUtil.convertToUtf32((String)text, (int)k);
                    ++k;
                } else {
                    val = text.charAt(k);
                }
                Glyph glyph = this.fontProgram.getGlyph(val);
                if (glyph == null) {
                    glyph = this.fontProgram.getGlyphByCode(0);
                }
                if (!this.longTag.containsKey(glyph.getCode())) {
                    this.longTag.put(glyph.getCode(), new int[]{glyph.getCode(), glyph.getWidth(), glyph.hasValidUnicode() ? glyph.getUnicode() : 0});
                }
                glyphs[i++] = (char)this.cmapEncoding.getCmapCode(glyph.getCode());
            }
        }
        String s = new String(glyphs, 0, i);
        try {
            return s.getBytes("UnicodeBigUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            throw new PdfException("TrueTypeFont", e);
        }
    }

    @Override
    public byte[] convertToBytes(GlyphLine glyphLine) {
        if (glyphLine != null) {
            char[] glyphs = new char[glyphLine.size()];
            for (int i = 0; i < glyphLine.size(); ++i) {
                Glyph glyph = glyphLine.get(i);
                glyphs[i] = (char)this.cmapEncoding.getCmapCode(glyph.getCode());
                int code = glyph.getCode();
                if (this.longTag.get(code) != null) continue;
                this.longTag.put(code, new int[]{code, glyph.getWidth(), glyph.hasValidUnicode() ? glyph.getUnicode() : 0});
            }
            String s = new String(glyphs, 0, glyphs.length);
            try {
                return s.getBytes("UnicodeBigUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new PdfException("TrueTypeFont", e);
            }
        }
        return null;
    }

    @Override
    public byte[] convertToBytes(Glyph glyph) {
        int code = glyph.getCode();
        if (this.longTag.get(code) == null) {
            this.longTag.put(code, new int[]{code, glyph.getWidth(), glyph.hasValidUnicode() ? glyph.getUnicode() : 0});
        }
        String s = new String(new char[]{(char)glyph.getCode()}, 0, 1);
        try {
            return s.getBytes("UnicodeBigUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            throw new PdfException("PdfType0Font", e);
        }
    }

    @Override
    public void writeText(GlyphLine text, int from, int to, PdfOutputStream stream) {
        StringBuilder bytes = new StringBuilder();
        for (int i = from; i <= to; ++i) {
            Glyph glyph = text.get(i);
            int code = glyph.getCode();
            bytes.append((char)this.cmapEncoding.getCmapCode(glyph.getCode()));
            if (this.longTag.get(code) != null) continue;
            this.longTag.put(code, new int[]{code, glyph.getWidth(), glyph.hasValidUnicode() ? glyph.getUnicode() : 0});
        }
        try {
            StreamUtil.writeHexedString((OutputStream)((Object)stream), (byte[])bytes.toString().getBytes("UnicodeBigUnmarked"));
        }
        catch (UnsupportedEncodingException e) {
            throw new PdfException("PdfType0Font", e);
        }
    }

    @Override
    public void writeText(String text, PdfOutputStream stream) {
        StreamUtil.writeHexedString((OutputStream)((Object)stream), (byte[])this.convertToBytes(text));
    }

    @Override
    public GlyphLine createGlyphLine(String content) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        if (this.cidFontType == 0) {
            int len = content.length();
            if (this.cmapEncoding.isDirect()) {
                for (int k = 0; k < len; ++k) {
                    Glyph glyph = this.fontProgram.getGlyphByCode((int)content.charAt(k));
                    if (glyph == null) continue;
                    glyphs.add(glyph);
                }
            } else {
                for (int k = 0; k < len; ++k) {
                    int ch;
                    if (TextUtil.isSurrogatePair((String)content, (int)k)) {
                        ch = TextUtil.convertToUtf32((String)content, (int)k);
                        ++k;
                    } else {
                        ch = content.charAt(k);
                    }
                    glyphs.add(this.getGlyph(ch));
                }
            }
        } else if (this.cidFontType == 2) {
            TrueTypeFont ttf = (TrueTypeFont)this.fontProgram;
            int len = content.length();
            if (ttf.isFontSpecific()) {
                byte[] b = PdfEncodings.convertToBytes((String)content, (String)"symboltt");
                len = b.length;
                for (int k = 0; k < len; ++k) {
                    Glyph glyph = this.fontProgram.getGlyph(b[k] & 0xFF);
                    if (glyph == null) continue;
                    glyphs.add(glyph);
                }
            } else {
                for (int k = 0; k < len; ++k) {
                    int val;
                    if (TextUtil.isSurrogatePair((String)content, (int)k)) {
                        val = TextUtil.convertToUtf32((String)content, (int)k);
                        ++k;
                    } else {
                        val = content.charAt(k);
                    }
                    glyphs.add(this.getGlyph(val));
                }
            }
        } else {
            throw new PdfException("font.has.no.suitable.cmap");
        }
        return new GlyphLine(glyphs);
    }

    @Override
    public String decode(PdfString content) {
        String cids = content.getValue();
        if (cids.length() == 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(cids.length() / 2);
        for (int i = 0; i < cids.length() - 1; i += 2) {
            int code = (cids.charAt(i) << 8) + cids.charAt(i + 1);
            Glyph glyph = this.fontProgram.getGlyphByCode(this.cmapEncoding.getCidCode(code));
            if (glyph != null && glyph.getChars() != null) {
                builder.append(glyph.getChars());
                continue;
            }
            builder.append('?');
        }
        return builder.toString();
    }

    @Override
    public float getContentWidth(PdfString content) {
        String cids = content.getValue();
        Glyph notdef = this.fontProgram.getGlyphByCode(0);
        float width = 0.0f;
        for (int i = 0; i < cids.length(); ++i) {
            Glyph glyph;
            int code = cids.charAt(i++);
            if (i < cids.length()) {
                code <<= 8;
                code |= cids.charAt(i);
            }
            if ((glyph = this.fontProgram.getGlyphByCode(this.cmapEncoding.getCidCode(code))) == null) {
                System.err.println(code);
            }
            width += glyph != null ? (float)glyph.getWidth() : (float)notdef.getWidth();
        }
        return width;
    }

    @Override
    protected PdfDictionary getFontDescriptor(String fontName) {
        PdfDictionary fontDescriptor = new PdfDictionary();
        PdfType0Font.markObjectAsIndirect(fontDescriptor);
        fontDescriptor.put(PdfName.Type, PdfName.FontDescriptor);
        fontDescriptor.put(PdfName.FontName, new PdfName(fontName));
        fontDescriptor.put(PdfName.FontBBox, new PdfArray(this.getFontProgram().getFontMetrics().getBbox()));
        fontDescriptor.put(PdfName.Ascent, new PdfNumber(this.getFontProgram().getFontMetrics().getTypoAscender()));
        fontDescriptor.put(PdfName.Descent, new PdfNumber(this.getFontProgram().getFontMetrics().getTypoDescender()));
        fontDescriptor.put(PdfName.CapHeight, new PdfNumber(this.getFontProgram().getFontMetrics().getCapHeight()));
        fontDescriptor.put(PdfName.ItalicAngle, new PdfNumber(this.getFontProgram().getFontMetrics().getItalicAngle()));
        fontDescriptor.put(PdfName.StemV, new PdfNumber(this.getFontProgram().getFontMetrics().getStemV()));
        fontDescriptor.put(PdfName.Flags, new PdfNumber(this.getFontProgram().getPdfFontFlags()));
        if (this.fontProgram.getFontIdentification().getPanose() != null) {
            PdfDictionary styleDictionary = new PdfDictionary();
            styleDictionary.put(PdfName.Panose, new PdfString(this.fontProgram.getFontIdentification().getPanose()).setHexWriting(true));
            fontDescriptor.put(PdfName.Style, styleDictionary);
        }
        return fontDescriptor;
    }

    public CMapEncoding getCmap() {
        return this.cmapEncoding;
    }

    @Override
    public void flush() {
        if (this.newFont) {
            this.flushFontData();
        }
        super.flush();
    }

    private void flushFontData() {
        if (this.cidFontType == 0) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Type0);
            String name = this.fontProgram.getFontNames().getFontName();
            String style = this.fontProgram.getFontNames().getStyle();
            if (style.length() > 0) {
                name = name + "-" + style;
            }
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(MessageFormat.format("{0}-{1}", name, this.cmapEncoding.getCmapName())));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, new PdfName(this.cmapEncoding.getCmapName()));
            PdfDictionary fontDescriptor = this.getFontDescriptor(name);
            int[][] metrics = (int[][])this.longTag.values().toArray((T[])new int[0][]);
            Arrays.sort(metrics, new MetricComparator());
            PdfDictionary cidFont = this.getCidFontType2(null, fontDescriptor, this.fontProgram.getFontNames().getFontName(), metrics);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.DescendantFonts, new PdfArray(cidFont));
            fontDescriptor.flush();
            cidFont.flush();
        } else if (this.cidFontType == 2) {
            PdfStream fontStream;
            TrueTypeFont ttf = (TrueTypeFont)this.getFontProgram();
            this.addRangeUni(ttf, this.longTag, true);
            int[][] metrics = (int[][])this.longTag.values().toArray((T[])new int[0][]);
            Arrays.sort(metrics, new MetricComparator());
            String fontName = ttf.getFontNames().getFontName();
            if (this.subset) {
                fontName = PdfType0Font.createSubsetPrefix() + fontName;
            }
            PdfDictionary fontDescriptor = this.getFontDescriptor(fontName);
            if (ttf.isCff()) {
                byte[] cffBytes = ttf.getFontStreamBytes();
                if (this.subset || this.subsetRanges != null) {
                    CFFFontSubset cff = new CFFFontSubset(ttf.getFontStreamBytes(), this.longTag);
                    cffBytes = cff.Process(cff.getNames()[0]);
                }
                fontStream = this.getPdfFontStream(cffBytes, new int[]{cffBytes.length});
                fontStream.put(PdfName.Subtype, new PdfName("CIDFontType0C"));
                ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(MessageFormat.format("{0}-{1}", fontName, this.cmapEncoding.getCmapName())));
                fontDescriptor.put(PdfName.FontFile3, fontStream);
            } else {
                byte[] ttfBytes = this.subset || ttf.getDirectoryOffset() != 0 ? ttf.getSubset(new LinkedHashSet<Integer>(this.longTag.keySet()), true) : ttf.getFontStreamBytes();
                fontStream = this.getPdfFontStream(ttfBytes, new int[]{ttfBytes.length});
                ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(fontName));
                fontDescriptor.put(PdfName.FontFile2, fontStream);
            }
            int maxGlyphId = ttf.getFontMetrics().getMaxGlyphId();
            byte[] cidSetBytes = new byte[ttf.getFontMetrics().getMaxGlyphId() / 8 + 1];
            int i = 0;
            while (i < maxGlyphId / 8) {
                int n = i++;
                cidSetBytes[n] = (byte)(cidSetBytes[n] | 0xFF);
            }
            for (i = 0; i < maxGlyphId % 8; ++i) {
                int n = cidSetBytes.length - 1;
                cidSetBytes[n] = (byte)(cidSetBytes[n] | rotbits[i]);
            }
            fontDescriptor.put(PdfName.CIDSet, new PdfStream(cidSetBytes));
            PdfDictionary cidFont = this.getCidFontType2(ttf, fontDescriptor, fontName, metrics);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Type0);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, new PdfName(this.cmapEncoding.getCmapName()));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.DescendantFonts, new PdfArray(cidFont));
            PdfStream toUnicode = this.getToUnicode((Object[])metrics);
            if (toUnicode != null) {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.ToUnicode, toUnicode);
                toUnicode.flush();
            }
            fontDescriptor.flush();
            cidFont.flush();
        } else {
            throw new IllegalStateException("Unsupported CID Font");
        }
    }

    protected PdfDictionary getCidFontType2(TrueTypeFont ttf, PdfDictionary fontDescriptor, String fontName, int[][] metrics) {
        PdfDictionary cidFont = new PdfDictionary();
        PdfType0Font.markObjectAsIndirect(cidFont);
        cidFont.put(PdfName.Type, PdfName.Font);
        cidFont.put(PdfName.FontDescriptor, fontDescriptor);
        if (ttf == null || ttf.isCff()) {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType0);
        } else {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType2);
            cidFont.put(PdfName.CIDToGIDMap, PdfName.Identity);
        }
        cidFont.put(PdfName.BaseFont, new PdfName(fontName));
        PdfDictionary cidInfo = new PdfDictionary();
        cidInfo.put(PdfName.Registry, new PdfString(this.cmapEncoding.getRegistry()));
        cidInfo.put(PdfName.Ordering, new PdfString(this.cmapEncoding.getOrdering()));
        cidInfo.put(PdfName.Supplement, new PdfNumber(this.cmapEncoding.getSupplement()));
        cidFont.put(PdfName.CIDSystemInfo, cidInfo);
        if (!this.vertical) {
            cidFont.put(PdfName.DW, new PdfNumber(1000));
            StringBuilder buf = new StringBuilder("[");
            int lastNumber = -10;
            boolean firstTime = true;
            for (int[] metric : metrics) {
                Glyph glyph = this.fontProgram.getGlyphByCode(metric[0]);
                if (glyph.getWidth() == 1000) continue;
                if (glyph.getCode() == lastNumber + 1) {
                    buf.append(' ').append(glyph.getWidth());
                } else {
                    if (!firstTime) {
                        buf.append(']');
                    }
                    firstTime = false;
                    buf.append(glyph.getCode()).append('[').append(glyph.getWidth());
                }
                lastNumber = glyph.getCode();
            }
            if (buf.length() > 1) {
                buf.append("]]");
                cidFont.put(PdfName.W, new PdfLiteral(buf.toString()));
            }
        } else {
            throw new UnsupportedOperationException("Vertical writing has not implemented yet.");
        }
        return cidFont;
    }

    public PdfStream getToUnicode(Object[] metrics) {
        ArrayList<Integer> unicodeGlyphs = new ArrayList<Integer>(metrics.length);
        for (int i = 0; i < metrics.length; ++i) {
            int[] metric = (int[])metrics[i];
            if (this.fontProgram.getGlyphByCode(metric[0]).getChars() == null) continue;
            unicodeGlyphs.add(metric[0]);
        }
        if (unicodeGlyphs.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><FFFF>\nendcodespacerange\n");
        int size = 0;
        for (int k = 0; k < unicodeGlyphs.size(); ++k) {
            if (size == 0) {
                if (k != 0) {
                    buf.append("endbfrange\n");
                }
                size = Math.min(100, unicodeGlyphs.size() - k);
                buf.append(size).append(" beginbfrange\n");
            }
            --size;
            String fromTo = CMapContentParser.toHex((int)((Integer)unicodeGlyphs.get(k)));
            Glyph glyph = this.fontProgram.getGlyphByCode(((Integer)unicodeGlyphs.get(k)).intValue());
            if (glyph.getChars() == null) continue;
            StringBuilder uni = new StringBuilder(glyph.getChars().length);
            for (char ch : glyph.getChars()) {
                uni.append(PdfType0Font.toHex4(ch));
            }
            buf.append(fromTo).append(fromTo).append('<').append(uni.toString()).append('>').append('\n');
        }
        buf.append("endbfrange\nendcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        return new PdfStream(PdfEncodings.convertToBytes((String)buf.toString(), null));
    }

    private static String toHex4(char ch) {
        String s = "0000" + Integer.toHexString(ch);
        return s.substring(s.length() - 4);
    }

    protected void addRangeUni(TrueTypeFont ttf, Map<Integer, int[]> longTag, boolean includeMetrics) {
        if (!(this.subset || this.subsetRanges == null && ttf.getDirectoryOffset() <= 0)) {
            int[] nArray;
            if (this.subsetRanges == null && ttf.getDirectoryOffset() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 65535;
            } else {
                nArray = PdfType0Font.compactRanges(this.subsetRanges);
            }
            int[] rg = nArray;
            Map usemap = ttf.getActiveCmap();
            assert (usemap != null);
            for (Map.Entry e : usemap.entrySet()) {
                int[] nArray3;
                int[] v = (int[])e.getValue();
                Integer gi = v[0];
                if (longTag.containsKey(v[0])) continue;
                int c = (Integer)e.getKey();
                boolean skip = true;
                for (int k = 0; k < rg.length; k += 2) {
                    if (c < rg[k] || c > rg[k + 1]) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
                if (includeMetrics) {
                    int[] nArray4 = new int[3];
                    nArray4[0] = v[0];
                    nArray4[1] = v[1];
                    nArray3 = nArray4;
                    nArray4[2] = c;
                } else {
                    nArray3 = null;
                }
                longTag.put(gi, nArray3);
            }
        }
    }

    private String getCompatibleUniMap(String registry) {
        String uniMap = "";
        Iterator iterator = ((Set)CidFontProperties.getRegistryNames().get(registry + "_Uni")).iterator();
        while (iterator.hasNext()) {
            String name;
            uniMap = name = (String)iterator.next();
            if ((!name.endsWith("V") || !this.vertical) && (name.endsWith("V") || this.vertical)) continue;
            break;
        }
        return uniMap;
    }

    public static String getUniMapFromOrdering(String ordering) {
        switch (ordering) {
            case "CNS1": {
                return "UniCNS-UTF16-H";
            }
            case "Japan1": {
                return "UniJIS-UTF16-H";
            }
            case "Korea1": {
                return "UniKS-UTF16-H";
            }
            case "GB1": {
                return "UniGB-UTF16-H";
            }
            case "Identity": {
                return "Identity-H";
            }
        }
        return null;
    }

    private static class MetricComparator
    implements Comparator<int[]> {
        private MetricComparator() {
        }

        @Override
        public int compare(int[] o1, int[] o2) {
            int m1 = o1[0];
            int m2 = o2[0];
            return Integer.compare(m1, m2);
        }
    }
}

