/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.io.font.AdobeGlyphList;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.io.util.TextUtil;
import java.util.Objects;
import java.util.StringTokenizer;

public class FontEncoding {
    private static final byte[] emptyBytes = new byte[0];
    public static final String FONT_SPECIFIC = "FontSpecific";
    public static final String NOTDEF = ".notdef";
    protected String baseEncoding;
    protected boolean fontSpecific = false;
    protected IntHashtable unicodeToCode = new IntHashtable(256);
    protected int[] codeToUnicode = ArrayUtil.fillWithValue(new int[256], -1);
    protected String[] differences;
    protected IntHashtable unicodeDifferences = new IntHashtable(256);

    protected FontEncoding() {
    }

    public static FontEncoding createFontEncoding(String baseEncoding) {
        FontEncoding encoding = new FontEncoding();
        encoding.baseEncoding = FontEncoding.normalizeEncoding(baseEncoding);
        if (encoding.baseEncoding.startsWith("#")) {
            encoding.fillCustomEncoding();
        } else {
            encoding.fillNamedEncoding();
        }
        return encoding;
    }

    public static FontEncoding createEmptyFontEncoding() {
        FontEncoding encoding = new FontEncoding();
        encoding.baseEncoding = null;
        encoding.fontSpecific = false;
        encoding.differences = new String[256];
        for (int ch = 0; ch < 256; ++ch) {
            encoding.unicodeDifferences.put(ch, ch);
        }
        return encoding;
    }

    public static FontEncoding createFontSpecificEncoding() {
        FontEncoding encoding = new FontEncoding();
        encoding.fontSpecific = true;
        FontEncoding.fillFontEncoding(encoding);
        return encoding;
    }

    public static void fillFontEncoding(FontEncoding encoding) {
        for (int ch = 0; ch < 256; ++ch) {
            encoding.unicodeToCode.put(ch, ch);
            encoding.codeToUnicode[ch] = ch;
            encoding.unicodeDifferences.put(ch, ch);
        }
    }

    public String getBaseEncoding() {
        return this.baseEncoding;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    public boolean addSymbol(int code, int unicode) {
        if (code < 0 || code > 255) {
            return false;
        }
        String glyphName = AdobeGlyphList.unicodeToName(unicode);
        if (glyphName != null) {
            this.unicodeToCode.put(unicode, code);
            this.codeToUnicode[code] = unicode;
            this.differences[code] = glyphName;
            this.unicodeDifferences.put(unicode, unicode);
            return true;
        }
        return false;
    }

    public int getUnicode(int index) {
        return this.codeToUnicode[index];
    }

    public int getUnicodeDifference(int index) {
        return this.unicodeDifferences.get(index);
    }

    public boolean hasDifferences() {
        return this.differences != null;
    }

    public String getDifference(int index) {
        return this.differences != null ? this.differences[index] : null;
    }

    public void setDifference(int index, String difference) {
        if (index >= 0 && this.differences != null && index < this.differences.length) {
            this.differences[index] = difference;
        }
    }

    public byte[] convertToBytes(String text) {
        if (text == null || text.length() == 0) {
            return emptyBytes;
        }
        int ptr = 0;
        byte[] bytes = new byte[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            if (!this.unicodeToCode.containsKey(text.charAt(i))) continue;
            bytes[ptr++] = (byte)this.convertToByte(text.charAt(i));
        }
        return ArrayUtil.shortenArray(bytes, ptr);
    }

    public int convertToByte(int unicode) {
        return this.unicodeToCode.get(unicode);
    }

    public boolean canEncode(int unicode) {
        return this.unicodeToCode.containsKey(unicode) || TextUtil.isNonPrintable(unicode) || TextUtil.isNewLine(unicode);
    }

    public boolean canDecode(int code) {
        return this.codeToUnicode[code] > -1;
    }

    public boolean isBuiltWith(String encoding) {
        return Objects.equals(FontEncoding.normalizeEncoding(encoding), this.baseEncoding);
    }

    protected void fillCustomEncoding() {
        int uni;
        this.differences = new String[256];
        StringTokenizer tok = new StringTokenizer(this.baseEncoding.substring(1), " ,\t\n\r\f");
        if (tok.nextToken().equals("full")) {
            while (tok.hasMoreTokens()) {
                String order = tok.nextToken();
                String name = tok.nextToken();
                uni = Integer.parseInt(tok.nextToken(), 16);
                int uniName = AdobeGlyphList.nameToUnicode(name);
                int orderK = order.startsWith("'") ? (int)order.charAt(1) : Integer.parseInt(order);
                this.unicodeToCode.put(uni, orderK %= 256);
                this.codeToUnicode[orderK] = uni;
                this.differences[orderK] = name;
                this.unicodeDifferences.put(uni, uniName);
            }
        } else {
            int k = 0;
            if (tok.hasMoreTokens()) {
                k = Integer.parseInt(tok.nextToken());
            }
            while (tok.hasMoreTokens() && k < 256) {
                String hex = tok.nextToken();
                uni = Integer.parseInt(hex, 16) % 65536;
                String name = AdobeGlyphList.unicodeToName(uni);
                if (name == null) {
                    name = "uni" + hex;
                }
                this.unicodeToCode.put(uni, k);
                this.codeToUnicode[k] = uni;
                this.differences[k] = name;
                this.unicodeDifferences.put(uni, uni);
                ++k;
            }
        }
        for (int k = 0; k < 256; ++k) {
            if (this.differences[k] != null) continue;
            this.differences[k] = NOTDEF;
        }
    }

    protected void fillNamedEncoding() {
        boolean stdEncoding;
        PdfEncodings.convertToBytes(" ", this.baseEncoding);
        boolean bl = stdEncoding = "Cp1252".equals(this.baseEncoding) || "MacRoman".equals(this.baseEncoding);
        if (!stdEncoding && this.differences == null) {
            this.differences = new String[256];
        }
        byte[] b = new byte[256];
        for (int k = 0; k < 256; ++k) {
            b[k] = (byte)k;
        }
        String str = PdfEncodings.convertToString(b, this.baseEncoding);
        char[] encoded = str.toCharArray();
        for (int ch = 0; ch < 256; ++ch) {
            int uni = encoded[ch];
            String name = AdobeGlyphList.unicodeToName(uni);
            if (name == null) {
                name = NOTDEF;
            } else {
                this.unicodeToCode.put(uni, ch);
                this.codeToUnicode[ch] = uni;
                this.unicodeDifferences.put(uni, uni);
            }
            if (this.differences == null) continue;
            this.differences[ch] = name;
        }
    }

    protected void fillStandardEncoding() {
        int[] encoded = PdfEncodings.standardEncoding;
        for (int ch = 0; ch < 256; ++ch) {
            int uni = encoded[ch];
            String name = AdobeGlyphList.unicodeToName(uni);
            if (name == null) {
                name = NOTDEF;
            } else {
                this.unicodeToCode.put(uni, ch);
                this.codeToUnicode[ch] = uni;
                this.unicodeDifferences.put(uni, uni);
            }
            if (this.differences == null) continue;
            this.differences[ch] = name;
        }
    }

    protected static String normalizeEncoding(String enc) {
        String tmp;
        switch (tmp = enc == null ? "" : StringNormalizer.toLowerCase((String)enc)) {
            case "": 
            case "winansi": 
            case "winansiencoding": {
                return "Cp1252";
            }
            case "macroman": 
            case "macromanencoding": {
                return "MacRoman";
            }
            case "zapfdingbatsencoding": {
                return "ZapfDingbats";
            }
        }
        return enc;
    }
}

