/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.html2pdf.css.apply.impl.MultiColumnCssApplierUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.MulticolContainer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.Map;

public class TdTagWorker
implements ITagWorker,
IDisplayAware {
    private final Cell cell;
    private Div childOfMulticolContainer;
    protected MulticolContainer multicolContainer;
    private final WaitingInlineElementsHelper inlineHelper;
    private final String display;

    public TdTagWorker(IElementNode element, ProcessorContext context) {
        Integer colspan = CssDimensionParsingUtils.parseInteger((String)element.getAttribute("colspan"));
        Integer rowspan = CssDimensionParsingUtils.parseInteger((String)element.getAttribute("rowspan"));
        colspan = colspan != null ? colspan : 1;
        rowspan = rowspan != null ? rowspan : 1;
        this.cell = new Cell(rowspan.intValue(), colspan.intValue());
        this.cell.setPadding(0.0f);
        Map styles = element.getStyles();
        if (styles.containsKey("column-count") || styles.containsKey("column-width")) {
            this.multicolContainer = new MulticolContainer();
            this.childOfMulticolContainer = new Div();
            this.multicolContainer.add((IBlockElement)this.childOfMulticolContainer);
            MultiColumnCssApplierUtil.applyMultiCol(styles, context, (IPropertyContainer)this.multicolContainer);
            this.cell.add((IBlockElement)this.multicolContainer);
        }
        this.inlineHelper = new WaitingInlineElementsHelper((String)styles.get("white-space"), (String)styles.get("text-transform"));
        this.display = (String)styles.get("display");
        AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.cell, element);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves(this.getCellContainer());
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        boolean processed = false;
        if (childTagWorker instanceof IDisplayAware && "inline-block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()) && childTagWorker.getElementResult() instanceof IBlockElement) {
            this.inlineHelper.add((IBlockElement)childTagWorker.getElementResult());
            processed = true;
        } else if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcesssed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                if (propertyContainer instanceof IBlockElement && "inline-block".equals(((SpanTagWorker)childTagWorker).getElementDisplay(propertyContainer))) {
                    this.inlineHelper.add((IBlockElement)propertyContainer);
                    continue;
                }
                allChildrenProcesssed = this.processChild(propertyContainer) && allChildrenProcesssed;
            }
            processed = allChildrenProcesssed;
        } else if (childTagWorker.getElementResult() instanceof ILeafElement) {
            this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
            processed = true;
        } else {
            processed = this.processChild(childTagWorker.getElementResult());
        }
        return processed;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.cell;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    private boolean processChild(IPropertyContainer propertyContainer) {
        boolean processed = false;
        this.inlineHelper.flushHangingLeaves(this.getCellContainer());
        if (propertyContainer instanceof IBlockElement) {
            if (this.childOfMulticolContainer == null) {
                this.cell.add((IBlockElement)propertyContainer);
            } else {
                this.childOfMulticolContainer.add((IBlockElement)propertyContainer);
            }
            processed = true;
        }
        return processed;
    }

    private IPropertyContainer getCellContainer() {
        return this.childOfMulticolContainer == null ? this.cell : this.childOfMulticolContainer;
    }
}

