/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.CssConstants;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.DashedBorder;
import com.itextpdf.layout.borders.DoubleBorder;
import com.itextpdf.layout.borders.GrooveBorder;
import com.itextpdf.layout.borders.InsetBorder;
import com.itextpdf.layout.borders.OutsetBorder;
import com.itextpdf.layout.borders.RidgeBorder;
import com.itextpdf.layout.borders.RoundDotsBorder;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.property.BorderRadius;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.resolve.CssDefaults;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Map;

public class BorderStyleApplierUtil {
    private BorderStyleApplierUtil() {
    }

    public static void applyBorders(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        BorderRadius[] borderRadii;
        float rem;
        float em = CssUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
        Border[] bordersArray = BorderStyleApplierUtil.getBordersArray(cssProps, em, rem = context.getCssContext().getRootFontSize());
        if (bordersArray[0] != null) {
            element.setProperty(13, (Object)bordersArray[0]);
        }
        if (bordersArray[1] != null) {
            element.setProperty(12, (Object)bordersArray[1]);
        }
        if (bordersArray[2] != null) {
            element.setProperty(10, (Object)bordersArray[2]);
        }
        if (bordersArray[3] != null) {
            element.setProperty(11, (Object)bordersArray[3]);
        }
        if ((borderRadii = BorderStyleApplierUtil.getBorderRadiiArray(cssProps, em, rem))[0] != null) {
            element.setProperty(110, (Object)borderRadii[0]);
        }
        if (borderRadii[1] != null) {
            element.setProperty(111, (Object)borderRadii[1]);
        }
        if (borderRadii[2] != null) {
            element.setProperty(112, (Object)borderRadii[2]);
        }
        if (borderRadii[3] != null) {
            element.setProperty(113, (Object)borderRadii[3]);
        }
    }

    public static Border[] getBordersArray(Map<String, String> styles, float em, float rem) {
        Border leftBorder;
        Border bottomBorder;
        Border rightBorder;
        Border topBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-top-width"), styles.get("border-top-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-top-color"), em, rem);
        Border[] borders = new Border[]{topBorder, rightBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-right-width"), styles.get("border-right-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-right-color"), em, rem), bottomBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-bottom-width"), styles.get("border-bottom-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-bottom-color"), em, rem), leftBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-left-width"), styles.get("border-left-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-left-color"), em, rem)};
        return borders;
    }

    public static Border getCertainBorder(String borderWidth, String borderStyle, String borderColor, float em, float rem) {
        UnitValue unitValue;
        if (borderStyle == null || "none".equals(borderStyle)) {
            return null;
        }
        if (borderWidth == null) {
            borderWidth = CssDefaults.getDefaultValue((String)"border-width");
        }
        if (CssConstants.BORDER_WIDTH_VALUES.contains(borderWidth)) {
            if ("thin".equals(borderWidth)) {
                borderWidth = "1px";
            } else if ("medium".equals(borderWidth)) {
                borderWidth = "2px";
            } else if ("thick".equals(borderWidth)) {
                borderWidth = "3px";
            }
        }
        if ((unitValue = CssUtils.parseLengthValueToPt((String)borderWidth, (float)em, (float)rem)) == null) {
            return null;
        }
        if (unitValue.isPercentValue()) {
            return null;
        }
        float borderWidthValue = unitValue.getValue();
        SolidBorder border = null;
        if (borderWidthValue > 0.0f) {
            DeviceRgb color = (DeviceRgb)ColorConstants.BLACK;
            float opacity = 1.0f;
            if (borderColor != null) {
                if (!"transparent".equals(borderColor)) {
                    float[] rgbaColor = CssUtils.parseRgbaColor((String)borderColor);
                    color = new DeviceRgb(rgbaColor[0], rgbaColor[1], rgbaColor[2]);
                    opacity = rgbaColor[3];
                } else {
                    opacity = 0.0f;
                }
            } else if ("groove".equals(borderStyle) || "ridge".equals(borderStyle) || "inset".equals(borderStyle) || "outset".equals(borderStyle)) {
                color = new DeviceRgb(212, 208, 200);
            }
            switch (borderStyle) {
                case "solid": {
                    border = new SolidBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "dashed": {
                    border = new DashedBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "dotted": {
                    border = new RoundDotsBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "double": {
                    border = new DoubleBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "groove": {
                    border = new GrooveBorder(color, borderWidthValue, opacity);
                    break;
                }
                case "ridge": {
                    border = new RidgeBorder(color, borderWidthValue, opacity);
                    break;
                }
                case "inset": {
                    border = new InsetBorder(color, borderWidthValue, opacity);
                    break;
                }
                case "outset": {
                    border = new OutsetBorder(color, borderWidthValue, opacity);
                    break;
                }
                default: {
                    border = null;
                }
            }
        }
        return border;
    }

    public static BorderRadius[] getBorderRadiiArray(Map<String, String> styles, float em, float rem) {
        UnitValue[] borderTopLeftRadiusUV;
        BorderRadius[] borderRadii = new BorderRadius[4];
        BorderRadius borderRadius = null;
        UnitValue borderRadiusUV = CssUtils.parseLengthValueToPt((String)styles.get("border-radius"), (float)em, (float)rem);
        if (null != borderRadiusUV) {
            borderRadius = new BorderRadius(borderRadiusUV);
        }
        borderRadii[0] = null == (borderTopLeftRadiusUV = CssUtils.parseSpecificCornerBorderRadius((String)styles.get("border-top-left-radius"), (float)em, (float)rem)) ? borderRadius : new BorderRadius(borderTopLeftRadiusUV[0], borderTopLeftRadiusUV[1]);
        UnitValue[] borderTopRightRadiusUV = CssUtils.parseSpecificCornerBorderRadius((String)styles.get("border-top-right-radius"), (float)em, (float)rem);
        borderRadii[1] = null == borderTopRightRadiusUV ? borderRadius : new BorderRadius(borderTopRightRadiusUV[0], borderTopRightRadiusUV[1]);
        UnitValue[] borderBottomRightRadiusUV = CssUtils.parseSpecificCornerBorderRadius((String)styles.get("border-bottom-right-radius"), (float)em, (float)rem);
        borderRadii[2] = null == borderBottomRightRadiusUV ? borderRadius : new BorderRadius(borderBottomRightRadiusUV[0], borderBottomRightRadiusUV[1]);
        UnitValue[] borderBottomLeftRadiusUV = CssUtils.parseSpecificCornerBorderRadius((String)styles.get("border-bottom-left-radius"), (float)em, (float)rem);
        borderRadii[3] = null == borderBottomLeftRadiusUV ? borderRadius : new BorderRadius(borderBottomLeftRadiusUV[0], borderBottomLeftRadiusUV[1]);
        return borderRadii;
    }

    @Deprecated
    public static UnitValue getBorderRadius(Map<String, String> styles, float em, float rem) {
        String borderRadius = styles.get("border-radius");
        return CssUtils.parseLengthValueToPt((String)borderRadius, (float)em, (float)rem);
    }

    private static String getSpecificBorderColorOrDefaultColor(Map<String, String> styles, String specificBorderColorProperty) {
        String borderColor = styles.get(specificBorderColorProperty);
        if (borderColor == null || "currentcolor".equals(borderColor)) {
            borderColor = styles.get("color");
        }
        return borderColor;
    }
}

