/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields.merging;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfFormFieldMergeUtil;
import com.itextpdf.forms.fields.merging.OnDuplicateFormFieldNameStrategy;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeFieldsStrategy
implements OnDuplicateFormFieldNameStrategy {
    @Override
    public boolean execute(PdfFormField firstField, PdfFormField secondField, boolean throwExceptionOnError) {
        PdfName firstFieldFormType = firstField.getFormType();
        PdfObject firstFieldValue = firstField.getValue();
        PdfObject secondFieldValue = secondField.getValue();
        PdfObject firstFieldDefaultValue = firstField.getDefaultValue();
        PdfObject secondFieldDefaultValue = secondField.getDefaultValue();
        boolean isValueEqualsOrNull = MergeFieldsStrategy.isValueEqualsOrNull(firstFieldValue, secondFieldValue);
        boolean isDefaultValueEqualsOrNull = MergeFieldsStrategy.isValueEqualsOrNull(firstFieldDefaultValue, secondFieldDefaultValue);
        if (firstFieldFormType != null && !firstFieldFormType.equals((Object)secondField.getFormType()) || !isValueEqualsOrNull || !isDefaultValueEqualsOrNull) {
            if (throwExceptionOnError) {
                throw new PdfException(MessageFormatUtil.format((String)"Cannot merge form fields with the same names. Partial name is {0}. Field dictionaries with the same fully qualified field name shall have the same field type (FT), value (V), and default value (DV).", (Object[])new Object[]{firstField.getPartialFieldName()}));
            }
            Logger logger = LoggerFactory.getLogger(MergeFieldsStrategy.class);
            logger.warn(MessageFormatUtil.format((String)"Cannot merge form fields with the same fully qualified names. Partial name is {0}. Field type (FT), value (V), and default value (DV) should be the same", (Object[])new Object[]{firstField.getPartialFieldName()}));
            return false;
        }
        PdfFormFieldMergeUtil.mergeFormFields(firstField, secondField, throwExceptionOnError);
        return true;
    }

    private static boolean isValueEqualsOrNull(PdfObject obj1, PdfObject obj2) {
        if (obj1 == null || obj2 == null) {
            return true;
        }
        if (obj1 instanceof PdfString && obj2 instanceof PdfString) {
            return ((PdfString)obj1).toUnicodeString().equals(((PdfString)obj2).toUnicodeString());
        }
        return obj1.equals(obj2);
    }
}

