/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.commons.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.itextpdf.commons.json.JsonArray;
import com.itextpdf.commons.json.JsonBoolean;
import com.itextpdf.commons.json.JsonNull;
import com.itextpdf.commons.json.JsonNumber;
import com.itextpdf.commons.json.JsonObject;
import com.itextpdf.commons.json.JsonString;
import com.itextpdf.commons.json.JsonValue;
import java.io.IOException;
import java.util.Map;

class JsonValueSerializer
extends JsonSerializer<JsonValue> {
    JsonValueSerializer() {
    }

    public void serialize(JsonValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value instanceof JsonNull) {
            gen.writeNull();
        } else if (value instanceof JsonBoolean) {
            gen.writeBoolean(((JsonBoolean)value).getValue());
        } else if (value instanceof JsonNumber) {
            double doubleValue = ((JsonNumber)value).getValue();
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                throw new IOException("NAN and INFINITE are not supported");
            }
            if ((double)((long)doubleValue) == doubleValue) {
                gen.writeNumber((long)doubleValue);
            } else {
                gen.writeNumber(doubleValue);
            }
        } else if (value instanceof JsonString) {
            String stringValue = ((JsonString)value).getValue();
            if (stringValue == null) {
                gen.writeNull();
            } else {
                gen.writeString(stringValue);
            }
        } else if (value instanceof JsonArray) {
            gen.writeStartArray();
            for (JsonValue item : ((JsonArray)value).getValues()) {
                gen.writeObject((Object)item);
            }
            gen.writeEndArray();
        } else if (value instanceof JsonObject) {
            gen.writeStartObject();
            for (Map.Entry<String, JsonValue> entry : ((JsonObject)value).getFields().entrySet()) {
                gen.writeFieldName(entry.getKey());
                gen.writeObject((Object)entry.getValue());
            }
            gen.writeEndObject();
        } else {
            throw new IllegalStateException("Unknown JsonValue subclass: " + value.getClass());
        }
    }
}

