/*
 * Decompiled with CFR 0.152.
 */
package com.intershop.release.version;

import com.intershop.release.version.DigitPos;
import com.intershop.release.version.VersionType;
import javax.annotation.Nonnull;

public class NormalVersion
implements Comparable<NormalVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    private final int hotfix;
    private final VersionType type;

    public NormalVersion(int major, int minor, int patch, int hotfix) {
        if (major < 0 || minor < 0 || patch < 0 || hotfix < 0) {
            throw new IllegalArgumentException("Major, minor, patch and hotfix versions MUST be non-negative integers.");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.hotfix = hotfix;
        this.type = VersionType.fourDigits;
    }

    public NormalVersion(int major, int minor, int patch) {
        this.hotfix = 0;
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Major, minor, patch and hotfix versions MUST be non-negative integers.");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.type = VersionType.threeDigits;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getHotfix() {
        return this.hotfix;
    }

    public VersionType getVersionType() {
        return this.type;
    }

    public NormalVersion incrementMajor() {
        if (this.type == VersionType.fourDigits) {
            return new NormalVersion(this.major + 1, 0, 0, 0);
        }
        return new NormalVersion(this.major + 1, 0, 0);
    }

    public NormalVersion incrementMinor() {
        if (this.type == VersionType.fourDigits) {
            return new NormalVersion(this.major, this.minor + 1, 0, 0);
        }
        return new NormalVersion(this.major, this.minor + 1, 0);
    }

    public NormalVersion incrementPatch() {
        if (this.type == VersionType.fourDigits) {
            return new NormalVersion(this.major, this.minor, this.patch + 1, 0);
        }
        return new NormalVersion(this.major, this.minor, this.patch + 1);
    }

    public NormalVersion incrementHotfix() {
        if (this.type == VersionType.fourDigits) {
            return new NormalVersion(this.major, this.minor, this.patch, this.hotfix + 1);
        }
        throw new UnsupportedOperationException("This normal version does not support four digits");
    }

    public NormalVersion incrementLatest() {
        return this.incrementLatest(this.type == VersionType.threeDigits ? DigitPos.PATCH : DigitPos.HOTFIX);
    }

    public NormalVersion incrementLatest(DigitPos pos) {
        switch (pos) {
            case HOTFIX: {
                return this.incrementPatch();
            }
            case PATCH: {
                return this.incrementMinor();
            }
            case MINOR: {
                return this.incrementMajor();
            }
            case MAJOR: {
                return this.incrementMajor();
            }
        }
        return this;
    }

    public NormalVersion incrementVersion(DigitPos pos) {
        if (pos == null) {
            pos = this.type == VersionType.threeDigits ? DigitPos.PATCH : DigitPos.HOTFIX;
        }
        switch (pos) {
            case HOTFIX: {
                return this.incrementHotfix();
            }
            case PATCH: {
                return this.incrementPatch();
            }
            case MINOR: {
                return this.incrementMinor();
            }
            case MAJOR: {
                return this.incrementMajor();
            }
        }
        return this;
    }

    public String toStringFor(int firstDigits) {
        switch (firstDigits) {
            case 1: {
                return String.format("%d", this.major);
            }
            case 2: {
                return String.format("%d.%d", this.major, this.minor);
            }
            case 3: {
                return String.format("%d.%d.%d", this.major, this.minor, this.patch);
            }
            case 4: {
                if (this.type == VersionType.threeDigits) {
                    throw new UnsupportedOperationException("The number of digits must be less than 4.");
                }
                return String.format("%d.%d.%d.%d", this.major, this.minor, this.patch, this.hotfix);
            }
        }
        throw new UnsupportedOperationException("The number of digits must be greater than 0 and less than 3 or 4, depends on the version type.");
    }

    public NormalVersion clone() {
        if (this.type == VersionType.threeDigits) {
            return new NormalVersion(this.major, this.minor, this.patch);
        }
        return new NormalVersion(this.major, this.minor, this.patch, this.hotfix);
    }

    public String toString() {
        if (this.type == VersionType.fourDigits) {
            return String.format("%d.%d.%d.%d", this.major, this.minor, this.patch, this.hotfix);
        }
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(@Nonnull NormalVersion other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0 && (result = this.patch - other.patch) == 0 && this.type == VersionType.fourDigits) {
            result = this.hotfix - other.hotfix;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NormalVersion)) {
            return false;
        }
        return this.compareTo((NormalVersion)other) == 0;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.major;
        hash = 31 * hash + this.minor;
        hash = 31 * hash + this.patch;
        if (this.type == VersionType.fourDigits) {
            hash = 31 * hash + this.hotfix;
        }
        return hash;
    }
}

