/*
 * Decompiled with CFR 0.152.
 */
package com.intershop.release.version;

import java.util.Arrays;
import javax.annotation.Nonnull;

public class MetadataVersion
implements Comparable<MetadataVersion> {
    static final MetadataVersion NULL = new MetadataVersion(null);
    private final String[] identifiers;

    public MetadataVersion(String[] identifiers) {
        this.identifiers = identifiers;
    }

    public MetadataVersion increment() {
        if (this.identifiers != null) {
            String[] ids = (String[])this.identifiers.clone();
            String lastId = ids[ids.length - 1];
            if (MetadataVersion.isInt(lastId)) {
                int intId = Integer.parseInt(lastId);
                ids[ids.length - 1] = String.valueOf(++intId);
            }
            return new MetadataVersion(ids);
        }
        throw new NullPointerException("Metadata version is NULL");
    }

    public boolean isEmpty() {
        return this.identifiers == null || this.identifiers.length == 0;
    }

    public static boolean isEmpty(MetadataVersion metadataVersion) {
        return metadataVersion == null || metadataVersion.isEmpty();
    }

    public MetadataVersion clone() {
        if (!this.toString().isEmpty()) {
            return new MetadataVersion((String[])this.identifiers.clone());
        }
        return NULL;
    }

    public String toString() {
        if (this.identifiers != null) {
            StringBuilder sb = new StringBuilder();
            for (String ident : this.identifiers) {
                sb.append(ident);
            }
            return sb.toString();
        }
        return "";
    }

    private static boolean isInt(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(@Nonnull MetadataVersion other) {
        if (other.isEmpty() && !this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty() && this.isEmpty()) {
            return 0;
        }
        if (!other.isEmpty() && this.isEmpty()) {
            return 1;
        }
        int result = this.compareIdentifierArrays(other.identifiers);
        if (result == 0) {
            result = (this.identifiers != null ? this.identifiers.length : 0) - (other.identifiers != null ? other.identifiers.length : 0);
        }
        return result;
    }

    private int compareIdentifierArrays(String[] otherIdentifiers) {
        int result = 0;
        int length = MetadataVersion.getLeastCommonArrayLength(this.identifiers, otherIdentifiers);
        for (int i = 0; i < length && (result = MetadataVersion.compareIdentifiers(this.identifiers[i], otherIdentifiers[i])) == 0; ++i) {
        }
        return result;
    }

    private static int getLeastCommonArrayLength(String[] arr1, String[] arr2) {
        return (arr1 != null ? arr1.length : 0) <= (arr2 != null ? arr2.length : 0) ? (arr1 != null ? arr1.length : 0) : (arr2 != null ? arr2.length : 0);
    }

    private static int compareIdentifiers(String ident1, String ident2) {
        if (MetadataVersion.isInt(ident1) && MetadataVersion.isInt(ident2)) {
            return Integer.parseInt(ident1) - Integer.parseInt(ident2);
        }
        return ident1.compareTo(ident2);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetadataVersion)) {
            return false;
        }
        return this.compareTo((MetadataVersion)other) == 0;
    }

    public int hashCode() {
        if (this.identifiers != null) {
            return Arrays.hashCode(this.identifiers);
        }
        return 0;
    }
}

