/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.EJavaSignal;
import com.ib.client.EReader;
import com.ib.client.EWrapper;
import com.ib.client.Execution;
import com.ib.client.ExecutionFilter;
import com.ib.client.Order;
import com.ib.client.OrderState;
import com.ib.client.OrderStatus;
import com.ib.client.ScannerSubscription;
import com.ib.client.TagValue;
import com.ib.client.TickType;
import com.ib.client.Types;
import com.ib.controller.AccountSummaryTag;
import com.ib.controller.AdvisorUtil;
import com.ib.controller.Alias;
import com.ib.controller.ApiConnection;
import com.ib.controller.Bar;
import com.ib.controller.ConcurrentHashSet;
import com.ib.controller.Group;
import com.ib.controller.MarketValueTag;
import com.ib.controller.Position;
import com.ib.controller.Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ApiController
implements EWrapper {
    private ApiConnection m_client;
    private final ApiConnection.ILogger m_outLogger;
    private final ApiConnection.ILogger m_inLogger;
    private int m_reqId;
    private int m_orderId;
    private final IConnectionHandler m_connectionHandler;
    private ITradeReportHandler m_tradeReportHandler;
    private IAdvisorHandler m_advisorHandler;
    private IScannerHandler m_scannerHandler;
    private ITimeHandler m_timeHandler;
    private IBulletinHandler m_bulletinHandler;
    private final HashMap<Integer, IInternalHandler> m_contractDetailsMap = new HashMap();
    private final HashMap<Integer, IOptHandler> m_optionCompMap = new HashMap();
    private final HashMap<Integer, IEfpHandler> m_efpMap = new HashMap();
    private final HashMap<Integer, ITopMktDataHandler> m_topMktDataMap = new HashMap();
    private final HashMap<Integer, IDeepMktDataHandler> m_deepMktDataMap = new HashMap();
    private final HashMap<Integer, IScannerHandler> m_scannerMap = new HashMap();
    private final HashMap<Integer, IRealTimeBarHandler> m_realTimeBarMap = new HashMap();
    private final HashMap<Integer, IHistoricalDataHandler> m_historicalDataMap = new HashMap();
    private final HashMap<Integer, IFundamentalsHandler> m_fundMap = new HashMap();
    private final HashMap<Integer, IOrderHandler> m_orderHandlers = new HashMap();
    private final HashMap<Integer, IAccountSummaryHandler> m_acctSummaryHandlers = new HashMap();
    private final HashMap<Integer, IMarketValueSummaryHandler> m_mktValSummaryHandlers = new HashMap();
    private final ConcurrentHashSet<IPositionHandler> m_positionHandlers = new ConcurrentHashSet();
    private final ConcurrentHashSet<IAccountHandler> m_accountHandlers = new ConcurrentHashSet();
    private final ConcurrentHashSet<ILiveOrderHandler> m_liveOrderHandlers = new ConcurrentHashSet();

    public ApiConnection client() {
        return this.m_client;
    }

    public ApiController(IConnectionHandler handler, ApiConnection.ILogger inLogger, ApiConnection.ILogger outLogger) {
        this.m_connectionHandler = handler;
        this.m_client = new ApiConnection(this, inLogger, outLogger);
        this.m_inLogger = inLogger;
        this.m_outLogger = outLogger;
    }

    private void startMsgProcessingThread() {
        final EJavaSignal signal = new EJavaSignal();
        final EReader reader = new EReader(this.client(), signal);
        reader.start();
        new Thread(){

            @Override
            public void run() {
                while (ApiController.this.client().isConnected()) {
                    signal.waitForSignal();
                    try {
                        reader.processMsgs();
                    }
                    catch (IOException e) {
                        ApiController.this.error(e);
                    }
                }
            }
        }.start();
    }

    public void connect(String host, int port, int clientId, String connectionOpts) {
        this.m_client.eConnect(host, port, clientId);
        this.startMsgProcessingThread();
        this.sendEOM();
    }

    public void disconnect() {
        this.m_client.eDisconnect();
        this.m_connectionHandler.disconnected();
        this.sendEOM();
    }

    @Override
    public void managedAccounts(String accounts) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(accounts, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        this.m_connectionHandler.accountList(list);
        this.recEOM();
    }

    @Override
    public void nextValidId(int orderId) {
        this.m_orderId = orderId;
        this.m_reqId = this.m_orderId + 10000000;
        if (this.m_connectionHandler != null) {
            this.m_connectionHandler.connected();
        }
        this.recEOM();
    }

    @Override
    public void error(Exception e) {
        this.m_connectionHandler.error(e);
    }

    @Override
    public void error(int id, int errorCode, String errorMsg) {
        IInternalHandler hand;
        IOrderHandler handler = this.m_orderHandlers.get(id);
        if (handler != null) {
            handler.handle(errorCode, errorMsg);
        }
        for (ILiveOrderHandler liveHandler : this.m_liveOrderHandlers) {
            liveHandler.handle(id, errorCode, errorMsg);
        }
        if (errorCode == 200 && (hand = this.m_contractDetailsMap.remove(id)) != null) {
            hand.contractDetailsEnd();
        }
        this.m_connectionHandler.message(id, errorCode, errorMsg);
        this.recEOM();
    }

    @Override
    public void connectionClosed() {
        this.m_connectionHandler.disconnected();
    }

    public void reqAccountUpdates(boolean subscribe, String acctCode, IAccountHandler handler) {
        this.m_accountHandlers.add(handler);
        this.m_client.reqAccountUpdates(subscribe, acctCode);
        this.sendEOM();
    }

    @Override
    public void updateAccountValue(String tag, String value, String currency, String account) {
        if (tag.equals("Currency")) {
            return;
        }
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.accountValue(account, tag, value, currency);
        }
        this.recEOM();
    }

    @Override
    public void updateAccountTime(String timeStamp) {
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.accountTime(timeStamp);
        }
        this.recEOM();
    }

    @Override
    public void accountDownloadEnd(String account) {
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.accountDownloadEnd(account);
        }
        this.recEOM();
    }

    @Override
    public void updatePortfolio(Contract contract, int positionIn, double marketPrice, double marketValue, double averageCost, double unrealizedPNL, double realizedPNL, String account) {
        contract.exchange(contract.primaryExch());
        Position position = new Position(contract, account, positionIn, marketPrice, marketValue, averageCost, unrealizedPNL, realizedPNL);
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.updatePortfolio(position);
        }
        this.recEOM();
    }

    public void reqAccountSummary(String group, AccountSummaryTag[] tags, IAccountSummaryHandler handler) {
        StringBuilder sb = new StringBuilder();
        for (AccountSummaryTag tag : tags) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append((Object)tag);
        }
        int reqId = this.m_reqId++;
        this.m_acctSummaryHandlers.put(reqId, handler);
        this.m_client.reqAccountSummary(reqId, group, sb.toString());
        this.sendEOM();
    }

    public void cancelAccountSummary(IAccountSummaryHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_acctSummaryHandlers, handler);
        if (reqId != null) {
            this.m_client.cancelAccountSummary(reqId);
            this.sendEOM();
        }
    }

    public void reqMarketValueSummary(String group, IMarketValueSummaryHandler handler) {
        int reqId = this.m_reqId++;
        this.m_mktValSummaryHandlers.put(reqId, handler);
        this.m_client.reqAccountSummary(reqId, group, "$LEDGER");
        this.sendEOM();
    }

    public void cancelMarketValueSummary(IMarketValueSummaryHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_mktValSummaryHandlers, handler);
        if (reqId != null) {
            this.m_client.cancelAccountSummary(reqId);
            this.sendEOM();
        }
    }

    @Override
    public void accountSummary(int reqId, String account, String tag, String value, String currency) {
        IMarketValueSummaryHandler handler2;
        if (tag.equals("Currency")) {
            return;
        }
        IAccountSummaryHandler handler = this.m_acctSummaryHandlers.get(reqId);
        if (handler != null) {
            handler.accountSummary(account, AccountSummaryTag.valueOf(tag), value, currency);
        }
        if ((handler2 = this.m_mktValSummaryHandlers.get(reqId)) != null) {
            handler2.marketValueSummary(account, MarketValueTag.valueOf(tag), value, currency);
        }
        this.recEOM();
    }

    @Override
    public void accountSummaryEnd(int reqId) {
        IMarketValueSummaryHandler handler2;
        IAccountSummaryHandler handler = this.m_acctSummaryHandlers.get(reqId);
        if (handler != null) {
            handler.accountSummaryEnd();
        }
        if ((handler2 = this.m_mktValSummaryHandlers.get(reqId)) != null) {
            handler2.marketValueSummaryEnd();
        }
        this.recEOM();
    }

    public void reqPositions(IPositionHandler handler) {
        this.m_positionHandlers.add(handler);
        this.m_client.reqPositions();
        this.sendEOM();
    }

    public void cancelPositions(IPositionHandler handler) {
        this.m_positionHandlers.remove(handler);
        this.m_client.cancelPositions();
        this.sendEOM();
    }

    @Override
    public void position(String account, Contract contract, int pos, double avgCost) {
        for (IPositionHandler handler : this.m_positionHandlers) {
            handler.position(account, contract, pos, avgCost);
        }
        this.recEOM();
    }

    @Override
    public void positionEnd() {
        for (IPositionHandler handler : this.m_positionHandlers) {
            handler.positionEnd();
        }
        this.recEOM();
    }

    public void reqContractDetails(Contract contract, final IContractDetailsHandler processor) {
        final ArrayList list = new ArrayList();
        this.internalReqContractDetails(contract, new IInternalHandler(){

            @Override
            public void contractDetails(ContractDetails data) {
                list.add(data);
            }

            @Override
            public void contractDetailsEnd() {
                processor.contractDetails(list);
            }
        });
        this.sendEOM();
    }

    private void internalReqContractDetails(Contract contract, IInternalHandler processor) {
        int reqId = this.m_reqId++;
        this.m_contractDetailsMap.put(reqId, processor);
        this.m_client.reqContractDetails(reqId, contract);
        this.sendEOM();
    }

    @Override
    public void contractDetails(int reqId, ContractDetails contractDetails) {
        IInternalHandler handler = this.m_contractDetailsMap.get(reqId);
        if (handler != null) {
            handler.contractDetails(contractDetails);
        } else {
            this.show("Error: no contract details handler for reqId " + reqId);
        }
        this.recEOM();
    }

    @Override
    public void bondContractDetails(int reqId, ContractDetails contractDetails) {
        IInternalHandler handler = this.m_contractDetailsMap.get(reqId);
        if (handler != null) {
            handler.contractDetails(contractDetails);
        } else {
            this.show("Error: no bond contract details handler for reqId " + reqId);
        }
        this.recEOM();
    }

    @Override
    public void contractDetailsEnd(int reqId) {
        IInternalHandler handler = this.m_contractDetailsMap.remove(reqId);
        if (handler != null) {
            handler.contractDetailsEnd();
        } else {
            this.show("Error: no contract details handler for reqId " + reqId);
        }
        this.recEOM();
    }

    public void reqTopMktData(Contract contract, String genericTickList, boolean snapshot, ITopMktDataHandler handler) {
        int reqId = this.m_reqId++;
        this.m_topMktDataMap.put(reqId, handler);
        this.m_client.reqMktData(reqId, contract, genericTickList, snapshot, Collections.emptyList());
        this.sendEOM();
    }

    public void reqOptionMktData(Contract contract, String genericTickList, boolean snapshot, IOptHandler handler) {
        int reqId = this.m_reqId++;
        this.m_topMktDataMap.put(reqId, handler);
        this.m_optionCompMap.put(reqId, handler);
        this.m_client.reqMktData(reqId, contract, genericTickList, snapshot, Collections.emptyList());
        this.sendEOM();
    }

    public void reqEfpMktData(Contract contract, String genericTickList, boolean snapshot, IEfpHandler handler) {
        int reqId = this.m_reqId++;
        this.m_topMktDataMap.put(reqId, handler);
        this.m_efpMap.put(reqId, handler);
        this.m_client.reqMktData(reqId, contract, genericTickList, snapshot, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelTopMktData(ITopMktDataHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_topMktDataMap, handler);
        if (reqId != null) {
            this.m_client.cancelMktData(reqId);
        } else {
            this.show("Error: could not cancel top market data");
        }
        this.sendEOM();
    }

    public void cancelOptionMktData(IOptHandler handler) {
        this.cancelTopMktData(handler);
        ApiController.getAndRemoveKey(this.m_optionCompMap, handler);
    }

    public void cancelEfpMktData(IEfpHandler handler) {
        this.cancelTopMktData(handler);
        ApiController.getAndRemoveKey(this.m_efpMap, handler);
    }

    public void reqMktDataType(Types.MktDataType type) {
        this.m_client.reqMarketDataType(type.ordinal());
        this.sendEOM();
    }

    @Override
    public void tickPrice(int reqId, int tickType, double price, int canAutoExecute) {
        ITopMktDataHandler handler = this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickPrice(TickType.get(tickType), price, canAutoExecute);
        }
        this.recEOM();
    }

    @Override
    public void tickGeneric(int reqId, int tickType, double value) {
        ITopMktDataHandler handler = this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickPrice(TickType.get(tickType), value, 0);
        }
        this.recEOM();
    }

    @Override
    public void tickSize(int reqId, int tickType, int size) {
        ITopMktDataHandler handler = this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickSize(TickType.get(tickType), size);
        }
        this.recEOM();
    }

    @Override
    public void tickString(int reqId, int tickType, String value) {
        ITopMktDataHandler handler = this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickString(TickType.get(tickType), value);
        }
        this.recEOM();
    }

    @Override
    public void tickEFP(int reqId, int tickType, double basisPoints, String formattedBasisPoints, double impliedFuture, int holdDays, String futureLastTradeDate, double dividendImpact, double dividendsToLastTradeDate) {
        IEfpHandler handler = this.m_efpMap.get(reqId);
        if (handler != null) {
            handler.tickEFP(tickType, basisPoints, formattedBasisPoints, impliedFuture, holdDays, futureLastTradeDate, dividendImpact, dividendsToLastTradeDate);
        }
        this.recEOM();
    }

    @Override
    public void tickSnapshotEnd(int reqId) {
        ITopMktDataHandler handler = this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickSnapshotEnd();
        }
        this.recEOM();
    }

    @Override
    public void marketDataType(int reqId, int marketDataType) {
        ITopMktDataHandler handler = this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.marketDataType(Types.MktDataType.get(marketDataType));
        }
        this.recEOM();
    }

    public void reqDeepMktData(Contract contract, int numRows, IDeepMktDataHandler handler) {
        int reqId = this.m_reqId++;
        this.m_deepMktDataMap.put(reqId, handler);
        ArrayList<TagValue> mktDepthOptions = new ArrayList<TagValue>();
        this.m_client.reqMktDepth(reqId, contract, numRows, mktDepthOptions);
        this.sendEOM();
    }

    public void cancelDeepMktData(IDeepMktDataHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_deepMktDataMap, handler);
        if (reqId != null) {
            this.m_client.cancelMktDepth(reqId);
            this.sendEOM();
        }
    }

    @Override
    public void updateMktDepth(int reqId, int position, int operation, int side, double price, int size) {
        IDeepMktDataHandler handler = this.m_deepMktDataMap.get(reqId);
        if (handler != null) {
            handler.updateMktDepth(position, null, Types.DeepType.get(operation), Types.DeepSide.get(side), price, size);
        }
        this.recEOM();
    }

    @Override
    public void updateMktDepthL2(int reqId, int position, String marketMaker, int operation, int side, double price, int size) {
        IDeepMktDataHandler handler = this.m_deepMktDataMap.get(reqId);
        if (handler != null) {
            handler.updateMktDepth(position, marketMaker, Types.DeepType.get(operation), Types.DeepSide.get(side), price, size);
        }
        this.recEOM();
    }

    public void reqOptionVolatility(Contract c, double optPrice, double underPrice, IOptHandler handler) {
        int reqId = this.m_reqId++;
        this.m_optionCompMap.put(reqId, handler);
        this.m_client.calculateImpliedVolatility(reqId, c, optPrice, underPrice);
        this.sendEOM();
    }

    public void reqOptionComputation(Contract c, double vol, double underPrice, IOptHandler handler) {
        int reqId = this.m_reqId++;
        this.m_optionCompMap.put(reqId, handler);
        this.m_client.calculateOptionPrice(reqId, c, vol, underPrice);
        this.sendEOM();
    }

    void cancelOptionComp(IOptHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_optionCompMap, handler);
        if (reqId != null) {
            this.m_client.cancelCalculateOptionPrice(reqId);
            this.sendEOM();
        }
    }

    @Override
    public void tickOptionComputation(int reqId, int tickType, double impliedVol, double delta, double optPrice, double pvDividend, double gamma, double vega, double theta, double undPrice) {
        IOptHandler handler = this.m_optionCompMap.get(reqId);
        if (handler != null) {
            handler.tickOptionComputation(TickType.get(tickType), impliedVol, delta, optPrice, pvDividend, gamma, vega, theta, undPrice);
        } else {
            System.out.println(String.format("not handled %s %s %s %s %s %s %s %s %s", tickType, impliedVol, delta, optPrice, pvDividend, gamma, vega, theta, undPrice));
        }
        this.recEOM();
    }

    public void reqExecutions(ExecutionFilter filter, ITradeReportHandler handler) {
        this.m_tradeReportHandler = handler;
        this.m_client.reqExecutions(this.m_reqId++, filter);
        this.sendEOM();
    }

    @Override
    public void execDetails(int reqId, Contract contract, Execution execution) {
        if (this.m_tradeReportHandler != null) {
            int i = execution.execId().lastIndexOf(46);
            String tradeKey = execution.execId().substring(0, i);
            this.m_tradeReportHandler.tradeReport(tradeKey, contract, execution);
        }
        this.recEOM();
    }

    @Override
    public void execDetailsEnd(int reqId) {
        if (this.m_tradeReportHandler != null) {
            this.m_tradeReportHandler.tradeReportEnd();
        }
        this.recEOM();
    }

    @Override
    public void commissionReport(CommissionReport commissionReport) {
        if (this.m_tradeReportHandler != null) {
            int i = commissionReport.m_execId.lastIndexOf(46);
            String tradeKey = commissionReport.m_execId.substring(0, i);
            this.m_tradeReportHandler.commissionReport(tradeKey, commissionReport);
        }
        this.recEOM();
    }

    public void reqAdvisorData(Types.FADataType type, IAdvisorHandler handler) {
        this.m_advisorHandler = handler;
        this.m_client.requestFA(type.ordinal());
        this.sendEOM();
    }

    public void updateGroups(ArrayList<Group> groups) {
        this.m_client.replaceFA(Types.FADataType.GROUPS.ordinal(), AdvisorUtil.getGroupsXml(groups));
        this.sendEOM();
    }

    public void updateProfiles(ArrayList<Profile> profiles) {
        this.m_client.replaceFA(Types.FADataType.PROFILES.ordinal(), AdvisorUtil.getProfilesXml(profiles));
        this.sendEOM();
    }

    @Override
    public final void receiveFA(int faDataType, String xml) {
        if (this.m_advisorHandler == null) {
            return;
        }
        Types.FADataType type = Types.FADataType.get(faDataType);
        switch (type) {
            case GROUPS: {
                ArrayList<Group> groups = AdvisorUtil.getGroups(xml);
                this.m_advisorHandler.groups(groups);
                break;
            }
            case PROFILES: {
                ArrayList<Profile> profiles = AdvisorUtil.getProfiles(xml);
                this.m_advisorHandler.profiles(profiles);
                break;
            }
            case ALIASES: {
                ArrayList<Alias> aliases = AdvisorUtil.getAliases(xml);
                this.m_advisorHandler.aliases(aliases);
            }
        }
        this.recEOM();
    }

    public void placeOrModifyOrder(Contract contract, Order order, IOrderHandler handler) {
        if (order.orderId() == 0) {
            order.orderId(this.m_orderId++);
            if (handler != null) {
                this.m_orderHandlers.put(order.orderId(), handler);
            }
        }
        this.m_client.placeOrder(contract, order);
        this.sendEOM();
    }

    public void cancelOrder(int orderId) {
        this.m_client.cancelOrder(orderId);
        this.sendEOM();
    }

    public void cancelAllOrders() {
        this.m_client.reqGlobalCancel();
        this.sendEOM();
    }

    public void exerciseOption(String account, Contract contract, Types.ExerciseType type, int quantity, boolean override) {
        this.m_client.exerciseOptions(this.m_reqId++, contract, type.ordinal(), quantity, account, override ? 1 : 0);
        this.sendEOM();
    }

    public void removeOrderHandler(IOrderHandler handler) {
        ApiController.getAndRemoveKey(this.m_orderHandlers, handler);
    }

    public void reqLiveOrders(ILiveOrderHandler handler) {
        this.m_liveOrderHandlers.add(handler);
        this.m_client.reqAllOpenOrders();
        this.sendEOM();
    }

    public void takeTwsOrders(ILiveOrderHandler handler) {
        this.m_liveOrderHandlers.add(handler);
        this.m_client.reqOpenOrders();
        this.sendEOM();
    }

    public void takeFutureTwsOrders(ILiveOrderHandler handler) {
        this.m_liveOrderHandlers.add(handler);
        this.m_client.reqAutoOpenOrders(true);
        this.sendEOM();
    }

    public void removeLiveOrderHandler(ILiveOrderHandler handler) {
        this.m_liveOrderHandlers.remove(handler);
    }

    @Override
    public void openOrder(int orderId, Contract contract, Order order, OrderState orderState) {
        IOrderHandler handler = this.m_orderHandlers.get(orderId);
        if (handler != null) {
            handler.orderState(orderState);
        }
        if (!order.whatIf()) {
            for (ILiveOrderHandler liveHandler : this.m_liveOrderHandlers) {
                liveHandler.openOrder(contract, order, orderState);
            }
        }
        this.recEOM();
    }

    @Override
    public void openOrderEnd() {
        for (ILiveOrderHandler handler : this.m_liveOrderHandlers) {
            handler.openOrderEnd();
        }
        this.recEOM();
    }

    @Override
    public void orderStatus(int orderId, String status, int filled, int remaining, double avgFillPrice, int permId, int parentId, double lastFillPrice, int clientId, String whyHeld) {
        IOrderHandler handler = this.m_orderHandlers.get(orderId);
        if (handler != null) {
            handler.orderStatus(OrderStatus.valueOf(status), filled, remaining, avgFillPrice, permId, parentId, lastFillPrice, clientId, whyHeld);
        }
        for (ILiveOrderHandler liveOrderHandler : this.m_liveOrderHandlers) {
            liveOrderHandler.orderStatus(orderId, OrderStatus.valueOf(status), filled, remaining, avgFillPrice, permId, parentId, lastFillPrice, clientId, whyHeld);
        }
        this.recEOM();
    }

    public void reqScannerParameters(IScannerHandler handler) {
        this.m_scannerHandler = handler;
        this.m_client.reqScannerParameters();
        this.sendEOM();
    }

    public void reqScannerSubscription(ScannerSubscription sub, IScannerHandler handler) {
        int reqId = this.m_reqId++;
        this.m_scannerMap.put(reqId, handler);
        ArrayList<TagValue> scannerSubscriptionOptions = new ArrayList<TagValue>();
        this.m_client.reqScannerSubscription(reqId, sub, scannerSubscriptionOptions);
        this.sendEOM();
    }

    public void cancelScannerSubscription(IScannerHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_scannerMap, handler);
        if (reqId != null) {
            this.m_client.cancelScannerSubscription(reqId);
            this.sendEOM();
        }
    }

    @Override
    public void scannerParameters(String xml) {
        this.m_scannerHandler.scannerParameters(xml);
        this.recEOM();
    }

    @Override
    public void scannerData(int reqId, int rank, ContractDetails contractDetails, String distance, String benchmark, String projection, String legsStr) {
        IScannerHandler handler = this.m_scannerMap.get(reqId);
        if (handler != null) {
            handler.scannerData(rank, contractDetails, legsStr);
        }
        this.recEOM();
    }

    @Override
    public void scannerDataEnd(int reqId) {
        IScannerHandler handler = this.m_scannerMap.get(reqId);
        if (handler != null) {
            handler.scannerDataEnd();
        }
        this.recEOM();
    }

    public void reqHistoricalData(Contract contract, String endDateTime, int duration, Types.DurationUnit durationUnit, Types.BarSize barSize, Types.WhatToShow whatToShow, boolean rthOnly, IHistoricalDataHandler handler) {
        int reqId = this.m_reqId++;
        this.m_historicalDataMap.put(reqId, handler);
        String durationStr = duration + " " + durationUnit.toString().charAt(0);
        this.m_client.reqHistoricalData(reqId, contract, endDateTime, durationStr, barSize.toString(), whatToShow.toString(), rthOnly ? 1 : 0, 2, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelHistoricalData(IHistoricalDataHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_historicalDataMap, handler);
        if (reqId != null) {
            this.m_client.cancelHistoricalData(reqId);
            this.sendEOM();
        }
    }

    @Override
    public void historicalData(int reqId, String date, double open, double high, double low, double close, int volume, int count, double wap, boolean hasGaps) {
        IHistoricalDataHandler handler = this.m_historicalDataMap.get(reqId);
        if (handler != null) {
            if (date.startsWith("finished")) {
                handler.historicalDataEnd();
            } else {
                long longDate;
                if (date.length() == 8) {
                    int year = Integer.parseInt(date.substring(0, 4));
                    int month = Integer.parseInt(date.substring(4, 6));
                    int day = Integer.parseInt(date.substring(6));
                    longDate = new Date(year - 1900, month - 1, day).getTime() / 1000L;
                } else {
                    longDate = Long.parseLong(date);
                }
                Bar bar = new Bar(longDate, high, low, open, close, wap, volume, count);
                handler.historicalData(bar, hasGaps);
            }
        }
        this.recEOM();
    }

    public void reqRealTimeBars(Contract contract, Types.WhatToShow whatToShow, boolean rthOnly, IRealTimeBarHandler handler) {
        int reqId = this.m_reqId++;
        this.m_realTimeBarMap.put(reqId, handler);
        ArrayList<TagValue> realTimeBarsOptions = new ArrayList<TagValue>();
        this.m_client.reqRealTimeBars(reqId, contract, 0, whatToShow.toString(), rthOnly, realTimeBarsOptions);
        this.sendEOM();
    }

    public void cancelRealtimeBars(IRealTimeBarHandler handler) {
        Integer reqId = ApiController.getAndRemoveKey(this.m_realTimeBarMap, handler);
        if (reqId != null) {
            this.m_client.cancelRealTimeBars(reqId);
            this.sendEOM();
        }
    }

    @Override
    public void realtimeBar(int reqId, long time, double open, double high, double low, double close, long volume, double wap, int count) {
        IRealTimeBarHandler handler = this.m_realTimeBarMap.get(reqId);
        if (handler != null) {
            Bar bar = new Bar(time, high, low, open, close, wap, volume, count);
            handler.realtimeBar(bar);
        }
        this.recEOM();
    }

    public void reqFundamentals(Contract contract, Types.FundamentalType reportType, IFundamentalsHandler handler) {
        int reqId = this.m_reqId++;
        this.m_fundMap.put(reqId, handler);
        this.m_client.reqFundamentalData(reqId, contract, reportType.getApiString());
        this.sendEOM();
    }

    @Override
    public void fundamentalData(int reqId, String data) {
        IFundamentalsHandler handler = this.m_fundMap.get(reqId);
        if (handler != null) {
            handler.fundamentals(data);
        }
        this.recEOM();
    }

    public void reqCurrentTime(ITimeHandler handler) {
        this.m_timeHandler = handler;
        this.m_client.reqCurrentTime();
        this.sendEOM();
    }

    @Override
    public void currentTime(long time) {
        this.m_timeHandler.currentTime(time);
        this.recEOM();
    }

    public void reqBulletins(boolean allMessages, IBulletinHandler handler) {
        this.m_bulletinHandler = handler;
        this.m_client.reqNewsBulletins(allMessages);
        this.sendEOM();
    }

    public void cancelBulletins() {
        this.m_client.cancelNewsBulletins();
    }

    @Override
    public void updateNewsBulletin(int msgId, int msgType, String message, String origExchange) {
        this.m_bulletinHandler.bulletin(msgId, Types.NewsType.get(msgType), message, origExchange);
        this.recEOM();
    }

    @Override
    public void verifyMessageAPI(String apiData) {
    }

    @Override
    public void verifyCompleted(boolean isSuccessful, String errorText) {
    }

    @Override
    public void verifyAndAuthMessageAPI(String apiData, String xyzChallange) {
    }

    @Override
    public void verifyAndAuthCompleted(boolean isSuccessful, String errorText) {
    }

    @Override
    public void displayGroupList(int reqId, String groups) {
    }

    @Override
    public void displayGroupUpdated(int reqId, String contractInfo) {
    }

    @Override
    public void deltaNeutralValidation(int reqId, DeltaNeutralContract underComp) {
        this.show("RECEIVED DN VALIDATION");
        this.recEOM();
    }

    protected void sendEOM() {
        this.m_outLogger.log("\n");
    }

    private void recEOM() {
        this.m_inLogger.log("\n");
    }

    public void show(String string) {
        this.m_connectionHandler.show(string);
    }

    private static <K, V> K getAndRemoveKey(HashMap<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            map.remove(entry.getKey());
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void error(String str) {
        throw new RuntimeException();
    }

    @Override
    public void connectAck() {
        this.m_client.startAPI();
    }

    public static interface IBulletinHandler {
        public void bulletin(int var1, Types.NewsType var2, String var3, String var4);
    }

    public static interface ITimeHandler {
        public void currentTime(long var1);
    }

    public static interface IFundamentalsHandler {
        public void fundamentals(String var1);
    }

    public static interface IRealTimeBarHandler {
        public void realtimeBar(Bar var1);
    }

    public static interface IHistoricalDataHandler {
        public void historicalData(Bar var1, boolean var2);

        public void historicalDataEnd();
    }

    public static interface IScannerHandler {
        public void scannerParameters(String var1);

        public void scannerData(int var1, ContractDetails var2, String var3);

        public void scannerDataEnd();
    }

    public static interface ILiveOrderHandler {
        public void openOrder(Contract var1, Order var2, OrderState var3);

        public void openOrderEnd();

        public void orderStatus(int var1, OrderStatus var2, int var3, int var4, double var5, long var7, int var9, double var10, int var12, String var13);

        public void handle(int var1, int var2, String var3);
    }

    public static interface IOrderHandler {
        public void orderState(OrderState var1);

        public void orderStatus(OrderStatus var1, int var2, int var3, double var4, long var6, int var8, double var9, int var11, String var12);

        public void handle(int var1, String var2);
    }

    public static interface IAdvisorHandler {
        public void groups(ArrayList<Group> var1);

        public void profiles(ArrayList<Profile> var1);

        public void aliases(ArrayList<Alias> var1);
    }

    public static interface ITradeReportHandler {
        public void tradeReport(String var1, Contract var2, Execution var3);

        public void tradeReportEnd();

        public void commissionReport(String var1, CommissionReport var2);
    }

    public static interface IDeepMktDataHandler {
        public void updateMktDepth(int var1, String var2, Types.DeepType var3, Types.DeepSide var4, double var5, int var7);
    }

    public static class TopMktDataAdapter
    implements ITopMktDataHandler {
        @Override
        public void tickPrice(TickType tickType, double price, int canAutoExecute) {
        }

        @Override
        public void tickSize(TickType tickType, int size) {
        }

        @Override
        public void tickString(TickType tickType, String value) {
        }

        @Override
        public void tickSnapshotEnd() {
        }

        @Override
        public void marketDataType(Types.MktDataType marketDataType) {
        }
    }

    public static interface IOptHandler
    extends ITopMktDataHandler {
        public void tickOptionComputation(TickType var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16);
    }

    public static interface IEfpHandler
    extends ITopMktDataHandler {
        public void tickEFP(int var1, double var2, String var4, double var5, int var7, String var8, double var9, double var11);
    }

    public static interface ITopMktDataHandler {
        public void tickPrice(TickType var1, double var2, int var4);

        public void tickSize(TickType var1, int var2);

        public void tickString(TickType var1, String var2);

        public void tickSnapshotEnd();

        public void marketDataType(Types.MktDataType var1);
    }

    private static interface IInternalHandler {
        public void contractDetails(ContractDetails var1);

        public void contractDetailsEnd();
    }

    public static interface IContractDetailsHandler {
        public void contractDetails(ArrayList<ContractDetails> var1);
    }

    public static interface IPositionHandler {
        public void position(String var1, Contract var2, int var3, double var4);

        public void positionEnd();
    }

    public static interface IMarketValueSummaryHandler {
        public void marketValueSummary(String var1, MarketValueTag var2, String var3, String var4);

        public void marketValueSummaryEnd();
    }

    public static interface IAccountSummaryHandler {
        public void accountSummary(String var1, AccountSummaryTag var2, String var3, String var4);

        public void accountSummaryEnd();
    }

    public static interface IAccountHandler {
        public void accountValue(String var1, String var2, String var3, String var4);

        public void accountTime(String var1);

        public void accountDownloadEnd(String var1);

        public void updatePortfolio(Position var1);
    }

    public static interface IConnectionHandler {
        public void connected();

        public void disconnected();

        public void accountList(ArrayList<String> var1);

        public void error(Exception var1);

        public void message(int var1, int var2, String var3);

        public void show(String var1);
    }
}

